/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.jnr.ffi.provider.converters;

import com.simba.cassandra.shaded.jnr.ffi.Pointer;
import com.simba.cassandra.shaded.jnr.ffi.Runtime;
import com.simba.cassandra.shaded.jnr.ffi.Struct;
import com.simba.cassandra.shaded.jnr.ffi.mapper.FromNativeContext;
import com.simba.cassandra.shaded.jnr.ffi.mapper.FromNativeConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class StructByReferenceFromNativeConverter
implements FromNativeConverter<Struct, Pointer> {
    private final Constructor<? extends Struct> constructor;

    public static FromNativeConverter<Struct, Pointer> getInstance(Class structClass, FromNativeContext toNativeContext) {
        try {
            return new StructByReferenceFromNativeConverter(structClass.getConstructor(Runtime.class));
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(structClass.getName() + " has no constructor that accepts jnr.ffi.Runtime");
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    StructByReferenceFromNativeConverter(Constructor<? extends Struct> constructor) {
        this.constructor = constructor;
    }

    @Override
    public Struct fromNative(Pointer nativeValue, FromNativeContext context) {
        try {
            Struct s = this.constructor.newInstance(context.getRuntime());
            s.useMemory(nativeValue);
            return s;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<Pointer> nativeType() {
        return Pointer.class;
    }
}

