/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.aeprocessor.aebuilder.statement;

import com.simba.cassandra.dsi.dataengine.utilities.ParameterType;
import com.simba.cassandra.sqlengine.aeprocessor.AEUtils;
import com.simba.cassandra.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.simba.cassandra.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.simba.cassandra.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEProcedure;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AEProcedureCall;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEDefaultParameter;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.simba.cassandra.sqlengine.dsiext.dataengine.ProcedureParameterMetadata;
import com.simba.cassandra.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.simba.cassandra.sqlengine.dsiext.dataengine.StoredProcedure;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.parser.parsetree.IPTNode;
import com.simba.cassandra.sqlengine.parser.parsetree.PTListNode;
import com.simba.cassandra.sqlengine.parser.parsetree.PTNonterminalNode;
import com.simba.cassandra.sqlengine.parser.type.PTListType;
import com.simba.cassandra.sqlengine.parser.type.PTNonterminalType;
import com.simba.cassandra.sqlengine.parser.type.PTPositionalType;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.List;

public class AEProcedureCallBuilder
extends AEBuilderBase<AEProcedureCall> {
    private final SqlDataEngine m_dataEngine;

    public AEProcedureCallBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
        this.m_dataEngine = aEQueryScope.getDataEngine();
    }

    @Override
    public AEProcedureCall visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        assert (PTNonterminalType.PROCEDURE_CALL == pTNonterminalNode.getNonterminalType());
        return this.buildProcedureCall(pTNonterminalNode);
    }

    private AEProcedureCall buildProcedureCall(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        if (2 != pTNonterminalNode.numChildren()) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        AEProcCallInfo aEProcCallInfo = this.buildProcCallInfo(pTNonterminalNode);
        AEProcedure aEProcedure = new AEProcedure(aEProcCallInfo.m_procedure, aEProcCallInfo.m_params, aEProcCallInfo.m_callHasReturnValue);
        return new AEProcedureCall(aEProcedure);
    }

    private AEProcCallInfo buildProcCallInfo(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        String string;
        PTNonterminalNode pTNonterminalNode2 = (PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.PROCEDURE);
        assert (null != pTNonterminalNode2 && !pTNonterminalNode2.isEmptyNode());
        PTNonterminalNode pTNonterminalNode3 = (PTNonterminalNode)pTNonterminalNode2.getChild(PTPositionalType.PROCEDURE_NAME);
        assert (null != pTNonterminalNode3 && !pTNonterminalNode3.isEmptyNode());
        assert (!pTNonterminalNode3.getChild(PTPositionalType.PROCEDURE_IDENT).isEmptyNode());
        String string2 = AEUtils.getIdentifierString(pTNonterminalNode3.getChild(PTPositionalType.PROCEDURE_IDENT));
        String string3 = AEUtils.getIdentifierString(pTNonterminalNode3.getChild(PTPositionalType.CATALOG_IDENT));
        StoredProcedure storedProcedure = this.m_dataEngine.openProcedure(string3, string = AEUtils.getIdentifierString(pTNonterminalNode3.getChild(PTPositionalType.SCHEMA_IDENT)), string2);
        if (null == storedProcedure) {
            if (null != string) {
                String string4 = string3 + "." + string + "." + string2;
            } else {
                String string5 = string2;
            }
            throw SQLEngineExceptionFactory.invalidScalarFnNameException(String.format("Procedure %s:%s:%s not found", string3, string, string2));
        }
        return this.buildParamsList(pTNonterminalNode, storedProcedure);
    }

    private AEProcCallInfo buildParamsList(PTNonterminalNode pTNonterminalNode, StoredProcedure storedProcedure) throws ErrorException {
        AEValueExpr aEValueExpr;
        List<ProcedureParameterMetadata> list;
        PTListNode pTListNode;
        Object object;
        boolean bl = false;
        AEValueExprList aEValueExprList = new AEValueExprList();
        AEQueryScope aEQueryScope = new AEQueryScope(this.m_dataEngine);
        AEValueExprBuilder aEValueExprBuilder = new AEValueExprBuilder(aEQueryScope);
        assert (null != pTNonterminalNode.getChild(PTPositionalType.RETURN_VALUE));
        if (!pTNonterminalNode.getChild(PTPositionalType.RETURN_VALUE).isEmptyNode()) {
            bl = true;
            object = (AEValueExpr)aEValueExprBuilder.build(pTNonterminalNode.getChild(PTPositionalType.RETURN_VALUE));
            aEValueExprList.addNode(object);
        }
        assert (null != pTNonterminalNode.getChild(PTPositionalType.PROCEDURE));
        object = ((PTNonterminalNode)pTNonterminalNode.getChild(PTPositionalType.PROCEDURE)).getChild(PTPositionalType.PARAM_LIST);
        PTListNode pTListNode2 = pTListNode = object.isEmptyNode() ? new PTListNode(PTListType.PARAMETER_LIST) : (PTListNode)object;
        if (0 == pTListNode.numChildren() && null != (list = storedProcedure.getParameters()) && (1 != list.size() || ParameterType.RETURN_VALUE != list.get(0).getParameterType())) {
            for (int i = 0; i < list.size(); ++i) {
                if (ParameterType.RETURN_VALUE == list.get(i).getParameterType() || !list.get(i).hasDefaultValue()) continue;
                aEValueExpr = new AEDefaultParameter();
                aEValueExprList.addNode(aEValueExpr);
            }
        }
        for (int i = 0; i < pTListNode.numChildren(); ++i) {
            IPTNode iPTNode = pTListNode.getChild(i);
            assert (null != iPTNode);
            aEValueExpr = (AEValueExpr)aEValueExprBuilder.build(iPTNode);
            aEValueExprList.addNode(aEValueExpr);
        }
        return new AEProcCallInfo(storedProcedure, aEValueExprList, bl);
    }

    private static class AEProcCallInfo {
        private final StoredProcedure m_procedure;
        private final AEValueExprList m_params;
        private final boolean m_callHasReturnValue;

        public AEProcCallInfo(StoredProcedure storedProcedure, AEValueExprList aEValueExprList, boolean bl) {
            this.m_procedure = storedProcedure;
            this.m_params = aEValueExprList;
            this.m_callHasReturnValue = bl;
        }
    }
}

