/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.aeprocessor.aebuilder.value;

import com.simba.cassandra.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.simba.cassandra.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.simba.cassandra.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.AESemantics;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEAggrFn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.parser.parsetree.IPTNode;
import com.simba.cassandra.sqlengine.parser.parsetree.PTFlagNode;
import com.simba.cassandra.sqlengine.parser.parsetree.PTNonterminalNode;
import com.simba.cassandra.sqlengine.parser.type.PTFlagType;
import com.simba.cassandra.sqlengine.parser.type.PTNonterminalType;
import com.simba.cassandra.sqlengine.parser.type.PTPositionalType;
import com.simba.cassandra.support.exceptions.ErrorException;

public class AEAggrFnBuilder
extends AEBuilderBase<AEAggrFn> {
    protected AEAggrFnBuilder(AEQueryScope aEQueryScope) {
        super(aEQueryScope);
    }

    @Override
    public AEAggrFn visit(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        switch (pTNonterminalNode.getNonterminalType()) {
            case COUNT: {
                return this.buildCountAggrFn(pTNonterminalNode);
            }
            case AVG: 
            case SUM: 
            case MIN: 
            case MAX: {
                return this.buildGeneralAggrFn(pTNonterminalNode);
            }
        }
        throw SQLEngineExceptionFactory.invalidParseTreeException();
    }

    private AEAggrFn buildGeneralAggrFn(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        Object object;
        if (pTNonterminalNode.getAllPositionalTypes().size() != 2) {
            throw SQLEngineExceptionFactory.invalidParseTreeException();
        }
        AEValueExpr aEValueExpr = pTNonterminalNode.getChild(PTPositionalType.VALUE_EXPRESSION).acceptVisitor(new AEValueExprBuilder(this.getQueryScope()));
        AEAggrFn.AggrFnQuantifier aggrFnQuantifier = AEAggrFn.AggrFnQuantifier.ALL;
        IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.SET_QUANTIFIER);
        if (!iPTNode.isEmptyNode()) {
            if (!(iPTNode instanceof PTFlagNode)) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            object = (PTFlagNode)iPTNode;
            if (((PTFlagNode)object).getFlagType() == PTFlagType.DISTINCT) {
                aggrFnQuantifier = AEAggrFn.AggrFnQuantifier.DISTINCT;
            } else if (((PTFlagNode)object).getFlagType() != PTFlagType.ALL) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
        }
        object = null;
        switch (pTNonterminalNode.getNonterminalType()) {
            case COUNT: {
                object = AEAggrFn.AggrFnId.COUNT;
                break;
            }
            case MIN: {
                object = AEAggrFn.AggrFnId.MIN;
                break;
            }
            case MAX: {
                object = AEAggrFn.AggrFnId.MAX;
                break;
            }
            case SUM: {
                object = AEAggrFn.AggrFnId.SUM;
                break;
            }
            case AVG: {
                object = AEAggrFn.AggrFnId.AVG;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown aggregate function.");
            }
        }
        AESemantics.checkAggrFnSemantics(aEValueExpr, this.getQueryScope());
        return new AEGeneralAggrFn((AEAggrFn.AggrFnId)((Object)object), aggrFnQuantifier, aEValueExpr, this.getQueryScope().getDataEngine().getContext().getCoercionHandler());
    }

    private AEAggrFn buildCountAggrFn(PTNonterminalNode pTNonterminalNode) throws ErrorException {
        assert (pTNonterminalNode.getNonterminalType() == PTNonterminalType.COUNT);
        if (pTNonterminalNode.getChild(PTPositionalType.STAR) != null) {
            if (pTNonterminalNode.getAllPositionalTypes().size() != 1) {
                throw SQLEngineExceptionFactory.invalidParseTreeException();
            }
            return new AECountStarAggrFn();
        }
        return this.buildGeneralAggrFn(pTNonterminalNode);
    }
}

