/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.aeprocessor.aemanipulator;

import com.simba.cassandra.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENode;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AELikePredicate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AECrossJoin;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AETable;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEUnaryRelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.statement.AESetClause;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEBinaryValueExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEConcat;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEDivide;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AENegate;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AENull;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AERename;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AESearchedWhenClause;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AESimpleWhenClause;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.simba.cassandra.sqlengine.dsiext.dataengine.PassdownInformation;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.Iterator;

public class AETreeManipulator {
    public static void pushDownFilter(PassdownInformation passdownInformation, AEBooleanExpr aEBooleanExpr, AERelationalExpr aERelationalExpr) throws ErrorException {
        if (null == aEBooleanExpr || null == aERelationalExpr) {
            throw new NullPointerException("Cannot pass null parameters to pushDownFilter.");
        }
        aEBooleanExpr.setIsOptimized(true);
        switch (PushDownType.getNodeType(aERelationalExpr)) {
            case JOIN: {
                AETreeManipulator.pushToJoin(aEBooleanExpr, (AEJoin)aERelationalExpr);
                break;
            }
            case CROSSJOIN: {
                AETreeManipulator.pushToCrossJoin(aEBooleanExpr, (AECrossJoin)aERelationalExpr);
                break;
            }
            case TABLE: {
                AETreeManipulator.pushToTable(aEBooleanExpr, (AETable)aERelationalExpr, passdownInformation);
                break;
            }
            case SELECT: {
                AETreeManipulator.pushToSelect(aEBooleanExpr, (AESelect)aERelationalExpr);
                break;
            }
            case TABLE_SUBQUERY: {
                AETreeManipulator.pushToTableSubquery(aEBooleanExpr, (AESubQuery)aERelationalExpr);
                break;
            }
            case PROJECT: {
                AETreeManipulator.insertSelectFilterInUnaryRelExpr(aEBooleanExpr, (AEProject)aERelationalExpr);
            }
        }
    }

    public static void convertJoinToCrossJoin(AEJoin aEJoin) {
        if (null == aEJoin) {
            throw new NullPointerException("join parameter cannot be null.");
        }
        IAENode iAENode = aEJoin.getParent();
        AECrossJoin aECrossJoin = new AECrossJoin(aEJoin.getLeftOperand(), aEJoin.getRightOperand());
        aECrossJoin.setParent(iAENode);
        AETreeManipulator.replaceRelExprOperand(iAENode, aECrossJoin, aEJoin);
    }

    public static void convertCrossJoinToInnerJoin(AECrossJoin aECrossJoin, AESelect aESelect) {
        if (null == aECrossJoin || null == aESelect) {
            throw new NullPointerException("Cannot pass null parameters to convertCrossJoinToInnerJoin.");
        }
        IAENode iAENode = aESelect.getParent();
        AEJoin aEJoin = new AEJoin(AEJoin.AEJoinType.INNER_JOIN, aECrossJoin.getLeftOperand(), aECrossJoin.getRightOperand());
        aEJoin.setJoinCondition(aESelect.getCondition());
        aEJoin.setParent(iAENode);
        AETreeManipulator.replaceRelExprOperand(iAENode, aEJoin, aESelect);
    }

    public static void removeSelect(AESelect aESelect) {
        assert (aESelect.getCondition() instanceof AEBooleanTrue);
        AETreeManipulator.replaceRelExprOperand(aESelect.getParent(), aESelect.getOperand(), aESelect);
    }

    public static void replaceValueExpr(AEValueExpr aEValueExpr, AEValueExpr aEValueExpr2) throws ErrorException {
        aEValueExpr.getParent().acceptVisitor(new ValueExpressionReplacer(aEValueExpr2, aEValueExpr));
    }

    private static void replaceRelExprOperand(IAENode iAENode, AERelationalExpr aERelationalExpr, AERelationalExpr aERelationalExpr2) {
        if (iAENode instanceof AEUnaryRelationalExpr) {
            ((AEUnaryRelationalExpr)iAENode).setOperand(aERelationalExpr);
        } else if (iAENode instanceof AEBinaryRelationalExpr) {
            AEBinaryRelationalExpr aEBinaryRelationalExpr = (AEBinaryRelationalExpr)iAENode;
            if (aEBinaryRelationalExpr.getLeftOperand() == aERelationalExpr2) {
                aEBinaryRelationalExpr.setLeftOperand(aERelationalExpr);
            } else {
                aEBinaryRelationalExpr.setRightOperand(aERelationalExpr);
            }
        } else {
            throw new IllegalStateException("Unexpected error in AETree manipulation.");
        }
    }

    private static void pushToJoin(AEBooleanExpr aEBooleanExpr, AEJoin aEJoin) throws ErrorException {
        assert (null != aEBooleanExpr && null != aEJoin);
        AEBooleanExpr aEBooleanExpr2 = aEJoin.getJoinCondition();
        if (aEJoin.getJoinCondition() == aEBooleanExpr || AETreeManipulator.subtreeContainsReference(aEBooleanExpr2, aEBooleanExpr)) {
            return;
        }
        if (aEBooleanExpr2.isEquivalent(aEBooleanExpr)) {
            AETreeManipulator.detachFilter(aEBooleanExpr);
            return;
        }
        if (aEJoin.isOuterJoin()) {
            IAENode iAENode = aEJoin.getParent();
            if (iAENode instanceof AEUnaryRelationalExpr) {
                AETreeManipulator.insertSelectFilterInUnaryRelExpr(aEBooleanExpr, (AEUnaryRelationalExpr)iAENode);
            } else if (iAENode instanceof AEBinaryRelationalExpr) {
                AETreeManipulator.insertSelectFilterInBinaryRelExpr(aEBooleanExpr, (AEBinaryRelationalExpr)iAENode, aEJoin);
            }
        } else {
            AEAnd aEAnd = new AEAnd(AETreeManipulator.detachFilter(aEBooleanExpr), aEBooleanExpr2);
            aEJoin.setJoinCondition(aEAnd);
        }
    }

    private static void pushToCrossJoin(AEBooleanExpr aEBooleanExpr, AECrossJoin aECrossJoin) throws ErrorException {
        AEBooleanExpr aEBooleanExpr2;
        assert (null != aEBooleanExpr && null != aECrossJoin);
        IAENode iAENode = aECrossJoin.getParent();
        assert (null != iAENode);
        if (iAENode instanceof AESelect && ((aEBooleanExpr2 = ((AESelect)iAENode).getCondition()) == aEBooleanExpr || AETreeManipulator.subtreeContainsReference(aEBooleanExpr2, aEBooleanExpr))) {
            return;
        }
        switch (PushDownType.getNodeType(iAENode)) {
            case SELECT: {
                if (aEBooleanExpr.isEquivalent(((AESelect)iAENode).getCondition())) break;
                AETreeManipulator.pushToSelect(aEBooleanExpr, (AESelect)iAENode);
                break;
            }
            case PROJECT: {
                AETreeManipulator.insertSelectFilterInUnaryRelExpr(aEBooleanExpr, (AEUnaryRelationalExpr)iAENode);
                break;
            }
            case JOIN: 
            case CROSSJOIN: {
                AETreeManipulator.insertSelectFilterInBinaryRelExpr(aEBooleanExpr, (AEBinaryRelationalExpr)iAENode, aECrossJoin);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static void pushToTable(AEBooleanExpr aEBooleanExpr, AETable aETable, PassdownInformation passdownInformation) throws ErrorException {
        IAENode iAENode = aETable.getParent();
        switch (PushDownType.getNodeType(iAENode)) {
            case JOIN: 
            case CROSSJOIN: {
                boolean bl = false;
                if (passdownInformation.canHandlePassdown(aEBooleanExpr)) {
                    bl = true;
                } else if (passdownInformation.canHandlePassdown((AERelationalExpr)iAENode)) {
                    bl = true;
                }
                if (!bl) break;
                AETreeManipulator.insertSelectFilterInBinaryRelExpr(aEBooleanExpr, (AEBinaryRelationalExpr)iAENode, aETable);
                break;
            }
            case SELECT: {
                AETreeManipulator.pushToSelect(aEBooleanExpr, (AESelect)iAENode);
                break;
            }
            case PROJECT: {
                AETreeManipulator.insertSelectFilterInUnaryRelExpr(aEBooleanExpr, (AEUnaryRelationalExpr)iAENode);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static void pushToTableSubquery(AEBooleanExpr aEBooleanExpr, AESubQuery aESubQuery) throws ErrorException {
        IAENode iAENode = aESubQuery.getParent();
        if (iAENode instanceof AEUnaryRelationalExpr) {
            AETreeManipulator.insertSelectFilterInUnaryRelExpr(aEBooleanExpr, (AEUnaryRelationalExpr)iAENode);
        } else if (iAENode instanceof AEBinaryRelationalExpr) {
            AETreeManipulator.insertSelectFilterInBinaryRelExpr(aEBooleanExpr, (AEBinaryRelationalExpr)iAENode, aESubQuery);
        }
    }

    private static void pushToSelect(AEBooleanExpr aEBooleanExpr, AESelect aESelect) throws ErrorException {
        AEAnd aEAnd = new AEAnd(AETreeManipulator.detachFilter(aEBooleanExpr), aESelect.getCondition());
        aESelect.setSelectCond(aEAnd);
    }

    private static void insertSelectFilterInUnaryRelExpr(AEBooleanExpr aEBooleanExpr, AEUnaryRelationalExpr aEUnaryRelationalExpr) throws ErrorException {
        AERelationalExpr aERelationalExpr = aEUnaryRelationalExpr.getOperand();
        aEUnaryRelationalExpr.setOperand(new AESelect(aERelationalExpr, AETreeManipulator.detachFilter(aEBooleanExpr)));
    }

    private static void insertSelectFilterInBinaryRelExpr(AEBooleanExpr aEBooleanExpr, AEBinaryRelationalExpr aEBinaryRelationalExpr, AERelationalExpr aERelationalExpr) throws ErrorException {
        if (aEBinaryRelationalExpr.getLeftOperand() == aERelationalExpr) {
            aEBinaryRelationalExpr.setLeftOperand(new AESelect(aERelationalExpr, AETreeManipulator.detachFilter(aEBooleanExpr)));
        } else {
            aEBinaryRelationalExpr.setRightOperand(new AESelect(aERelationalExpr, AETreeManipulator.detachFilter(aEBooleanExpr)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AEBooleanExpr detachFilter(AEBooleanExpr aEBooleanExpr) throws ErrorException {
        assert (null != aEBooleanExpr);
        AEBooleanExpr aEBooleanExpr2 = null;
        IAENode iAENode = aEBooleanExpr.getParent();
        if (null == iAENode) return aEBooleanExpr;
        if (iAENode instanceof AEAnd) {
            return AETreeManipulator.extractFromAnd(aEBooleanExpr, (AEAnd)iAENode);
        }
        if (!(iAENode instanceof AERelationalExpr)) throw new IllegalStateException("Logic error: Filter push down cannot be completed.");
        return AETreeManipulator.extractFromRelationalExpr(aEBooleanExpr, (AERelationalExpr)iAENode);
    }

    private static AEBooleanExpr extractFromAnd(AEBooleanExpr aEBooleanExpr, AEAnd aEAnd) {
        if (null == aEAnd || null == aEBooleanExpr) {
            throw new NullPointerException("Null parameters are not allowed.");
        }
        AEBooleanExpr aEBooleanExpr2 = null;
        if (aEAnd.getLeftOperand() == aEBooleanExpr) {
            aEBooleanExpr2 = aEAnd.setLeftOperand(null);
            AETreeManipulator.extractAnd(aEAnd);
        } else {
            aEBooleanExpr2 = aEAnd.setRightOperand(null);
            AETreeManipulator.extractAnd(aEAnd);
        }
        return aEBooleanExpr2;
    }

    private static void extractAnd(AEAnd aEAnd) {
        AEBooleanExpr aEBooleanExpr = null;
        aEBooleanExpr = null == aEAnd.getLeftOperand() ? aEAnd.setRightOperand(null) : aEAnd.setLeftOperand(null);
        IAENode iAENode = aEAnd.getParent();
        if (iAENode instanceof AESelect) {
            AESelect aESelect = (AESelect)iAENode;
            aESelect.setSelectCond(aEBooleanExpr);
        } else if (iAENode instanceof AEJoin) {
            AEJoin aEJoin = (AEJoin)iAENode;
            aEJoin.setJoinCondition(aEBooleanExpr);
        } else if (iAENode instanceof AEAnd) {
            AEAnd aEAnd2 = (AEAnd)iAENode;
            if (aEAnd2.getLeftOperand() == aEAnd) {
                aEAnd2.setLeftOperand(aEBooleanExpr);
            } else {
                aEAnd2.setRightOperand(aEBooleanExpr);
            }
        } else {
            throw new IllegalStateException("Logic error: Filter push down cannot be completed: " + aEAnd + " with parent " + iAENode);
        }
    }

    private static AEBooleanExpr extractFromRelationalExpr(AEBooleanExpr aEBooleanExpr, AERelationalExpr aERelationalExpr) throws ErrorException {
        AEBooleanExpr aEBooleanExpr2 = null;
        if (PushDownType.SELECT == PushDownType.getNodeType(aERelationalExpr)) {
            AESelect aESelect = (AESelect)aERelationalExpr;
            aEBooleanExpr2 = aESelect.setSelectCond(new AEBooleanTrue());
        } else if (PushDownType.JOIN == PushDownType.getNodeType(aERelationalExpr)) {
            AEJoin aEJoin = (AEJoin)aERelationalExpr;
            aEBooleanExpr2 = aEJoin.getJoinCondition();
            aEJoin.setJoinCondition(new AEBooleanTrue());
        } else {
            throw new IllegalStateException("Logic error: Filter push down cannot be completed.");
        }
        return aEBooleanExpr2;
    }

    private static boolean subtreeContainsReference(AEBooleanExpr aEBooleanExpr, final AEBooleanExpr aEBooleanExpr2) throws ErrorException {
        AEDefaultVisitor<Boolean> aEDefaultVisitor = new AEDefaultVisitor<Boolean>(){

            @Override
            protected Boolean defaultVisit(IAENode iAENode) throws ErrorException {
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                if (iAENode == aEBooleanExpr2) {
                    return true;
                }
                while (iterator.hasNext()) {
                    if (!iterator.next().acceptVisitor(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        };
        return aEBooleanExpr.acceptVisitor(aEDefaultVisitor);
    }

    private static class ValueExpressionReplacer
    extends AEDefaultVisitor<Void> {
        private final AEValueExpr m_replacement;
        private final AEValueExpr m_toReplace;

        ValueExpressionReplacer(AEValueExpr aEValueExpr, AEValueExpr aEValueExpr2) {
            this.m_replacement = aEValueExpr;
            this.m_toReplace = aEValueExpr2;
        }

        @Override
        public Void visit(AEValueExprList aEValueExprList) throws ErrorException {
            int n = aEValueExprList.findNode(this.m_toReplace);
            if (0 > n) {
                throw SQLEngineExceptionFactory.invalidAETreeException();
            }
            aEValueExprList.replaceNode(this.m_replacement, n);
            return null;
        }

        @Override
        public Void visit(AERename aERename) throws ErrorException {
            aERename.setOperand(this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AENegate aENegate) throws ErrorException {
            aENegate.setOperand(this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AELikePredicate aELikePredicate) throws ErrorException {
            if (aELikePredicate.getLeftOperand() == this.m_toReplace) {
                aELikePredicate.setLeftOperand(this.m_replacement);
            } else if (aELikePredicate.getRightOperand() == this.m_toReplace) {
                aELikePredicate.setRightOperand(this.m_replacement);
            } else {
                aELikePredicate.setEscape(this.m_replacement);
            }
            return null;
        }

        @Override
        public Void visit(AEAdd aEAdd) throws ErrorException {
            this.replaceFromBinaryValueExpr(aEAdd);
            return null;
        }

        @Override
        public Void visit(AEConcat aEConcat) throws ErrorException {
            this.replaceFromBinaryValueExpr(aEConcat);
            return null;
        }

        @Override
        public Void visit(AESubtract aESubtract) throws ErrorException {
            this.replaceFromBinaryValueExpr(aESubtract);
            return null;
        }

        @Override
        public Void visit(AEDivide aEDivide) throws ErrorException {
            this.replaceFromBinaryValueExpr(aEDivide);
            return null;
        }

        @Override
        public Void visit(AEMultiply aEMultiply) throws ErrorException {
            this.replaceFromBinaryValueExpr(aEMultiply);
            return null;
        }

        @Override
        public Void visit(AEGeneralAggrFn aEGeneralAggrFn) throws ErrorException {
            aEGeneralAggrFn.setOperand(this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AESearchedCase aESearchedCase) throws ErrorException {
            if (aESearchedCase.getElseClause() instanceof AENull) {
                throw SQLEngineExceptionFactory.invalidAETreeException();
            }
            aESearchedCase.setElseClause(this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AESearchedWhenClause aESearchedWhenClause) throws ErrorException {
            aESearchedWhenClause.setThenExpression(this.m_replacement);
            return null;
        }

        @Override
        public Void visit(AESimpleCase aESimpleCase) throws ErrorException {
            if (aESimpleCase.getCaseOperand() == this.m_toReplace) {
                aESimpleCase.setCaseOperand(this.m_replacement);
            } else {
                aESimpleCase.setElseOperand(this.m_replacement);
            }
            return null;
        }

        @Override
        public Void visit(AESimpleWhenClause aESimpleWhenClause) throws ErrorException {
            if (aESimpleWhenClause.getWhenExpression() == this.m_toReplace) {
                aESimpleWhenClause.setWhenExpression(this.m_replacement);
            } else {
                aESimpleWhenClause.setThenExpression(this.m_replacement);
            }
            return null;
        }

        @Override
        public Void visit(AESetClause aESetClause) throws ErrorException {
            aESetClause.setLeftOperand(this.m_replacement);
            return null;
        }

        @Override
        protected Void defaultVisit(IAENode iAENode) throws ErrorException {
            throw SQLEngineExceptionFactory.invalidAETreeException();
        }

        private void replaceFromBinaryValueExpr(AEBinaryValueExpr aEBinaryValueExpr) {
            if (aEBinaryValueExpr.getLeftOperand() == this.m_toReplace) {
                aEBinaryValueExpr.setLeftOperand(this.m_replacement);
            } else {
                aEBinaryValueExpr.setRightOperand(this.m_replacement);
            }
        }
    }

    private static enum PushDownType {
        JOIN,
        CROSSJOIN,
        SELECT,
        PROJECT,
        TABLE,
        TABLE_SUBQUERY;


        public static PushDownType getNodeType(IAENode iAENode) throws ErrorException {
            if (iAENode instanceof AEJoin) {
                return JOIN;
            }
            if (iAENode instanceof AECrossJoin) {
                return CROSSJOIN;
            }
            if (iAENode instanceof AESelect) {
                return SELECT;
            }
            if (iAENode instanceof AEProject) {
                return PROJECT;
            }
            if (iAENode instanceof AETable) {
                return TABLE;
            }
            if (iAENode instanceof AESubQuery) {
                return TABLE_SUBQUERY;
            }
            throw SQLEngineExceptionFactory.featureNotImplementedException("Attempt to push down filter on unknown node type: " + iAENode.getClass().getName());
        }
    }
}

