/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.aeprocessor.aetree.statement;

import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAEBinaryNode;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENode;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;

public class AESetClause
implements IAENode,
IAEBinaryNode<AEColumnReference, AEValueExpr> {
    private static final int NUM_CHILDREN = 2;
    private IAENode m_parent = null;
    private AEColumnReference m_column;
    private AEValueExpr m_value;

    public AESetClause(AEColumnReference aEColumnReference, AEValueExpr aEValueExpr) {
        if (null == aEColumnReference) {
            throw new NullPointerException("column cannot be null.");
        }
        if (null == aEValueExpr) {
            throw new NullPointerException("value cannot be null");
        }
        this.m_column = aEColumnReference;
        this.m_value = aEValueExpr;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AESetClause copy() {
        return new AESetClause(this.m_column.copy(), this.m_value.copy());
    }

    @Override
    public Iterator<? extends IAENode> getChildItr() {
        return new AbstractList<IAENode>(){

            @Override
            public IAENode get(int n) {
                if (0 == n) {
                    return AESetClause.this.getLeftOperand();
                }
                if (1 == n) {
                    return AESetClause.this.getRightOperand();
                }
                throw new IndexOutOfBoundsException("" + n);
            }

            @Override
            public int size() {
                return 2;
            }
        }.iterator();
    }

    @Override
    public AEColumnReference getLeftOperand() {
        return this.m_column;
    }

    public void setLeftOperand(AEValueExpr aEValueExpr) {
        this.m_value = aEValueExpr;
        this.m_value.setParent(this);
    }

    @Override
    public String getLogString() {
        return "AESetClause";
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public IAENode getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(IAENode iAENode) {
        this.m_parent = iAENode;
    }

    @Override
    public AEValueExpr getRightOperand() {
        return this.m_value;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AESetClause)) {
            return false;
        }
        AESetClause aESetClause = (AESetClause)iAENode;
        return this.m_column.isEquivalent(aESetClause.m_column) && this.m_value.isEquivalent(aESetClause.m_value);
    }
}

