/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.datawrapper;

import com.simba.cassandra.dsi.dataengine.interfaces.IArray;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.exceptions.IncorrectTypeException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.simba.cassandra.sqlengine.utilities.SQLEngineMessageKey;
import com.simba.cassandra.support.exceptions.ErrorException;

public final class SqlArrayDataWrapper
extends DefaultSqlDataWrapper {
    private IArray m_data;
    private boolean m_isSet = false;
    private boolean m_isNull = false;

    @Override
    public int getType() {
        return 2003;
    }

    @Override
    public boolean isNull() {
        return this.m_isNull;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_isNull = true;
    }

    @Override
    public IArray getArray() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    @Override
    public void setArray(IArray iArray) throws ErrorException, NullPointerException {
        this.m_isSet = true;
        this.m_data = iArray;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        if (dataWrapper.isNull()) {
            this.setNull();
        } else {
            try {
                if (dataWrapper.getType() != 2003) {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
                this.setArray(dataWrapper.getArray());
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
            }
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        if (this.m_isNull) {
            dataWrapper.setNull(2003);
            return;
        }
        dataWrapper.setArray(this.m_data);
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

