/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.datawrapper;

import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.exceptions.IncorrectTypeException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineException;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.simba.cassandra.sqlengine.utilities.SQLEngineMessageKey;
import com.simba.cassandra.support.exceptions.ErrorException;

public final class SqlCharDataWrapper
extends DefaultSqlDataWrapper {
    private String m_data;
    private boolean m_isSet = false;
    private final int m_type;

    public SqlCharDataWrapper(int n) {
        assert (n == 1 || n == 12 || n == -1 || n == -8 || n == -9 || n == -10);
        this.m_type = n;
    }

    @Override
    public String getChar() throws ErrorException {
        this.checkIsSet();
        return this.m_data;
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    @Override
    public boolean isNull() throws ErrorException {
        this.checkIsSet();
        return null == this.m_data;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setChar(String string) {
        this.m_isSet = true;
        this.m_data = string;
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_data = null;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        try {
            String string = null;
            switch (dataWrapper.getType()) {
                case -8: 
                case 1: {
                    string = dataWrapper.getChar();
                    break;
                }
                case -9: 
                case 12: {
                    string = dataWrapper.getVarChar();
                    break;
                }
                case -10: 
                case -1: {
                    string = dataWrapper.getLongVarChar();
                    break;
                }
                default: {
                    throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                }
            }
            this.setChar(string);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        this.checkIsSet();
        switch (this.m_type) {
            case 1: {
                dataWrapper.setChar(this.m_data);
                break;
            }
            case 12: {
                dataWrapper.setVarChar(this.m_data);
                break;
            }
            case -1: {
                dataWrapper.setLongVarChar(this.m_data);
                break;
            }
            case -8: {
                dataWrapper.setWChar(this.m_data);
                break;
            }
            case -9: {
                dataWrapper.setWVarChar(this.m_data);
                break;
            }
            case -10: {
                dataWrapper.setWLongVarChar(this.m_data);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void checkIsSet() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
    }
}

