/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.relation;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.CursorType;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.IETNodeVisitor;
import com.simba.cassandra.sqlengine.executor.etree.IMemManagerAgent;
import com.simba.cassandra.sqlengine.executor.etree.IMemoryConsumer;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETUnaryRelationalExpr;
import com.simba.cassandra.sqlengine.executor.etree.temptable.SortedTemporaryTable;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.List;

public final class ETSort
extends ETUnaryRelationalExpr
implements IMemoryConsumer {
    private final List<? extends IColumn> m_columns;
    private final SortedTemporaryTable m_tempTable;

    public ETSort(ETRelationalExpr eTRelationalExpr, List<? extends IColumn> list, SortedTemporaryTable sortedTemporaryTable, boolean[] blArray) throws ErrorException {
        super(eTRelationalExpr, blArray);
        this.m_columns = list;
        this.m_tempTable = sortedTemporaryTable;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_columns.get(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_columns.size();
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_tempTable.getRowCount();
    }

    @Override
    public boolean isOpen() {
        return this.m_tempTable.isOpen();
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        try {
            this.m_tempTable.open();
            this.m_tempTable.writeFromRelation(this.getOperand());
            this.getOperand().close(this.getOperand().canReopenAfterClosed());
        }
        catch (ErrorException errorException) {
            this.close(false);
            throw errorException;
        }
        catch (RuntimeException runtimeException) {
            this.close(false);
            throw SQLEngineExceptionFactory.convertRuntimeException(runtimeException);
        }
    }

    @Override
    public void close(boolean bl) {
        this.m_tempTable.close(bl);
    }

    @Override
    public void reset() {
        if (!this.isOpen()) {
            this.close(false);
            throw new IllegalStateException("Reset called before relation is opened.");
        }
        this.m_tempTable.reset();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        try {
            return this.m_tempTable.retrieveData(n, eTDataRequest);
        }
        catch (ErrorException errorException) {
            this.close(false);
            throw errorException;
        }
        catch (RuntimeException runtimeException) {
            this.close(false);
            throw SQLEngineExceptionFactory.convertRuntimeException(runtimeException);
        }
    }

    @Override
    protected boolean doMove() throws ErrorException {
        try {
            return this.m_tempTable.moveToNextRow();
        }
        catch (ErrorException errorException) {
            this.close(false);
            throw errorException;
        }
        catch (RuntimeException runtimeException) {
            this.close(false);
            throw SQLEngineExceptionFactory.convertRuntimeException(runtimeException);
        }
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
        this.m_tempTable.registerManagerAgent(iMemManagerAgent);
    }

    @Override
    public long assign(long l) {
        return this.m_tempTable.assign(l);
    }

    @Override
    public long getRequiredMemory() {
        return this.m_tempTable.getRequiredMemory();
    }
}

