/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.temptable;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.sqlengine.executor.etree.temptable.IRowView;
import com.simba.cassandra.sqlengine.executor.etree.temptable.RowBlock;
import com.simba.cassandra.sqlengine.executor.etree.temptable.TemporaryFile;
import com.simba.cassandra.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.UUID;

public class DataStore
implements IRowView {
    private final TemporaryFile m_file;
    private RowBlock m_currentBlock = null;
    private final ArrayList<BlockMarker> m_blockList;
    private final TemporaryTableBuilder.TemporaryTableProperties m_properties;
    private boolean m_closed = false;
    private boolean m_fetching = false;
    private boolean m_blockAllocated = false;
    private int m_currentBlockIndex = 0;
    private int m_rowNumOfCurrBlock = -1;
    private IColumn[] m_metadata;

    public DataStore(TemporaryTableBuilder.TemporaryTableProperties temporaryTableProperties, IColumn[] iColumnArray) throws ErrorException {
        this.m_properties = temporaryTableProperties;
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, new Object[0]);
        }
        this.m_metadata = (IColumn[])iColumnArray.clone();
        this.m_file = new TemporaryFile(this.m_properties.m_storageDir, this.m_properties.m_logger);
        this.m_blockList = new ArrayList();
    }

    public void destroy() {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, new Object[0]);
        }
        if (!this.m_closed) {
            this.m_file.destroy();
            this.m_currentBlock = null;
            this.m_blockAllocated = false;
            this.m_closed = true;
            this.m_fetching = false;
        }
    }

    public void giveBlock() {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, new Object[0]);
        }
        if (this.m_blockAllocated) {
            throw new IllegalStateException("Allocating more blocks than the DataStore can use.");
        }
        this.m_blockAllocated = true;
    }

    public boolean moveToFirstRow() throws ErrorException {
        this.reset();
        return this.moveToNextRow();
    }

    public void reset() {
        if (0 != this.m_currentBlockIndex) {
            this.m_currentBlockIndex = 0;
            this.m_currentBlock = null;
        }
        this.m_rowNumOfCurrBlock = -1;
    }

    public boolean moveToNextRow() throws ErrorException {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, new Object[0]);
        }
        if (!this.m_blockAllocated) {
            throw new IllegalStateException("Attempt to retrieve data without allocating memory for the DataStore.");
        }
        this.m_fetching = true;
        this.ensureCurrentBlockLoaded();
        while (null != this.m_currentBlock) {
            if (this.m_currentBlock.moveToRow(++this.m_rowNumOfCurrBlock)) {
                return true;
            }
            if (0 == this.m_currentBlockIndex && null == this.m_blockList.get((int)0).m_fileMarker) {
                this.m_blockList.get((int)0).m_fileMarker = this.m_file.put(this.m_currentBlock.serialize());
            }
            this.m_rowNumOfCurrBlock = -1;
            ++this.m_currentBlockIndex;
            this.m_currentBlock = null;
            this.ensureCurrentBlockLoaded();
        }
        return false;
    }

    public int numberOfBlocksHeld() {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, new Object[0]);
        }
        if (this.m_blockAllocated) {
            return 1;
        }
        return 0;
    }

    public void put(RowBlock rowBlock) throws ErrorException {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, rowBlock);
        }
        TemporaryFile.FileMarker fileMarker = null;
        long l = 0L;
        if (!this.m_fetching && this.m_blockAllocated && this.m_blockList.isEmpty()) {
            this.m_currentBlock = rowBlock;
        } else {
            byte[] byArray = rowBlock.serialize();
            fileMarker = this.m_file.put(byArray);
            if (!this.m_blockList.isEmpty()) {
                BlockMarker blockMarker = this.m_blockList.get(this.m_blockList.size() - 1);
                l = blockMarker.m_startIndex + (long)blockMarker.m_numRows;
            }
        }
        this.m_blockList.add(new BlockMarker(fileMarker, l, rowBlock.getNumRows()));
    }

    public void takeBlock() throws ErrorException {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, new Object[0]);
        }
        if (this.m_blockAllocated && 0 == this.m_currentBlockIndex && null == this.m_blockList.get((int)0).m_fileMarker) {
            byte[] byArray = this.m_currentBlock.serialize();
            this.m_blockList.get((int)0).m_fileMarker = this.m_file.put(byArray);
        }
        this.m_currentBlock = null;
        this.m_blockAllocated = false;
    }

    @Override
    public TemporaryFile.FileMarker getFileMarker(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getFileMarker(n);
    }

    @Override
    public BigDecimal getExactNumber(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getExactNumber(n);
    }

    @Override
    public long getBigInt(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getBigInt(n);
    }

    @Override
    public boolean isNull(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.isNull(n);
    }

    @Override
    public double getDouble(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getDouble(n);
    }

    @Override
    public float getReal(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getReal(n);
    }

    @Override
    public boolean getBoolean(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getBoolean(n);
    }

    @Override
    public String getString(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getString(n);
    }

    @Override
    public Date getDate(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getDate(n);
    }

    @Override
    public Time getTime(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getTime(n);
    }

    @Override
    public Timestamp getTimestamp(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getTimestamp(n);
    }

    @Override
    public UUID getGuid(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getGuid(n);
    }

    @Override
    public int getInteger(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getInteger(n);
    }

    @Override
    public short getSmallInt(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getSmallInt(n);
    }

    @Override
    public byte getTinyInt(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getTinyInt(n);
    }

    @Override
    public byte[] getBytes(int n) {
        if (null != this.m_properties.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_properties.m_logger, n);
        }
        return this.m_currentBlock.getBytes(n);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_metadata[n];
    }

    public int getNumberBlocks() {
        return this.m_blockList.size();
    }

    private void ensureCurrentBlockLoaded() throws ErrorException {
        assert (this.m_blockAllocated);
        if (null == this.m_currentBlock && this.m_currentBlockIndex < this.m_blockList.size()) {
            this.m_currentBlock = RowBlock.loadData(this.m_file.get(this.m_blockList.get((int)this.m_currentBlockIndex).m_fileMarker), this.m_properties.m_logger, this.m_metadata);
        }
    }

    private static final class BlockMarker {
        public TemporaryFile.FileMarker m_fileMarker;
        public long m_startIndex;
        public int m_numRows;

        public BlockMarker(TemporaryFile.FileMarker fileMarker, long l, int n) {
            this.m_fileMarker = fileMarker;
            this.m_startIndex = l;
            this.m_numRows = n;
        }
    }
}

