/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.temptable;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.simba.cassandra.sqlengine.executor.etree.temptable.IRowView;
import com.simba.cassandra.sqlengine.executor.etree.temptable.RowBlock;
import com.simba.cassandra.sqlengine.executor.etree.temptable.TemporaryFile;
import com.simba.cassandra.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.simba.cassandra.sqlengine.executor.etree.temptable.column.ColumnSliceArray;
import com.simba.cassandra.sqlengine.executor.etree.temptable.column.ColumnSliceBuilder;
import com.simba.cassandra.sqlengine.executor.etree.temptable.column.IColumnSlice;
import com.simba.cassandra.sqlengine.executor.etree.util.CompressionUtil;
import com.simba.cassandra.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.simba.cassandra.sqlengine.utilities.ExternalAlgorithmUtil;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;

public class InMemTable {
    private static final int NUM_ROW_PER_SLICE_DEFAULT = 100;
    private long m_memLimit;
    private int m_numRowPerSlice;
    private int m_numRows;
    private int m_varLenColMemUsage;
    protected ILogger m_logger;
    protected IColumn[] m_columnMetadata;
    protected ArrayList<ColumnSliceArray> m_data;
    protected double m_memOverheadPerRow;
    protected double m_fixLenDataSizePerRow;
    private HashSet<Integer> m_removedRows;
    private int m_curWritingRow = -1;
    private boolean[] m_isVarLenColumns;
    private boolean[] m_isLongDataColumn;
    private int m_maxRowNumber = -1;
    private int m_maxDataLength;
    private long m_maxRowSize;
    private ETDataRequest[] m_requests;
    private boolean[] m_needsData;

    public InMemTable(IColumn[] iColumnArray, int n, int n2, boolean[] blArray, ILogger iLogger) {
        int n3;
        if (n < 0 || iColumnArray == null) {
            throw new IllegalArgumentException("Invalid argument for InMemTable Constructor.");
        }
        this.m_numRowPerSlice = n2;
        if (this.m_numRowPerSlice <= 0) {
            this.m_numRowPerSlice = 100;
        }
        this.m_maxDataLength = n;
        this.m_numRows = 0;
        this.m_varLenColMemUsage = 0;
        this.m_logger = iLogger;
        this.m_needsData = (boolean[])blArray.clone();
        this.m_columnMetadata = new IColumn[iColumnArray.length];
        this.m_isLongDataColumn = new boolean[iColumnArray.length];
        this.m_isVarLenColumns = new boolean[iColumnArray.length];
        this.m_requests = new ETDataRequest[iColumnArray.length];
        for (n3 = 0; n3 < iColumnArray.length; ++n3) {
            this.m_columnMetadata[n3] = iColumnArray[n3];
            if (ColumnSizeCalculator.isLongData(this.m_columnMetadata[n3], this.m_maxDataLength)) {
                this.m_isLongDataColumn[n3] = true;
                continue;
            }
            if (!this.m_columnMetadata[n3].getTypeMetadata().isCharacterOrBinaryType()) continue;
            this.m_isVarLenColumns[n3] = true;
        }
        this.m_maxRowSize = ExternalAlgorithmUtil.calculateRowSize(Arrays.asList(this.m_columnMetadata), this.m_needsData, this.m_maxDataLength);
        this.m_data = new ArrayList();
        this.m_removedRows = new HashSet();
        this.m_memOverheadPerRow = 0.0;
        this.m_fixLenDataSizePerRow = 0.0;
        for (n3 = 0; n3 < this.m_columnMetadata.length; ++n3) {
            if (!this.m_isVarLenColumns[n3]) {
                this.m_fixLenDataSizePerRow += ColumnSizeCalculator.getColumnSizePerRow(this.m_columnMetadata[n3], this.m_needsData[n3], this.m_maxDataLength);
            }
            this.m_memOverheadPerRow += ColumnSizeCalculator.getOverHeadPerRow(this.m_columnMetadata[n3], this.m_needsData[n3], this.m_maxDataLength);
            if (this.m_isLongDataColumn[n3]) continue;
            this.m_requests[n3] = new ETDataRequest(iColumnArray[n3]);
        }
    }

    public static void setColumn(InMemTable inMemTable, IRowView iRowView, int n, int n2, int n3) {
        if (iRowView.isNull(n)) {
            inMemTable.setNull(n2, n);
        } else {
            switch (iRowView.getColumn(n).getTypeMetadata().getType()) {
                case -5: {
                    inMemTable.setBigInt(n2, n, iRowView.getBigInt(n));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (ColumnSizeCalculator.isLongData(iRowView.getColumn(n), n3)) {
                        inMemTable.setFileMarker(n2, n, iRowView.getFileMarker(n));
                        break;
                    }
                    inMemTable.setBytes(n2, n, iRowView.getBytes(n));
                    break;
                }
                case -7: 
                case 16: {
                    inMemTable.setBoolean(n2, n, iRowView.getBoolean(n));
                    break;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    if (ColumnSizeCalculator.isLongData(iRowView.getColumn(n), n3)) {
                        inMemTable.setFileMarker(n2, n, iRowView.getFileMarker(n));
                        break;
                    }
                    inMemTable.setString(n2, n, iRowView.getString(n));
                    break;
                }
                case 91: {
                    inMemTable.setDate(n2, n, iRowView.getDate(n));
                    break;
                }
                case 6: 
                case 8: {
                    inMemTable.setDouble(n2, n, iRowView.getDouble(n));
                    break;
                }
                case 2: 
                case 3: {
                    inMemTable.setExactNum(n2, n, iRowView.getExactNumber(n));
                    break;
                }
                case -11: {
                    inMemTable.setGuid(n2, n, iRowView.getGuid(n));
                    break;
                }
                case 4: {
                    inMemTable.setInteger(n2, n, iRowView.getInteger(n));
                    break;
                }
                case 7: {
                    inMemTable.setReal(n2, n, iRowView.getReal(n));
                    break;
                }
                case 5: {
                    inMemTable.setSmallInt(n2, n, iRowView.getSmallInt(n));
                    break;
                }
                case 92: {
                    inMemTable.setTime(n2, n, iRowView.getTime(n));
                    break;
                }
                case 93: {
                    inMemTable.setTimestamp(n2, n, iRowView.getTimestamp(n));
                    break;
                }
                case -6: {
                    inMemTable.setTinyInt(n2, n, iRowView.getTinyInt(n));
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown data type: %d.", iRowView.getColumn(n).getTypeMetadata().getType()));
                }
            }
        }
    }

    public static void setColumn(InMemTable inMemTable, ISqlDataWrapper iSqlDataWrapper, IColumn iColumn, int n, int n2) throws ErrorException {
        if (iSqlDataWrapper.isNull()) {
            inMemTable.setNull(n2, n);
        } else {
            switch (iColumn.getTypeMetadata().getType()) {
                case -6: {
                    inMemTable.setTinyInt(n2, n, (byte)iSqlDataWrapper.getTinyInt());
                    break;
                }
                case 5: {
                    inMemTable.setSmallInt(n2, n, (short)iSqlDataWrapper.getSmallInt());
                    break;
                }
                case 4: {
                    inMemTable.setInteger(n2, n, (int)iSqlDataWrapper.getInteger());
                    break;
                }
                case -5: {
                    inMemTable.setBigInt(n2, n, iSqlDataWrapper.getBigInt().longValue());
                    break;
                }
                case 7: {
                    inMemTable.setReal(n2, n, iSqlDataWrapper.getReal());
                    break;
                }
                case 6: 
                case 8: {
                    inMemTable.setDouble(n2, n, iSqlDataWrapper.getDouble());
                    break;
                }
                case 2: 
                case 3: {
                    inMemTable.setExactNum(n2, n, iSqlDataWrapper.getExactNumber());
                    break;
                }
                case -7: 
                case 16: {
                    inMemTable.setBoolean(n2, n, iSqlDataWrapper.getBoolean());
                    break;
                }
                case 91: {
                    inMemTable.setDate(n2, n, iSqlDataWrapper.getDate());
                    break;
                }
                case 92: {
                    inMemTable.setTime(n2, n, iSqlDataWrapper.getTime());
                    break;
                }
                case 93: {
                    inMemTable.setTimestamp(n2, n, iSqlDataWrapper.getTimestamp());
                    break;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    inMemTable.setString(n2, n, iSqlDataWrapper.getChar());
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    inMemTable.setBytes(n2, n, iSqlDataWrapper.getBinary());
                    break;
                }
                case -11: {
                    inMemTable.setGuid(n2, n, iSqlDataWrapper.getGuid());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(iColumn.getTypeMetadata().getTypeName());
                }
            }
        }
    }

    public int appendRow() {
        if (!this.canAppendRow()) {
            return -1;
        }
        if (!this.m_removedRows.isEmpty()) {
            Iterator<Integer> iterator = this.m_removedRows.iterator();
            this.m_curWritingRow = iterator.next();
            iterator.remove();
            ++this.m_numRows;
            return this.m_curWritingRow;
        }
        if (this.getCapacity() == this.m_numRows) {
            this.addEmptyRows();
        }
        ++this.m_numRows;
        this.m_curWritingRow = this.m_numRows - 1;
        if (this.m_curWritingRow > this.m_maxRowNumber) {
            this.m_maxRowNumber = this.m_curWritingRow;
        }
        return this.m_curWritingRow;
    }

    public int getMaxRowNumber() {
        return this.m_maxRowNumber;
    }

    public void removeRow(int n) {
        if (this.m_removedRows.contains(n)) {
            throw new IllegalArgumentException("Invalid row number");
        }
        for (int i = 0; i < this.m_columnMetadata.length; ++i) {
            if (!this.m_needsData[i] || this.isNull(n, i)) continue;
            if (this.m_isVarLenColumns[i]) {
                assert (this.m_columnMetadata[i].getTypeMetadata().isCharacterOrBinaryType());
                this.m_varLenColMemUsage = this.m_columnMetadata[i].getTypeMetadata().isCharacterType() ? (this.m_varLenColMemUsage -= this.getString(n, i).length() * 2) : (this.m_varLenColMemUsage -= this.getBytes(n, i).length);
            }
            this.setNull(n, i);
        }
        this.m_removedRows.add(n);
        if (n == this.m_curWritingRow) {
            this.m_curWritingRow = -1;
        }
        --this.m_numRows;
    }

    public long getMemLimit() {
        return this.m_memLimit;
    }

    public int getMemOverhead() {
        return (int)Math.ceil(this.m_memOverheadPerRow * (double)this.m_numRowPerSlice);
    }

    public int getNumRows() {
        return this.m_numRows;
    }

    public void setMemLimit(long l) {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, l);
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Setting a negative memory limit.");
        }
        this.m_memLimit = l;
    }

    public boolean isNull(int n, int n2) {
        return this.getSlice(n2, n).isNull(this.getSliceRowNum(n));
    }

    public long getBigInt(int n, int n2) {
        return this.getSlice(n2, n).getBigInt(this.getSliceRowNum(n));
    }

    public BigDecimal getExactNum(int n, int n2) {
        return this.getSlice(n2, n).getExactNum(this.getSliceRowNum(n));
    }

    public double getDouble(int n, int n2) {
        return this.getSlice(n2, n).getDouble(this.getSliceRowNum(n));
    }

    public float getReal(int n, int n2) {
        return this.getSlice(n2, n).getReal(this.getSliceRowNum(n));
    }

    public boolean getBoolean(int n, int n2) {
        return this.getSlice(n2, n).getBoolean(this.getSliceRowNum(n));
    }

    public String getString(int n, int n2) {
        return this.getSlice(n2, n).getString(this.getSliceRowNum(n));
    }

    public Date getDate(int n, int n2) {
        return this.getSlice(n2, n).getDate(this.getSliceRowNum(n));
    }

    public Time getTime(int n, int n2) {
        return this.getSlice(n2, n).getTime(this.getSliceRowNum(n));
    }

    public Timestamp getTimestamp(int n, int n2) {
        return this.getSlice(n2, n).getTimestamp(this.getSliceRowNum(n));
    }

    public UUID getGuid(int n, int n2) {
        return this.getSlice(n2, n).getGuid(this.getSliceRowNum(n));
    }

    public int getInteger(int n, int n2) {
        return this.getSlice(n2, n).getInteger(this.getSliceRowNum(n));
    }

    public short getSmallInt(int n, int n2) {
        return this.getSlice(n2, n).getSmallInt(this.getSliceRowNum(n));
    }

    public byte getTinyInt(int n, int n2) {
        return this.getSlice(n2, n).getTinyInt(this.getSliceRowNum(n));
    }

    public byte[] getBytes(int n, int n2) {
        return this.getSlice(n2, n).getBytes(this.getSliceRowNum(n));
    }

    public TemporaryFile.FileMarker getFileMarker(int n, int n2) {
        return this.getSlice(n2, n).getFileMarker(this.getSliceRowNum(n));
    }

    public IColumn getColumn(int n) {
        return this.m_columnMetadata[n];
    }

    public void setNull(int n, int n2) {
        this.getSlice(n2, n).setNull(this.getSliceRowNum(n));
    }

    public void setBigInt(int n, int n2, long l) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setBigInt(this.getSliceRowNum(n), l);
    }

    public void setExactNum(int n, int n2, BigDecimal bigDecimal) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setExactNum(this.getSliceRowNum(n), bigDecimal);
    }

    public void setDouble(int n, int n2, double d) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setDouble(this.getSliceRowNum(n), d);
    }

    public void setReal(int n, int n2, float f) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setReal(this.getSliceRowNum(n), f);
    }

    public void setBoolean(int n, int n2, boolean bl) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setBoolean(this.getSliceRowNum(n), bl);
    }

    public void setString(int n, int n2, String string) {
        assert (n2 < this.m_columnMetadata.length);
        assert (string != null);
        this.getSlice(n2, n).setString(this.getSliceRowNum(n), string);
        this.m_varLenColMemUsage += string.length() * 2;
    }

    public void setDate(int n, int n2, Date date) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setDate(this.getSliceRowNum(n), date);
    }

    public void setTime(int n, int n2, Time time) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setTime(this.getSliceRowNum(n), time);
    }

    public void setTimestamp(int n, int n2, Timestamp timestamp) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setTimestamp(this.getSliceRowNum(n), timestamp);
    }

    public void setFileMarker(int n, int n2, TemporaryFile.FileMarker fileMarker) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setFileMarker(this.getSliceRowNum(n), fileMarker);
    }

    public void setGuid(int n, int n2, UUID uUID) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setGuid(this.getSliceRowNum(n), uUID);
    }

    public void setInteger(int n, int n2, int n3) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setInteger(this.getSliceRowNum(n), n3);
    }

    public void setSmallInt(int n, int n2, short s) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setSmallInt(this.getSliceRowNum(n), s);
    }

    public void setTinyInt(int n, int n2, byte by) {
        assert (n2 < this.m_columnMetadata.length);
        this.getSlice(n2, n).setTinyInt(this.getSliceRowNum(n), by);
    }

    public void setBytes(int n, int n2, byte[] byArray) {
        assert (n2 < this.m_columnMetadata.length);
        assert (byArray != null);
        this.getSlice(n2, n).setBytes(this.getSliceRowNum(n), byArray);
        this.m_varLenColMemUsage += byArray.length;
    }

    public RowBlock toRowBlock() {
        if (null != this.m_logger) {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        }
        if (this.m_numRows == 0) {
            return null;
        }
        ColumnSliceArray columnSliceArray = ColumnSliceBuilder.buildColumnSliceArray(this.m_columnMetadata, this.m_needsData, this.m_numRows, this.m_maxDataLength);
        for (IColumnSlice iColumnSlice : columnSliceArray) {
            int n = 0;
            int n2 = 0;
            for (ColumnSliceArray columnSliceArray2 : this.m_data) {
                if (n2 == this.m_data.size() - 1) {
                    int n3 = this.m_numRows - this.m_numRowPerSlice * (this.m_data.size() - 1);
                    iColumnSlice.copy(columnSliceArray2.get(iColumnSlice.columnNumber()), 0, n3, n);
                    n += n3;
                } else {
                    iColumnSlice.copy(columnSliceArray2.get(iColumnSlice.columnNumber()), 0, this.m_numRowPerSlice, n);
                    n += columnSliceArray2.numRows();
                }
                ++n2;
            }
        }
        if (null != this.m_logger) {
            LogUtilities.logTrace(String.format("Write %d rows to new block", this.m_numRows), this.m_logger);
        }
        this.clear();
        RowBlock rowBlock = new RowBlock(columnSliceArray, this.m_columnMetadata, this.m_logger);
        return rowBlock;
    }

    public void clear() {
        for (int i = 0; i < this.m_data.size(); ++i) {
            this.m_data.clear();
        }
        this.m_numRows = 0;
        this.m_curWritingRow = -1;
        this.m_maxRowNumber = -1;
        this.m_varLenColMemUsage = 0;
        this.m_removedRows.clear();
    }

    private void addEmptyRows() {
        ColumnSliceArray columnSliceArray = ColumnSliceBuilder.buildColumnSliceArray(this.m_columnMetadata, this.m_needsData, this.m_numRowPerSlice, this.m_maxDataLength);
        this.m_data.add(columnSliceArray);
    }

    private int getCapacity() {
        if (this.m_data.size() == 0) {
            return 0;
        }
        return this.m_data.size() * this.m_numRowPerSlice;
    }

    protected IColumnSlice getSlice(int n, int n2) {
        return this.m_data.get(n2 / this.m_numRowPerSlice).get(n);
    }

    protected int getSliceRowNum(int n) {
        return n % this.m_numRowPerSlice;
    }

    public int getMemUsage() {
        if (this.m_maxRowNumber < 0) {
            return 0;
        }
        return (int)Math.ceil(this.m_memOverheadPerRow * (double)(this.m_maxRowNumber + 1) + this.m_fixLenDataSizePerRow * (double)this.m_numRows) + this.m_varLenColMemUsage;
    }

    public int getRowSize(int n) {
        int n2 = 0;
        for (int i = 0; i < this.m_isVarLenColumns.length; ++i) {
            if (!this.m_isVarLenColumns[i] || !this.m_needsData[i] || this.isNull(n, i)) continue;
            if (this.m_columnMetadata[i].getTypeMetadata().isCharacterType()) {
                n2 += this.getString(n, i).length() * 2;
                continue;
            }
            n2 += this.getBytes(n, i).length;
        }
        return n2 + (int)Math.ceil(this.m_memOverheadPerRow + this.m_fixLenDataSizePerRow);
    }

    public int getDataUsage() {
        return (int)Math.ceil(this.m_memOverheadPerRow * (double)this.m_numRows + this.m_fixLenDataSizePerRow * (double)this.m_numRows) + this.m_varLenColMemUsage;
    }

    protected boolean isOverMemLimit(long l) {
        return l > this.m_memLimit;
    }

    public boolean canAppendRow() {
        return this.m_numRows == 0 || !this.isOverMemLimit(this.m_maxRowSize + (long)this.getMemUsage());
    }

    public boolean isLongDataColumn(int n) {
        return this.m_isLongDataColumn[n];
    }

    public boolean retrieveData(int n, int n2, ETDataRequest eTDataRequest) throws ErrorException {
        if (this.m_isLongDataColumn[n2]) {
            throw new IllegalArgumentException("Cannot retrieve data from long data column");
        }
        if (this.isNull(n, n2)) {
            eTDataRequest.getData().setNull();
            return false;
        }
        ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
        switch (iSqlDataWrapper.getType()) {
            case -5: {
                long l = this.getBigInt(n, n2);
                iSqlDataWrapper.setBigInt(CompressionUtil.getlongAsBigInteger(l, this.m_columnMetadata[n2].getTypeMetadata().isSigned()));
                return false;
            }
            case 2: 
            case 3: {
                iSqlDataWrapper.setExactNumber(this.getExactNum(n, n2));
                return false;
            }
            case 6: 
            case 8: {
                iSqlDataWrapper.setDouble(this.getDouble(n, n2));
                return false;
            }
            case 7: {
                iSqlDataWrapper.setReal(this.getReal(n, n2));
                return false;
            }
            case -7: 
            case 16: {
                iSqlDataWrapper.setBoolean(this.getBoolean(n, n2));
                return false;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                iSqlDataWrapper.setChar(this.getString(n, n2));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                iSqlDataWrapper.setBinary(this.getBytes(n, n2));
                break;
            }
            case 91: {
                iSqlDataWrapper.setDate(this.getDate(n, n2));
                return false;
            }
            case 92: {
                iSqlDataWrapper.setTime(this.getTime(n, n2));
                return false;
            }
            case 93: {
                iSqlDataWrapper.setTimestamp(this.getTimestamp(n, n2));
                return false;
            }
            case -11: {
                iSqlDataWrapper.setGuid(this.getGuid(n, n2));
                return false;
            }
            case 4: {
                int n3 = this.getInteger(n, n2);
                iSqlDataWrapper.setInteger(CompressionUtil.getIntAsLong(n3, this.m_columnMetadata[n2].getTypeMetadata().isSigned()));
                return false;
            }
            case 5: {
                short s = this.getSmallInt(n, n2);
                iSqlDataWrapper.setSmallInt(CompressionUtil.getSmallIntAsInteger(s, this.m_columnMetadata[n2].getTypeMetadata().isSigned()));
                return false;
            }
            case -6: {
                byte by = this.getTinyInt(n, n2);
                iSqlDataWrapper.setTinyInt(CompressionUtil.getTinyIntAsShort(by, this.m_columnMetadata[n2].getTypeMetadata().isSigned()));
                return false;
            }
            default: {
                throw SQLEngineExceptionFactory.featureNotImplementedException("ISqlDataWrapper for type: " + iSqlDataWrapper.getType());
            }
        }
        if (eTDataRequest.getColumn().getTypeMetadata().isCharacterType()) {
            return DataRetrievalUtil.retrieveCharData(eTDataRequest.getData(), eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
        }
        assert (eTDataRequest.getColumn().getTypeMetadata().isBinaryType());
        return DataRetrievalUtil.retrieveBinaryData(eTDataRequest.getData(), eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
    }

    public void writeData(int n, int n2, ETRelationalExpr eTRelationalExpr) throws ErrorException {
        ETDataRequest eTDataRequest = this.m_requests[n2];
        if (eTDataRequest == null) {
            throw new IllegalArgumentException("Can not write long data.");
        }
        eTRelationalExpr.retrieveData(n2, eTDataRequest);
        ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
        if (iSqlDataWrapper.isNull()) {
            this.setNull(n, n2);
            return;
        }
        switch (iSqlDataWrapper.getType()) {
            case -5: {
                this.setBigInt(n, n2, iSqlDataWrapper.getBigInt().longValue());
                break;
            }
            case 2: 
            case 3: {
                this.setExactNum(n, n2, iSqlDataWrapper.getExactNumber());
                break;
            }
            case 6: 
            case 8: {
                this.setDouble(n, n2, iSqlDataWrapper.getDouble());
                break;
            }
            case 7: {
                this.setReal(n, n2, iSqlDataWrapper.getReal());
                break;
            }
            case -7: 
            case 16: {
                this.setBoolean(n, n2, iSqlDataWrapper.getBoolean());
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                this.setString(n, n2, iSqlDataWrapper.getChar());
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(n, n2, iSqlDataWrapper.getBinary());
                break;
            }
            case 91: {
                this.setDate(n, n2, iSqlDataWrapper.getDate());
                break;
            }
            case 92: {
                this.setTime(n, n2, iSqlDataWrapper.getTime());
                break;
            }
            case 93: {
                this.setTimestamp(n, n2, iSqlDataWrapper.getTimestamp());
                break;
            }
            case -11: {
                this.setGuid(n, n2, iSqlDataWrapper.getGuid());
                break;
            }
            case 4: {
                this.setInteger(n, n2, (int)iSqlDataWrapper.getInteger());
                break;
            }
            case 5: {
                this.setSmallInt(n, n2, (short)iSqlDataWrapper.getSmallInt());
                break;
            }
            case -6: {
                this.setTinyInt(n, n2, (byte)iSqlDataWrapper.getTinyInt());
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.featureNotImplementedException("ISqlDataWrapper for type: " + iSqlDataWrapper.getType());
            }
        }
    }

    public long getRowSize() {
        return this.m_maxRowSize;
    }

    public long reduceMemoryUsage() {
        while (this.m_removedRows.contains(this.m_maxRowNumber)) {
            this.m_removedRows.remove(this.m_maxRowNumber--);
        }
        long l = this.m_memLimit;
        this.m_memLimit = this.getMemUsage();
        return l -= this.m_memLimit;
    }

    public void increaseMemLimit(long l) {
        this.m_memLimit += l;
    }

    public void writeRow(int n, IRowView iRowView) {
        block17: for (int i = 0; i < this.m_needsData.length; ++i) {
            if (!this.m_needsData[i]) continue;
            if (iRowView.isNull(i)) {
                this.setNull(n, i);
                continue;
            }
            IColumnSlice iColumnSlice = this.getSlice(i, n);
            switch (iColumnSlice.getType()) {
                case BIGINT: {
                    iColumnSlice.setBigInt(this.getSliceRowNum(n), iRowView.getBigInt(i));
                    continue block17;
                }
                case BINARY: {
                    this.setBytes(n, i, iRowView.getBytes(i));
                    continue block17;
                }
                case BOOLEAN: {
                    iColumnSlice.setBoolean(this.getSliceRowNum(n), iRowView.getBoolean(i));
                    continue block17;
                }
                case CHAR: {
                    this.setString(n, i, iRowView.getString(i));
                    continue block17;
                }
                case DATE: {
                    iColumnSlice.setDate(this.getSliceRowNum(n), iRowView.getDate(i));
                    continue block17;
                }
                case DOUBLE: {
                    iColumnSlice.setDouble(this.getSliceRowNum(n), iRowView.getDouble(i));
                    continue block17;
                }
                case EXACT_NUM: {
                    iColumnSlice.setExactNum(this.getSliceRowNum(n), iRowView.getExactNumber(i));
                    continue block17;
                }
                case FILE_MARKER: {
                    iColumnSlice.setFileMarker(this.getSliceRowNum(n), iRowView.getFileMarker(i));
                    continue block17;
                }
                case GUID: {
                    iColumnSlice.setGuid(this.getSliceRowNum(n), iRowView.getGuid(i));
                    continue block17;
                }
                case INTEGER: {
                    iColumnSlice.setInteger(this.getSliceRowNum(n), iRowView.getInteger(i));
                    continue block17;
                }
                case REAL: {
                    iColumnSlice.setReal(this.getSliceRowNum(n), iRowView.getReal(i));
                    continue block17;
                }
                case SMALLINT: {
                    iColumnSlice.setSmallInt(this.getSliceRowNum(n), iRowView.getSmallInt(i));
                    continue block17;
                }
                case TIME: {
                    iColumnSlice.setTime(this.getSliceRowNum(n), iRowView.getTime(i));
                    continue block17;
                }
                case TIMESTAMP: {
                    iColumnSlice.setTimestamp(this.getSliceRowNum(n), iRowView.getTimestamp(i));
                    continue block17;
                }
                case TINYINT: {
                    iColumnSlice.setTinyInt(this.getSliceRowNum(n), iRowView.getTinyInt(i));
                    continue block17;
                }
                default: {
                    throw new IllegalStateException("Unknown column slice type.");
                }
            }
        }
    }

    public boolean isRowInTable(int n) {
        return n <= this.m_maxRowNumber && !this.m_removedRows.contains(n);
    }
}

