/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.value;

import com.simba.cassandra.dsi.dataengine.interfaces.IArray;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueExpr;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;

public final class FunctionParameterWrapper
implements ISqlDataWrapper {
    private final ETValueExpr m_valueExpr;
    private final IColumn m_columnMetadata;
    private ETDataRequest m_dataRequest = null;

    FunctionParameterWrapper(ETValueExpr eTValueExpr, IColumn iColumn) {
        if (null == eTValueExpr || null == iColumn) {
            throw new NullPointerException();
        }
        this.m_valueExpr = eTValueExpr;
        this.m_columnMetadata = iColumn;
        this.m_dataRequest = new ETDataRequest(this.m_columnMetadata);
    }

    @Override
    public BigInteger getBigInt() throws ErrorException {
        return this.retrieveData().getBigInt();
    }

    @Override
    public byte[] getBinary() throws ErrorException {
        return this.retrieveData().getBinary();
    }

    @Override
    public boolean getBoolean() throws ErrorException, NullPointerException {
        return this.retrieveData().getBoolean();
    }

    @Override
    public String getChar() throws ErrorException {
        return this.retrieveData().getChar();
    }

    @Override
    public Date getDate() throws ErrorException {
        return this.retrieveData().getDate();
    }

    @Override
    public BigDecimal getExactNumber() throws ErrorException {
        return this.retrieveData().getExactNumber();
    }

    @Override
    public double getDouble() throws ErrorException, NullPointerException {
        return this.retrieveData().getDouble();
    }

    @Override
    public UUID getGuid() throws ErrorException {
        return this.retrieveData().getGuid();
    }

    @Override
    public long getInteger() throws ErrorException, NullPointerException {
        return this.retrieveData().getInteger();
    }

    @Override
    public Object getInterval() throws ErrorException {
        return this.retrieveData().getInterval();
    }

    @Override
    public float getReal() throws ErrorException, NullPointerException {
        return this.retrieveData().getReal();
    }

    @Override
    public int getSmallInt() throws ErrorException, NullPointerException {
        return this.retrieveData().getSmallInt();
    }

    @Override
    public Time getTime() throws ErrorException {
        return this.retrieveData().getTime();
    }

    @Override
    public Timestamp getTimestamp() throws ErrorException {
        return this.retrieveData().getTimestamp();
    }

    @Override
    public short getTinyInt() throws ErrorException, NullPointerException {
        return this.retrieveData().getTinyInt();
    }

    @Override
    public int getType() {
        return this.m_columnMetadata.getTypeMetadata().getType();
    }

    @Override
    public boolean isNull() throws ErrorException {
        return this.retrieveData().isNull();
    }

    @Override
    public boolean isSet() {
        return null != this.m_dataRequest;
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IArray getArray() throws ErrorException, NullPointerException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(2003);
    }

    @Override
    public void setBigInt(BigInteger bigInteger) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinary(byte[] byArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoolean(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setChar(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(Date date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExactNumber(BigDecimal bigDecimal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGuid(UUID uUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInteger(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInterval(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReal(float f) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSmallInt(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(Time time) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(Timestamp timestamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTinyInt(short s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValue(DataWrapper dataWrapper) {
        throw new UnsupportedOperationException();
    }

    private ISqlDataWrapper retrieveData() throws ErrorException {
        if (!this.m_valueExpr.isOpen()) {
            throw new IllegalArgumentException("valueExpr is not open.");
        }
        if (this.m_valueExpr.retrieveData(this.m_dataRequest)) {
            throw new IllegalStateException();
        }
        return this.m_dataRequest.getData();
    }

    @Override
    public void setArray(IArray iArray) throws ErrorException {
        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(2003);
    }
}

