/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.value.scalar;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.TypeUtilities;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueExpr;
import com.simba.cassandra.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.util.List;

public final class ETCeilingFn
extends ETScalarFn {
    private final int m_resultType;

    public ETCeilingFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == list.size() && 1 == list2.size());
        short s = iColumn.getTypeMetadata().getType();
        assert (TypeUtilities.isNumberType(s));
        assert (list2.get(0).getTypeMetadata().getType() == s);
        this.m_resultType = s;
    }

    @Override
    public String getLogString() {
        return "ETCeilingFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
        } else {
            switch (this.m_resultType) {
                case -6: {
                    eTDataRequest.getData().setTinyInt(iSqlDataWrapper.getTinyInt());
                    break;
                }
                case 5: {
                    eTDataRequest.getData().setSmallInt(iSqlDataWrapper.getSmallInt());
                    break;
                }
                case 4: {
                    eTDataRequest.getData().setInteger(iSqlDataWrapper.getInteger());
                    break;
                }
                case -5: {
                    eTDataRequest.getData().setBigInt(iSqlDataWrapper.getBigInt());
                    break;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = iSqlDataWrapper.getExactNumber();
                    eTDataRequest.getData().setExactNumber(bigDecimal.setScale(0, 2));
                    break;
                }
                case 7: {
                    eTDataRequest.getData().setReal((float)Math.ceil(iSqlDataWrapper.getReal()));
                    break;
                }
                default: {
                    eTDataRequest.getData().setDouble(Math.ceil(iSqlDataWrapper.getDouble()));
                }
            }
        }
        return false;
    }
}

