/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.parser;

import com.simba.cassandra.sqlengine.exceptions.SQLEngineException;
import com.simba.cassandra.sqlengine.parser.DefaultLimitChecker;
import com.simba.cassandra.sqlengine.parser.IPTLimitChecker;
import com.simba.cassandra.sqlengine.parser.generated.Parser;
import com.simba.cassandra.sqlengine.parser.parsetree.IPTNode;
import com.simba.cassandra.sqlengine.parser.type.PTStringConstraint;

public class PTParser {
    private PTParser() {
        throw new UnsupportedOperationException("Not instantiable");
    }

    public static IPTNode parse(String string) throws SQLEngineException {
        return PTParser.parse(string, new DefaultLimitChecker());
    }

    public static IPTNode parse(String string, IPTLimitChecker iPTLimitChecker) throws SQLEngineException {
        if (null == string) {
            throw new NullPointerException("sqlStatement must not be null");
        }
        if (null == iPTLimitChecker) {
            throw new NullPointerException("limitChecker must not be null");
        }
        iPTLimitChecker.checkString(PTStringConstraint.STATEMENT_LEN, string);
        return new Parser(string, iPTLimitChecker).parse();
    }
}

