/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.core;

import com.simba.cassandra.cassandra.core.CDBJDBCEnvironment;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.dsi.core.impl.DSIDriver;
import com.simba.cassandra.dsi.core.impl.DSILogger;
import com.simba.cassandra.dsi.core.interfaces.IEnvironment;
import com.simba.cassandra.dsi.core.utilities.Variant;
import com.simba.cassandra.jdbc.common.ProductInfoHandlerContext;
import com.simba.cassandra.sqlengine.SQLEngineGenericContext;
import com.simba.cassandra.support.exceptions.ErrorException;
import com.simba.cassandra.support.exceptions.ExceptionBuilder;
import com.simba.cassandra.support.exceptions.ExceptionUtilities;
import java.text.MessageFormat;

public class CDBJDBCDriver
extends DSIDriver {
    public static final String DRIVER_NAME = "CassandraJDBC";
    public static final String DATABASE_NAME = "Cassandra";
    public static final int DRIVER_MAJOR_VERSION = 2;
    public static final int DRIVER_MINOR_VERSION = 0;
    public static final int DRIVER_HOT_FIX_VERSION = 4;
    public static final int DRIVER_BUILD_NUMBER = 1004;
    public static final String VENDOR_NAME = "Simba";
    private static final String LOG_NAME = "CassandraJDBC_driver";
    public static final String RESOURCE_NAME = "messages";
    public static ExceptionBuilder s_DriverMessages = new ExceptionBuilder(101);
    private DSILogger m_log;

    public CDBJDBCDriver() throws ErrorException {
        this.setDefaultProperties();
        StringBuilder stringBuilder = new StringBuilder(ExceptionUtilities.getPackageName(this.getClass()));
        stringBuilder.append(".");
        stringBuilder.append(RESOURCE_NAME);
        this.m_msgSrc.registerMessages(stringBuilder.toString(), 101, "CassandraJDBCDriver");
        SQLEngineGenericContext.setDefaultMsgSource(this.m_msgSrc);
        ProductInfoHandlerContext.setDefaultMsgSource(this.m_msgSrc, "CassandraJDBCDriver");
        this.m_msgSrc.setVendorName(VENDOR_NAME);
    }

    @Override
    public IEnvironment createEnvironment() throws ErrorException {
        return new CDBJDBCEnvironment(this);
    }

    @Override
    public DSILogger getDriverLog() {
        if (null == this.m_log) {
            this.m_log = new DSILogger(LOG_NAME);
        }
        return this.m_log;
    }

    private void setDefaultProperties() throws ErrorException {
        try {
            this.setProperty(3, new Variant(0, DRIVER_NAME));
            String string = MessageFormat.format("{0,number,00}.{1,number,00}.{2,number,00}.{3,number,0000}", 2, 0, 4, 1004);
            this.setProperty(5, new Variant(0, string));
            this.setProperty(1000, new Variant(5, (short)1));
            this.setProperty(10, new Variant(6, 1));
        }
        catch (Throwable throwable) {
            ErrorException errorException = s_DriverMessages.createGeneralException(CDBJDBCMessageKey.DRIVER_DEFAULT_PROP_ERR.name(), "Driver property set error");
            errorException.initCause(throwable);
            throw errorException;
        }
    }
}

