/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.jsql.passdown;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.dataengine.jsql.passdown.CDBJDBCExtBooleanExprPassdownVisitor;
import com.simba.cassandra.cassandra.dataengine.jsql.passdown.CDBJDBCVisitResult;
import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCReadTable;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtAbstractBooleanExprHandler;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtBooleanExprPassdownVisitor;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CDBFilterHandler
extends DSIExtAbstractBooleanExprHandler {
    private CDBJDBCConnectionSettings m_settings;
    private boolean m_fullPassDownPossible = true;
    boolean m_hasStartedPassingDown = false;
    private ILogger m_logger;
    private Set<AEComparison> m_nodesCanBePasseddown = new HashSet<AEComparison>();
    private int m_parameterSetCount;
    private boolean m_isPassDownPossible = false;
    private CDBJDBCReadTable m_table;

    public CDBFilterHandler(CDBJDBCReadTable cDBJDBCReadTable, int n, ILogger iLogger, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) {
        LogUtilities.logFunctionEntrance(iLogger, cDBJDBCReadTable);
        this.m_table = cDBJDBCReadTable;
        this.m_logger = iLogger;
        this.m_parameterSetCount = n;
        this.m_settings = cDBJDBCConnectionSettings;
    }

    @Override
    public boolean canHandleMoreClauses() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_isPassDownPossible && !this.m_fullPassDownPossible;
    }

    @Override
    public boolean passdown(AEBooleanExpr aEBooleanExpr) {
        int n;
        LogUtilities.logFunctionEntrance(this.m_logger, aEBooleanExpr);
        if (!this.m_hasStartedPassingDown) {
            try {
                CDBJDBCVisitResult cDBJDBCVisitResult = aEBooleanExpr.acceptVisitor(new CDBJDBCExtBooleanExprPassdownVisitor(this.m_parameterSetCount, this.m_settings.m_enableCaseSensitive));
                n = cDBJDBCVisitResult.getFilteredPartitionKeys().size();
                int n2 = this.m_table.getMetadata().getPartitionKeys().size();
                int n3 = cDBJDBCVisitResult.getIndexesFilters().size();
                if (n != 0 && n != n2 || n == 0 && n3 == 0) {
                    this.m_isPassDownPossible = false;
                } else {
                    int n4;
                    Object object;
                    StringBuilder stringBuilder = new StringBuilder();
                    List<String> list = cDBJDBCVisitResult.getPartitionKeysFilters();
                    if (0 < list.size()) {
                        stringBuilder.append(list.get(0));
                        for (int i = 1; i < list.size(); ++i) {
                            stringBuilder.append(" AND ");
                            stringBuilder.append(list.get(i));
                        }
                    }
                    StringBuilder stringBuilder2 = new StringBuilder();
                    List<String> list2 = cDBJDBCVisitResult.getClusteringKeysFilters();
                    if (0 < list2.size()) {
                        stringBuilder2.append(list2.get(0));
                        for (int i = 1; i < list2.size(); ++i) {
                            stringBuilder2.append(" AND ");
                            stringBuilder2.append(list2.get(i));
                        }
                    }
                    Set<String> set = cDBJDBCVisitResult.getFilteredClusteringKeys();
                    List<IColumn> list3 = this.m_table.getMetadata().getClusteringKeys();
                    boolean bl = true;
                    if (0 < set.size()) {
                        object = null;
                        for (n4 = 0; bl && n4 < set.size(); ++n4) {
                            object = list3.get(n4).getName();
                            if (set.contains(object)) continue;
                            bl = false;
                        }
                    }
                    if (set.size() != list3.size()) {
                        this.m_table.setAllowFilteringNeeded();
                    }
                    if (bl) {
                        this.m_nodesCanBePasseddown.addAll(cDBJDBCVisitResult.getClusteringKeysNode());
                        if (0 < stringBuilder.length() && 0 < stringBuilder2.length()) {
                            stringBuilder.append(" AND ");
                        }
                        stringBuilder.append((CharSequence)stringBuilder2);
                    }
                    if (0 < (object = cDBJDBCVisitResult.getIndexesFilters()).size()) {
                        if (0 < stringBuilder.length()) {
                            stringBuilder.append(" AND ");
                        }
                        stringBuilder.append((String)object.get(0));
                        for (n4 = 1; n4 < object.size(); ++n4) {
                            stringBuilder.append(" AND ");
                            stringBuilder.append((String)object.get(n4));
                        }
                    }
                    this.m_fullPassDownPossible = cDBJDBCVisitResult.areAllFilterPartsEligibleForPassdown();
                    this.m_isPassDownPossible = cDBJDBCVisitResult.isPassDownPossible();
                    this.m_nodesCanBePasseddown.addAll(cDBJDBCVisitResult.getPartitionKeysNode());
                    this.m_nodesCanBePasseddown.addAll(cDBJDBCVisitResult.getIndexesNode());
                    this.m_table.addFilters(stringBuilder.toString());
                }
            }
            catch (ErrorException errorException) {
                return false;
            }
            this.m_hasStartedPassingDown = true;
        }
        assert (aEBooleanExpr != null);
        n = new DSIExtBooleanExprPassdownVisitor(this).passDown(aEBooleanExpr);
        return n != 0;
    }

    @Override
    public DSIExtJResultSet takeResult() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        CDBJDBCReadTable cDBJDBCReadTable = null;
        cDBJDBCReadTable = this.m_isPassDownPossible ? this.m_table : null;
        return cDBJDBCReadTable;
    }

    @Override
    protected boolean passdownComparison(AEComparison aEComparison) {
        LogUtilities.logFunctionEntrance(this.m_logger, aEComparison);
        return this.m_nodesCanBePasseddown.contains(aEComparison);
    }
}

