/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.jsql.passdown;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.dataengine.jsql.passdown.CDBAggregationHandler;
import com.simba.cassandra.cassandra.dataengine.jsql.passdown.CDBFilterHandler;
import com.simba.cassandra.cassandra.dataengine.jsql.passdown.CDBProjectionHandler;
import com.simba.cassandra.cassandra.dataengine.jsql.passdown.CDBTopHandler;
import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCReadTable;
import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCResultsBase;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtOperationHandlerFactory;
import com.simba.cassandra.sqlengine.dsiext.dataengine.IAggregationHandler;
import com.simba.cassandra.sqlengine.dsiext.dataengine.IBooleanExprHandler;
import com.simba.cassandra.sqlengine.dsiext.dataengine.IDistinctHandler;
import com.simba.cassandra.sqlengine.dsiext.dataengine.IProjectionHandler;
import com.simba.cassandra.sqlengine.dsiext.dataengine.ISortHandler;
import com.simba.cassandra.sqlengine.dsiext.dataengine.ITopHandler;
import com.simba.cassandra.sqlengine.dsiext.dataengine.IUnionHandler;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;

public class CDBJDBCOperationHandlerFactory
implements DSIExtOperationHandlerFactory {
    private CDBJDBCConnectionSettings m_settings;
    private ILogger m_logger;
    private int m_parameterSetCount;

    public CDBJDBCOperationHandlerFactory(ILogger iLogger, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) {
        this.m_logger = iLogger;
        this.m_settings = cDBJDBCConnectionSettings;
    }

    @Override
    public void setParameterSetCount(int n) {
        LogUtilities.logFunctionEntrance(this.m_logger, n);
        this.m_parameterSetCount = n;
    }

    @Override
    public IBooleanExprHandler createFilterHandler(DSIExtJResultSet dSIExtJResultSet) {
        LogUtilities.logFunctionEntrance(this.m_logger, dSIExtJResultSet);
        CDBJDBCResultsBase cDBJDBCResultsBase = (CDBJDBCResultsBase)dSIExtJResultSet;
        if (cDBJDBCResultsBase.isAggregationPassdown()) {
            return null;
        }
        return new CDBFilterHandler((CDBJDBCReadTable)dSIExtJResultSet, this.m_parameterSetCount, this.m_logger, this.m_settings);
    }

    @Override
    public IBooleanExprHandler createJoinHandler(DSIExtJResultSet dSIExtJResultSet, DSIExtJResultSet dSIExtJResultSet2, AEJoin.AEJoinType aEJoinType) {
        LogUtilities.logFunctionEntrance(this.m_logger, dSIExtJResultSet, dSIExtJResultSet2);
        return null;
    }

    @Override
    public IAggregationHandler createAggregationHandler(DSIExtJResultSet dSIExtJResultSet) {
        CDBJDBCReadTable cDBJDBCReadTable = (CDBJDBCReadTable)dSIExtJResultSet;
        if (cDBJDBCReadTable.isVirtualTable()) {
            return null;
        }
        return new CDBAggregationHandler(cDBJDBCReadTable, this.m_logger, this.m_settings);
    }

    @Override
    public IProjectionHandler createProjectionHandler(DSIExtJResultSet dSIExtJResultSet) {
        CDBJDBCResultsBase cDBJDBCResultsBase = (CDBJDBCResultsBase)dSIExtJResultSet;
        if (cDBJDBCResultsBase.isAggregationPassdown()) {
            return null;
        }
        return new CDBProjectionHandler((CDBJDBCReadTable)dSIExtJResultSet, this.m_logger);
    }

    @Override
    public ITopHandler createTopHandler(DSIExtJResultSet dSIExtJResultSet) {
        CDBJDBCResultsBase cDBJDBCResultsBase = (CDBJDBCResultsBase)dSIExtJResultSet;
        if (cDBJDBCResultsBase.isAggregationPassdown()) {
            return null;
        }
        return new CDBTopHandler((CDBJDBCReadTable)dSIExtJResultSet, this.m_logger);
    }

    @Override
    public ISortHandler createSortHandler(DSIExtJResultSet dSIExtJResultSet) {
        return null;
    }

    @Override
    public IDistinctHandler createDistinctHandler(DSIExtJResultSet dSIExtJResultSet) {
        return null;
    }

    @Override
    public IUnionHandler createUnionHandler() {
        return null;
    }
}

