/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.metadata;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.ICDBJDBCTableMetadata;
import com.simba.cassandra.cassandra.dataengine.metadata.utils.CDBJDBCMetadataUtils;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.cassandra.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.cassandra.shaded.datastax.driver.core.KeyspaceMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.Metadata;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CDBJDBCPrimaryKeysMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private int m_currentIndex = 0;
    private boolean m_hasStartedFetch = false;
    private List<PrimaryKeyInfo> m_primaryKeys = new ArrayList<PrimaryKeyInfo>();
    private CDBJDBCConnectionSettings m_settings;

    public CDBJDBCPrimaryKeysMetadataSource(ILogger iLogger, Metadata metadata, Map<MetadataSourceColumnTag, String> map, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_settings = cDBJDBCConnectionSettings;
        this.initializeData(metadata, map);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case PRIMARY_KEY_CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_primaryKeys.get((int)this.m_currentIndex).m_tableCatalog, dataWrapper, l, l2);
            }
            case PRIMARY_KEY_SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_primaryKeys.get((int)this.m_currentIndex).m_tableSchema, dataWrapper, l, l2);
            }
            case PRIMARY_KEY_TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_primaryKeys.get((int)this.m_currentIndex).m_tableName, dataWrapper, l, l2);
            }
            case PRIMARY_KEY_COLUMN_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_primaryKeys.get((int)this.m_currentIndex).m_columnName, dataWrapper, l, l2);
            }
            case PRIMARY_KEY_NAME: {
                dataWrapper.setNull(12);
                return false;
            }
            case KEY_SEQ: {
                dataWrapper.setSmallInt(this.m_primaryKeys.get((int)this.m_currentIndex).m_keySequence);
                return false;
            }
        }
        throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_currentIndex + 1 < this.m_primaryKeys.size();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_hasStartedFetch) {
            ++this.m_currentIndex;
        } else {
            this.m_hasStartedFetch = true;
            this.m_currentIndex = 0;
        }
        return this.m_currentIndex < this.m_primaryKeys.size();
    }

    private void initializeData(Metadata metadata, Map<MetadataSourceColumnTag, String> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME);
        String string2 = CDBJDBCMetadataUtils.getCatalog(string, this.m_settings);
        if (null != string2) {
            String string3 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
            String string4 = map.get((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME);
            List<KeyspaceMetadata> list = CDBJDBCMetadataUtils.getSchema(metadata, string3, this.m_settings);
            List<Object> list2 = new ArrayList();
            for (KeyspaceMetadata keyspaceMetadata : list) {
                list2 = CDBJDBCMetadataUtils.getTables(keyspaceMetadata, string4, this.m_settings);
                for (ICDBJDBCTableMetadata iCDBJDBCTableMetadata : list2) {
                    StringBuilder stringBuilder = new StringBuilder();
                    int n = 1;
                    for (IColumn iColumn : iCDBJDBCTableMetadata.getPrimaryKeys()) {
                        PrimaryKeyInfo primaryKeyInfo = new PrimaryKeyInfo();
                        primaryKeyInfo.m_tableCatalog = "cassandra";
                        primaryKeyInfo.m_tableSchema = keyspaceMetadata.getName();
                        primaryKeyInfo.m_tableName = iCDBJDBCTableMetadata.getName();
                        primaryKeyInfo.m_columnName = iColumn.getName();
                        primaryKeyInfo.m_keySequence = n++;
                        this.m_primaryKeys.add(primaryKeyInfo);
                        if (n > 2) {
                            stringBuilder.append("_");
                        }
                        stringBuilder.append(iColumn.getName());
                    }
                }
            }
        }
    }

    private static class PrimaryKeyInfo {
        public String m_tableCatalog;
        public String m_tableSchema;
        public String m_tableName;
        public String m_columnName;
        public int m_keySequence;

        private PrimaryKeyInfo() {
        }
    }
}

