/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.metadata.schemamap;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.utils.CDBJDBCDataTypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.cassandra.dsi.dataengine.utilities.TypeMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.TableMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.UserType;
import com.simba.cassandra.support.exceptions.ErrorException;

public class CDBJDBCColumnMetadata
extends ColumnMetadata {
    private com.simba.cassandra.shaded.datastax.driver.core.ColumnMetadata m_colMetadata;
    private boolean m_isPartitionKey;
    private boolean m_isClusteringKey;
    private boolean m_isVirtual = false;
    private boolean m_isVirtualPrimaryKey = false;
    private boolean m_isUDT = false;
    private CDBJDBCConnectionSettings m_settings;
    private DataType m_collectionType;
    private UserType m_udtType;
    private DataType m_typeArgument;
    private Integer m_typeArgumentIndex;
    private DataType m_udtFieldType;
    private Integer m_udtFieldIndex;

    public CDBJDBCColumnMetadata(String string, String string2, int n, com.simba.cassandra.shaded.datastax.driver.core.ColumnMetadata columnMetadata, String string3, DataType dataType, boolean bl, boolean bl2, Integer n2, Integer n3, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) throws ErrorException {
        super(TypeMetadata.createTypeMetadata(n));
        this.m_settings = cDBJDBCConnectionSettings;
        boolean bl3 = bl || bl2;
        CDBJDBCDataTypeUtilities.updateMetadata(this, this.m_settings, bl3);
        this.setName(string3);
        this.setLabel(string3);
        this.setCatalogName("cassandra");
        this.setSchemaName(string);
        this.setTableName(string2);
        this.m_colMetadata = columnMetadata;
        if (columnMetadata.getType().isCollection()) {
            if (null == n3) {
                this.setCollectionInfo(columnMetadata, n2);
            } else {
                this.setCollectionInfo(columnMetadata, n2, dataType, n3);
            }
        } else if (null != n3) {
            this.m_isPartitionKey = bl;
            this.m_isClusteringKey = bl2;
            this.setUDTInfo(columnMetadata, dataType, n3);
        }
    }

    public CDBJDBCColumnMetadata(TableMetadata tableMetadata, com.simba.cassandra.shaded.datastax.driver.core.ColumnMetadata columnMetadata, boolean bl, boolean bl2, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) throws ErrorException {
        super(TypeMetadata.createTypeMetadata(CDBJDBCDataTypeUtilities.toSQLType(columnMetadata.getType().getName())));
        this.m_settings = cDBJDBCConnectionSettings;
        this.m_isPartitionKey = bl;
        this.m_isClusteringKey = bl2;
        boolean bl3 = bl2 || bl;
        CDBJDBCDataTypeUtilities.updateMetadata(this, this.m_settings, bl3);
        this.setName(columnMetadata.getName());
        this.setLabel(columnMetadata.getName());
        this.setCatalogName("cassandra");
        this.setSchemaName(tableMetadata.getKeyspace().getName());
        this.setTableName(tableMetadata.getName());
        this.m_colMetadata = columnMetadata;
    }

    public Integer getCollectionIndex() {
        return this.m_typeArgumentIndex;
    }

    public DataType getCollectionType() {
        return this.m_collectionType;
    }

    public DataType getCollectionElementType() {
        return this.m_typeArgument;
    }

    public DataType getUDTFieldType() {
        return this.m_udtFieldType;
    }

    public Integer getUDTFieldIndex() {
        return this.m_udtFieldIndex;
    }

    public UserType getUDTType() {
        return this.m_udtType;
    }

    public boolean isClusteringKey() {
        return this.m_isClusteringKey;
    }

    public boolean isCollection() {
        return null != this.m_collectionType;
    }

    public boolean isIndex() {
        return null != ((TableMetadata)this.m_colMetadata.getParent()).getIndex(this.m_colMetadata.getName());
    }

    public boolean isPrimaryKey() {
        return this.m_isPartitionKey || this.m_isClusteringKey;
    }

    public boolean isStatic() {
        return this.m_colMetadata.isStatic();
    }

    public boolean isVirtual() {
        return this.m_isVirtual;
    }

    public boolean isVirtualPrimaryKey() {
        return this.m_isVirtualPrimaryKey;
    }

    public boolean isPartitionKey() {
        return this.m_isPartitionKey;
    }

    public void setIsVirtualPrimaryKey(boolean bl) {
        this.m_isVirtualPrimaryKey = bl;
    }

    public boolean isUDT() {
        return this.m_isUDT;
    }

    public com.simba.cassandra.shaded.datastax.driver.core.ColumnMetadata unwrap() {
        return this.m_colMetadata;
    }

    private void setCollectionInfo(com.simba.cassandra.shaded.datastax.driver.core.ColumnMetadata columnMetadata, Integer n) {
        this.m_collectionType = columnMetadata.getType();
        this.m_typeArgumentIndex = n;
        if (null != n) {
            this.m_typeArgument = this.m_collectionType.getTypeArguments().get(n);
        } else {
            this.m_isVirtual = true;
        }
    }

    private void setCollectionInfo(com.simba.cassandra.shaded.datastax.driver.core.ColumnMetadata columnMetadata, Integer n, DataType dataType, Integer n2) {
        this.m_collectionType = columnMetadata.getType();
        this.m_typeArgumentIndex = n;
        if (null != n) {
            this.m_typeArgument = this.m_collectionType.getTypeArguments().get(n);
            this.m_udtFieldIndex = n2;
            this.m_udtType = (UserType)this.m_typeArgument;
            this.m_udtFieldType = dataType;
            this.m_isUDT = true;
        } else {
            this.m_isVirtual = true;
        }
    }

    private void setUDTInfo(com.simba.cassandra.shaded.datastax.driver.core.ColumnMetadata columnMetadata, DataType dataType, Integer n) {
        this.m_udtType = (UserType)columnMetadata.getType();
        this.m_udtFieldIndex = n;
        this.m_udtFieldType = dataType;
        this.m_isUDT = true;
    }
}

