/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.utils;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.cassandra.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.dataengine.utilities.Nullable;
import com.simba.cassandra.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.cassandra.dsi.dataengine.utilities.ParameterType;
import com.simba.cassandra.dsi.dataengine.utilities.TimeTz;
import com.simba.cassandra.dsi.dataengine.utilities.TimestampTz;
import com.simba.cassandra.dsi.dataengine.utilities.TypeMetadata;
import com.simba.cassandra.dsi.dataengine.utilities.TypeUtilities;
import com.simba.cassandra.dsi.exceptions.IncorrectTypeException;
import com.simba.cassandra.shaded.datastax.driver.core.BoundStatement;
import com.simba.cassandra.shaded.datastax.driver.core.CodecRegistry;
import com.simba.cassandra.shaded.datastax.driver.core.ColumnDefinitions;
import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.LocalDate;
import com.simba.cassandra.shaded.datastax.driver.core.Row;
import com.simba.cassandra.shaded.datastax.driver.core.SettableByIndexData;
import com.simba.cassandra.shaded.datastax.driver.core.TupleType;
import com.simba.cassandra.shaded.datastax.driver.core.TupleValue;
import com.simba.cassandra.shaded.datastax.driver.core.TypeCodec;
import com.simba.cassandra.shaded.datastax.driver.core.UDTValue;
import com.simba.cassandra.shaded.datastax.driver.core.UserType;
import com.simba.cassandra.shaded.joda.time.DateTime;
import com.simba.cassandra.shaded.joda.time.LocalTime;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.conv.ConversionResult;
import com.simba.cassandra.support.conv.HexToBinaryConverter;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;

public class CDBJDBCDataTypeUtilities {
    private static final Map<DataType.Name, Integer> s_cqlToSql = CDBJDBCDataTypeUtilities.initializeTypeMapping();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final short TIME_PRECISION = 3;
    private static final short TIME_SCALE_PRECISION = 12;

    public static void bindCqlData(BoundStatement boundStatement, int n, int n2, Row row) throws ErrorException {
        DataType.Name name = row.getColumnDefinitions().getType(n).getName();
        if (row.isNull(n)) {
            boundStatement.setToNull(n2);
        } else {
            switch (name) {
                case ASCII: 
                case VARCHAR: 
                case TEXT: {
                    boundStatement.setString(n2, row.getString(n));
                    break;
                }
                case BIGINT: 
                case COUNTER: {
                    boundStatement.setLong(n2, row.getLong(n));
                    break;
                }
                case BLOB: {
                    boundStatement.setBytes(n2, row.getBytes(n));
                    break;
                }
                case BOOLEAN: {
                    boundStatement.setBool(n2, row.getBool(n));
                    break;
                }
                case DATE: {
                    boundStatement.setDate(n2, row.getDate(n));
                    break;
                }
                case DECIMAL: {
                    boundStatement.setDecimal(n2, row.getDecimal(n));
                    break;
                }
                case DOUBLE: {
                    boundStatement.setDouble(n2, row.getDouble(n));
                    break;
                }
                case FLOAT: {
                    boundStatement.setFloat(n2, row.getFloat(n));
                    break;
                }
                case INET: {
                    InetAddress inetAddress = row.getInet(n);
                    if (null == inetAddress) {
                        boundStatement.setBytesUnsafe(n2, row.getBytesUnsafe(n));
                        break;
                    }
                    boundStatement.setInet(n2, inetAddress);
                    break;
                }
                case INT: {
                    boundStatement.setInt(n2, row.getInt(n));
                    break;
                }
                case SMALLINT: {
                    boundStatement.setShort(n2, row.getShort(n));
                    break;
                }
                case TIME: {
                    boundStatement.setTime(n2, row.getTime(n));
                    break;
                }
                case TIMESTAMP: {
                    boundStatement.setTimestamp(n2, row.getTimestamp(n));
                    break;
                }
                case TINYINT: {
                    boundStatement.setByte(n2, row.getByte(n));
                    break;
                }
                case TIMEUUID: 
                case UUID: {
                    boundStatement.setUUID(n2, row.getUUID(n));
                    break;
                }
                case VARINT: {
                    boundStatement.setVarint(n2, row.getVarint(n));
                    break;
                }
                default: {
                    boundStatement.setBytesUnsafe(n2, row.getBytesUnsafe(n));
                }
            }
        }
    }

    public static void bindSqlDataToCassValue(SettableByIndexData<?> settableByIndexData, int n, DataWrapper dataWrapper, short s, DataType dataType, ILogger iLogger) throws ErrorException {
        boolean bl = false;
        try {
            if (!dataWrapper.isNull()) {
                block1 : switch (s) {
                    case -5: {
                        settableByIndexData.setLong(n, dataWrapper.getBigIntAsLong());
                        break;
                    }
                    case 16: {
                        settableByIndexData.setBool(n, dataWrapper.getBoolean());
                        break;
                    }
                    case 91: {
                        int n2;
                        int n3;
                        int n4;
                        String string = dataWrapper.getDate().toString();
                        if (!string.isEmpty()) {
                            String[] stringArray = string.split("-");
                            n4 = Integer.parseInt(stringArray[0]);
                            n3 = Integer.parseInt(stringArray[1]);
                            n2 = Integer.parseInt(stringArray[2]);
                            LocalDate localDate = LocalDate.fromMillisSinceEpoch(dataWrapper.getDate().getTime());
                            if (localDate.getYear() < 0) {
                                n4 = -n4;
                            }
                        } else {
                            n4 = 0;
                            n3 = 0;
                            n2 = 0;
                            String string2 = "Empty Date string: Setting to default 0-0-0";
                            LogUtilities.logInfo(string2, iLogger);
                        }
                        settableByIndexData.setDate(n, LocalDate.fromYearMonthDay(n4, n3, n2));
                        break;
                    }
                    case 3: {
                        settableByIndexData.setDecimal(n, dataWrapper.getDecimal());
                        break;
                    }
                    case 2: {
                        settableByIndexData.setVarint(n, dataWrapper.getNumeric().toBigInteger());
                        break;
                    }
                    case 8: {
                        settableByIndexData.setDouble(n, dataWrapper.getDouble());
                        break;
                    }
                    case 4: {
                        settableByIndexData.setInt(n, new Integer(dataWrapper.getInteger().intValue()));
                        break;
                    }
                    case -4: {
                        settableByIndexData.setBytes(n, ByteBuffer.wrap(dataWrapper.getLongVarBinary()));
                        break;
                    }
                    case 7: {
                        settableByIndexData.setFloat(n, dataWrapper.getReal().floatValue());
                        break;
                    }
                    case 5: {
                        settableByIndexData.setShort(n, new Short(dataWrapper.getSmallInt().shortValue()));
                        break;
                    }
                    case 92: {
                        TimeTz timeTz = dataWrapper.getTimeTz();
                        DateTime dateTime = new DateTime(timeTz.getTime());
                        long l = TimeUnit.NANOSECONDS.convert(dateTime.getMillisOfDay(), TimeUnit.MILLISECONDS);
                        settableByIndexData.setTime(n, l);
                        break;
                    }
                    case 93: {
                        TimestampTz timestampTz = dataWrapper.getTimestampTz();
                        settableByIndexData.setTimestamp(n, timestampTz);
                        break;
                    }
                    case -6: {
                        settableByIndexData.setByte(n, new Byte(dataWrapper.getTinyInt().byteValue()));
                        break;
                    }
                    case 12: {
                        String string = dataWrapper.getVarChar();
                        switch (dataType.getName()) {
                            case ASCII: 
                            case VARCHAR: 
                            case TEXT: {
                                settableByIndexData.setString(n, string);
                                break block1;
                            }
                            case INET: {
                                settableByIndexData.setInet(n, CDBJDBCDataTypeUtilities.stringToInet(string));
                                break block1;
                            }
                            case TIMEUUID: 
                            case UUID: {
                                settableByIndexData.setUUID(n, UUID.fromString(string));
                                break block1;
                            }
                            case TUPLE: {
                                TupleType tupleType = (TupleType)dataType;
                                settableByIndexData.setTupleValue(n, CDBJDBCDataTypeUtilities.stringToTuple(string, tupleType));
                                break block1;
                            }
                            case UDT: {
                                UserType userType = (UserType)dataType;
                                settableByIndexData.setUDTValue(n, CDBJDBCDataTypeUtilities.stringToUDT(string, userType));
                                break block1;
                            }
                            case DECIMAL: {
                                settableByIndexData.setDecimal(n, new BigDecimal(string));
                                break block1;
                            }
                        }
                        settableByIndexData.setBytesUnsafe(n, ByteBuffer.wrap(string.getBytes()));
                        break;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
            } else {
                settableByIndexData.setToNull(n);
            }
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.PARAMETER_BINDING_BUILD_ERR.name(), new String[]{Integer.toString(n), exception.getLocalizedMessage()});
            errorException.initCause(exception.getCause());
            throw errorException;
        }
        if (bl) {
            throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.PARAMETER_BINDING_BUILD_ERR.name(), new String[]{Integer.toString(n), dataWrapper.toString()});
        }
    }

    public static void bindStringToCassValue(SettableByIndexData<?> settableByIndexData, int n, DataType.Name name, String string) throws Exception {
        if (!string.equalsIgnoreCase("null")) {
            switch (name) {
                case ASCII: 
                case VARCHAR: 
                case TEXT: {
                    if (string.startsWith("'") && string.endsWith("'")) {
                        string = string.substring(1, string.length() - 1);
                        string = string.replace("''", "'");
                        settableByIndexData.setString(n, string);
                        break;
                    }
                    throw new Exception("String value must be surrounded with ''.");
                }
                case BIGINT: 
                case COUNTER: {
                    settableByIndexData.setLong(n, new Long(string));
                    break;
                }
                case BLOB: {
                    if (string.substring(0, 2).equalsIgnoreCase("0x")) {
                        if ((string = string.substring(2, string.length())).length() % 2 != 0) {
                            throw new Exception("Hex value cannot have an odd number of digits.");
                        }
                        ConversionResult conversionResult = new ConversionResult();
                        byte[] byArray = HexToBinaryConverter.toBinary(string, Integer.MAX_VALUE, conversionResult);
                        if (conversionResult.getState() != ConversionResult.TypeConversionState.SUCCESS) {
                            throw new Exception("Invalid hex value.");
                        }
                        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                        settableByIndexData.setBytes(n, byteBuffer);
                        break;
                    }
                    throw new Exception("Hex string must begin with 0x.");
                }
                case BOOLEAN: {
                    settableByIndexData.setBool(n, Boolean.parseBoolean(string));
                    break;
                }
                case DECIMAL: {
                    settableByIndexData.setDecimal(n, new BigDecimal(string));
                    break;
                }
                case DOUBLE: {
                    settableByIndexData.setDouble(n, Double.parseDouble(string));
                    break;
                }
                case DATE: {
                    boolean bl = false;
                    if (string.startsWith("'") && string.endsWith("'")) {
                        String[] stringArray;
                        if ((string = string.substring(1, string.length() - 1)).startsWith("-")) {
                            bl = true;
                            string = string.substring(1, string.length());
                        }
                        if (3 == (stringArray = string.split("-")).length) {
                            int n2 = Integer.parseInt(stringArray[0]);
                            int n3 = Integer.parseInt(stringArray[1]);
                            int n4 = Integer.parseInt(stringArray[2]);
                            if (bl) {
                                n2 = -n2;
                            }
                            settableByIndexData.setDate(n, LocalDate.fromYearMonthDay(n2, n3, n4));
                            break;
                        }
                        throw new Exception("Date must contain year, month and day.");
                    }
                    throw new Exception("Date must be surrounded with ''.");
                }
                case FLOAT: {
                    settableByIndexData.setFloat(n, Float.parseFloat(string));
                    break;
                }
                case INET: {
                    if (string.startsWith("'") && string.endsWith("'")) {
                        string = string.substring(1, string.length() - 1);
                        settableByIndexData.setInet(n, CDBJDBCDataTypeUtilities.stringToInet(string));
                        break;
                    }
                    throw new Exception("Inet value must be surrounded with ''.");
                }
                case INT: {
                    settableByIndexData.setInt(n, Integer.parseInt(string));
                    break;
                }
                case SMALLINT: {
                    settableByIndexData.setShort(n, Short.parseShort(string));
                    break;
                }
                case TINYINT: {
                    settableByIndexData.setByte(n, Byte.parseByte(string));
                    break;
                }
                case TIME: {
                    if (string.startsWith("'") && string.endsWith("'")) {
                        SimpleDateFormat simpleDateFormat = (string = string.substring(1, string.length() - 1)).contains(".") ? new SimpleDateFormat("HH:mm:ss.SSS") : new SimpleDateFormat("HH:mm:ss");
                        Date date = simpleDateFormat.parse(string);
                        long l = date.getTime();
                        DateTime dateTime = new DateTime(l);
                        long l2 = TimeUnit.NANOSECONDS.convert(dateTime.getMillisOfDay(), TimeUnit.MILLISECONDS);
                        settableByIndexData.setTime(n, l2);
                        break;
                    }
                    throw new Exception("Time value must be surrounded with ''");
                }
                case TIMESTAMP: {
                    if (string.startsWith("'") && string.endsWith("'")) {
                        if ((string = string.substring(1, string.length() - 1)).isEmpty()) {
                            throw new Exception("Timestamp value cannot be empty.");
                        }
                        SimpleDateFormat simpleDateFormat = string.contains(":") && string.contains(".") ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS") : (string.contains(":") && !string.contains(".") ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd"));
                        Date date = simpleDateFormat.parse(string);
                        settableByIndexData.setTimestamp(n, date);
                        break;
                    }
                    settableByIndexData.setTimestamp(n, new Timestamp(new Long(string)));
                    break;
                }
                case TIMEUUID: 
                case UUID: {
                    UUID uUID = UUID.fromString(string);
                    settableByIndexData.setUUID(n, uUID);
                    break;
                }
                case VARINT: {
                    settableByIndexData.setVarint(n, new BigInteger(string));
                    break;
                }
                default: {
                    settableByIndexData.setBytesUnsafe(n, ByteBuffer.wrap(string.getBytes()));
                    break;
                }
            }
        } else {
            settableByIndexData.setToNull(n);
        }
    }

    public static String byteArrayToCassString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0x");
        stringBuilder.append(DatatypeConverter.printHexBinary((byte[])byArray));
        return stringBuilder.toString();
    }

    public static boolean convertCassSubValueToSqlData(DataWrapper dataWrapper, long l, long l2, short s, DataType.Name name, Object object) throws ErrorException {
        boolean bl = false;
        if (null == object) {
            if (DataType.Name.INET == name) {
                object = "";
                dataWrapper.setVarChar(object.toString());
            } else {
                dataWrapper.setNull(s);
            }
        } else {
            switch (s) {
                case -6: 
                case -5: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 16: 
                case 93: {
                    try {
                        dataWrapper.setData(s, object);
                        break;
                    }
                    catch (IncorrectTypeException incorrectTypeException) {
                        incorrectTypeException.printStackTrace();
                        throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"SQL data type mismatch"});
                    }
                }
                case 91: {
                    String string = object.toString();
                    boolean bl2 = false;
                    if (string.startsWith("-")) {
                        bl2 = true;
                        string = string.substring(1, string.length());
                    }
                    String[] stringArray = null;
                    stringArray = string.split("-");
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[2]);
                    if (bl2) {
                        n = -n;
                    }
                    dataWrapper.setDate(n, n2 - 1, n3);
                    break;
                }
                case 92: {
                    String string = object.toString();
                    long l3 = new Long(string);
                    long l4 = TimeUnit.MILLISECONDS.convert(l3, TimeUnit.NANOSECONDS);
                    LocalTime localTime = LocalTime.fromMillisOfDay(l4);
                    int n = localTime.getHourOfDay();
                    int n4 = localTime.getMinuteOfHour();
                    int n5 = localTime.getSecondOfMinute();
                    int n6 = (int)TimeUnit.NANOSECONDS.convert(localTime.getMillisOfSecond(), TimeUnit.MILLISECONDS);
                    dataWrapper.setTime(n, n4, n5, n6);
                    break;
                }
                case 2: {
                    BigInteger bigInteger = (BigInteger)object;
                    try {
                        dataWrapper.setData(s, new BigDecimal(bigInteger));
                        break;
                    }
                    catch (IncorrectTypeException incorrectTypeException) {
                        incorrectTypeException.printStackTrace();
                        throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"SQL data type mismatch"});
                    }
                }
                case -4: {
                    ByteBuffer byteBuffer = (ByteBuffer)object;
                    int n = byteBuffer.limit();
                    int n7 = byteBuffer.position();
                    if (n7 < n) {
                        byte[] byArray = new byte[n - n7];
                        byteBuffer.get(byArray);
                        try {
                            dataWrapper.setData(s, byArray);
                            break;
                        }
                        catch (IncorrectTypeException incorrectTypeException) {
                            incorrectTypeException.printStackTrace();
                            throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"SQL data type mismatch"});
                        }
                    }
                    dataWrapper.setNull(s);
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    String string = null;
                    if (DataType.Name.INET == name) {
                        string = object.toString().isEmpty() ? "" : ((InetAddress)object).getHostAddress();
                    } else if (DataType.Name.MAP == name) {
                        Map map = (Map)object;
                        string = CDBJDBCDataTypeUtilities.mapToString(map);
                    } else if (DataType.Name.LIST == name) {
                        List list = (List)object;
                        string = CDBJDBCDataTypeUtilities.listToString(list);
                    } else if (DataType.Name.SET == name) {
                        Set set = (Set)object;
                        string = CDBJDBCDataTypeUtilities.setToString(set);
                    } else {
                        string = object.toString();
                    }
                    if (-1L != l2) {
                        l2 /= 2L;
                    }
                    l /= 2L;
                    if (s == 12) {
                        bl = DSITypeUtilities.outputVarCharStringData(string, dataWrapper, l, l2);
                        break;
                    }
                    if (s == 1) {
                        bl = DSITypeUtilities.outputCharStringData(string, dataWrapper, l, l2);
                        break;
                    }
                    bl = DSITypeUtilities.outputLongVarCharStringData(string, dataWrapper, l, l2);
                    break;
                }
                default: {
                    throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"SQL data type not supported"});
                }
            }
        }
        return bl;
    }

    public static boolean convertCassValueToSqlData(int n, DataWrapper dataWrapper, long l, long l2, short s, Row row) throws ErrorException {
        boolean bl = false;
        DataType.Name name = row.getColumnDefinitions().getType(n).getName();
        if (row.isNull(n)) {
            dataWrapper.setNull(s);
        } else {
            switch (s) {
                case -5: {
                    dataWrapper.setBigInt(row.getLong(n));
                    break;
                }
                case 16: {
                    dataWrapper.setBoolean(row.getBool(n));
                    break;
                }
                case 91: {
                    int n2 = row.getDate(n).getYear();
                    int n3 = row.getDate(n).getMonth();
                    int n4 = row.getDate(n).getDay();
                    dataWrapper.setDate(n2, n3 - 1, n4);
                    break;
                }
                case 3: {
                    dataWrapper.setDecimal(row.getDecimal(n));
                    break;
                }
                case 2: {
                    dataWrapper.setNumeric(new BigDecimal(row.getVarint(n)));
                    break;
                }
                case 8: {
                    dataWrapper.setDouble(row.getDouble(n));
                    break;
                }
                case 4: {
                    dataWrapper.setInteger(row.getInt(n));
                    break;
                }
                case -4: {
                    dataWrapper.setLongVarBinary(row.getBytes(n).array());
                    break;
                }
                case 7: {
                    dataWrapper.setReal(row.getFloat(n));
                    break;
                }
                case 5: {
                    dataWrapper.setSmallInt(row.getShort(n));
                    break;
                }
                case 92: {
                    long l3 = TimeUnit.MILLISECONDS.convert(row.getTime(n), TimeUnit.NANOSECONDS);
                    LocalTime localTime = LocalTime.fromMillisOfDay(l3);
                    int n5 = localTime.getHourOfDay();
                    int n6 = localTime.getMinuteOfHour();
                    int n7 = localTime.getSecondOfMinute();
                    int n8 = (int)TimeUnit.NANOSECONDS.convert(localTime.getMillisOfSecond(), TimeUnit.MILLISECONDS);
                    dataWrapper.setTime(n5, n6, n7, n8);
                    break;
                }
                case 93: {
                    dataWrapper.setTimestamp(new Timestamp(row.getTimestamp(n).getTime()));
                    break;
                }
                case -6: {
                    dataWrapper.setTinyInt(row.getByte(n));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    String string = null;
                    if (DataType.Name.ASCII == name || DataType.Name.VARCHAR == name || DataType.Name.TEXT == name) {
                        string = row.getString(n);
                    } else if (DataType.Name.TIMEUUID == name || DataType.Name.UUID == name) {
                        string = row.getUUID(n).toString();
                    } else if (DataType.Name.INET == name) {
                        InetAddress inetAddress = row.getInet(n);
                        string = null == inetAddress ? "" : inetAddress.getHostAddress();
                    } else if (DataType.Name.LIST == name) {
                        string = CDBJDBCDataTypeUtilities.listToString(row, n);
                    } else if (DataType.Name.MAP == name) {
                        string = CDBJDBCDataTypeUtilities.mapToString(row, n);
                    } else if (DataType.Name.SET == name) {
                        string = CDBJDBCDataTypeUtilities.setToString(row, n);
                    } else {
                        Object object = row.getObject(n);
                        string = object.toString();
                    }
                    if (-1L != l2) {
                        l2 /= 2L;
                    }
                    l /= 2L;
                    if (s == 12) {
                        bl = DSITypeUtilities.outputVarCharStringData(string, dataWrapper, l, l2);
                        break;
                    }
                    if (s == 1) {
                        bl = DSITypeUtilities.outputCharStringData(string, dataWrapper, l, l2);
                        break;
                    }
                    bl = DSITypeUtilities.outputLongVarCharStringData(string, dataWrapper, l, l2);
                    break;
                }
                default: {
                    throw CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"SQL data type not supported"});
                }
            }
        }
        return bl;
    }

    public static Object convertSqlDataToCassValue(DataWrapper dataWrapper, int n, DataType dataType) throws ErrorException {
        Object object = null;
        try {
            if (!dataWrapper.isNull()) {
                block1 : switch (n) {
                    case -5: {
                        object = dataWrapper.getBigIntAsLong();
                        break;
                    }
                    case 16: {
                        object = dataWrapper.getBoolean();
                        break;
                    }
                    case 91: {
                        String string = dataWrapper.getDate().toString();
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = 0;
                        if (!string.isEmpty()) {
                            String[] stringArray = string.split("-");
                            n2 = Integer.parseInt(stringArray[0]);
                            n3 = Integer.parseInt(stringArray[1]);
                            n4 = Integer.parseInt(stringArray[2]);
                            LocalDate localDate = LocalDate.fromMillisSinceEpoch(dataWrapper.getDate().getTime());
                            if (localDate.getYear() < 0) {
                                n2 = -n2;
                            }
                        }
                        object = LocalDate.fromYearMonthDay(n2, n3, n4);
                        break;
                    }
                    case 3: {
                        object = dataWrapper.getDecimal();
                        break;
                    }
                    case 2: {
                        object = dataWrapper.getNumeric().toBigInteger();
                        break;
                    }
                    case 8: {
                        object = dataWrapper.getDouble();
                        break;
                    }
                    case 4: {
                        object = dataWrapper.getInteger().intValue();
                        break;
                    }
                    case -4: {
                        object = ByteBuffer.wrap(dataWrapper.getLongVarBinary());
                        break;
                    }
                    case 7: {
                        object = dataWrapper.getReal();
                        break;
                    }
                    case 5: {
                        object = dataWrapper.getSmallInt().shortValue();
                        break;
                    }
                    case 92: {
                        TimeTz timeTz = dataWrapper.getTimeTz();
                        DateTime dateTime = new DateTime(timeTz.getTime());
                        long l = TimeUnit.NANOSECONDS.convert(dateTime.getMillisOfDay(), TimeUnit.MILLISECONDS);
                        object = l;
                        break;
                    }
                    case 93: {
                        TimestampTz timestampTz = dataWrapper.getTimestampTz();
                        object = CDBJDBCDataTypeUtilities.sqlTimestampToDate(timestampTz);
                        break;
                    }
                    case -6: {
                        object = dataWrapper.getTinyInt().byteValue();
                        break;
                    }
                    case 12: {
                        String string = dataWrapper.getVarChar();
                        switch (dataType.getName()) {
                            case ASCII: 
                            case VARCHAR: 
                            case TEXT: {
                                object = string;
                                break block1;
                            }
                            case INET: {
                                if (string.isEmpty()) {
                                    object = "";
                                    break block1;
                                }
                                object = CDBJDBCDataTypeUtilities.stringToInet(string);
                                break block1;
                            }
                            case TIMEUUID: 
                            case UUID: {
                                object = UUID.fromString(string);
                                break block1;
                            }
                            case TUPLE: {
                                TupleType tupleType = (TupleType)dataType;
                                object = CDBJDBCDataTypeUtilities.stringToTuple(string, tupleType);
                                break block1;
                            }
                            case UDT: {
                                UserType userType = (UserType)dataType;
                                object = CDBJDBCDataTypeUtilities.stringToUDT(string, userType);
                                break block1;
                            }
                        }
                        object = ByteBuffer.wrap(string.getBytes());
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.DATA_CONVERSION_ERR.name(), new String[]{exception.getLocalizedMessage()});
            errorException.initCause(exception.getCause());
            throw errorException;
        }
        return object;
    }

    public static ColumnMetadata createColumn(ColumnDefinitions.Definition definition, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) throws ErrorException {
        ColumnMetadata columnMetadata = null;
        DataType.Name name = definition.getType().getName();
        int n = CDBJDBCDataTypeUtilities.toSQLType(name);
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(n);
        if (null != typeMetadata) {
            columnMetadata = new ColumnMetadata(typeMetadata);
            columnMetadata.setCatalogName("cassandra");
            columnMetadata.setSchemaName(definition.getKeyspace());
            columnMetadata.setTableName(definition.getTable());
            columnMetadata.setName(definition.getName());
            columnMetadata.setLabel(definition.getName());
            CDBJDBCDataTypeUtilities.updateMetadata(columnMetadata, cDBJDBCConnectionSettings, false);
        }
        return columnMetadata;
    }

    public static ParameterMetadata createParameterColumn(int n, ColumnDefinitions.Definition definition, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) throws ErrorException {
        ParameterMetadata parameterMetadata = null;
        DataType.Name name = definition.getType().getName();
        int n2 = CDBJDBCDataTypeUtilities.toSQLType(name);
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(n2);
        String string = definition.getName();
        if (null != typeMetadata) {
            if (TypeUtilities.isBinaryType(n2) || TypeUtilities.isCharacterType(n2)) {
                int n3 = cDBJDBCConnectionSettings.m_binaryColumnLength;
                if (TypeUtilities.isCharacterType(n2)) {
                    n3 = cDBJDBCConnectionSettings.m_stringColumnLength;
                    typeMetadata.setIntervalPrecision(n3);
                }
                parameterMetadata = new ParameterMetadata(n, ParameterType.INPUT, typeMetadata, n3, string, true, Nullable.NULLABLE);
            } else {
                parameterMetadata = new ParameterMetadata(n, ParameterType.INPUT, n2, true);
                parameterMetadata.setName(string);
                if (3 == n2) {
                    TypeMetadata typeMetadata2 = parameterMetadata.getTypeMetadata();
                    typeMetadata2.setPrecision(cDBJDBCConnectionSettings.m_decimalColumnPrecision);
                    typeMetadata2.setScale(cDBJDBCConnectionSettings.m_decimalColumnScale);
                } else if (2 == n2) {
                    TypeMetadata typeMetadata3 = parameterMetadata.getTypeMetadata();
                    typeMetadata3.setPrecision(cDBJDBCConnectionSettings.m_varintColumnPrecision);
                }
            }
        }
        return parameterMetadata;
    }

    public static String listToString(Row row, int n) {
        List<DataType> list = row.getColumnDefinitions().getType(n).getTypeArguments();
        TypeCodec typeCodec = new CodecRegistry().codecFor(list.get(0));
        Class clazz = typeCodec.getJavaType().getRawType();
        List list2 = row.getList(n, clazz);
        Iterator iterator = list2.iterator();
        return CDBJDBCDataTypeUtilities.listSetToString(iterator, '[', ']');
    }

    public static String mapToString(Row row, int n) {
        List<DataType> list = row.getColumnDefinitions().getType(n).getTypeArguments();
        TypeCodec typeCodec = new CodecRegistry().codecFor(list.get(0));
        Class clazz = typeCodec.getJavaType().getRawType();
        typeCodec = new CodecRegistry().codecFor(list.get(1));
        Class clazz2 = typeCodec.getJavaType().getRawType();
        Map map = row.getMap(n, clazz, clazz2);
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            Object t2 = map.get(t);
            if (0 == stringBuilder.length()) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            DataType.Name name = list.get(0).getName();
            boolean bl = false;
            switch (name) {
                case ASCII: 
                case VARCHAR: 
                case TEXT: 
                case INET: 
                case TIMESTAMP: {
                    stringBuilder.append("'");
                    bl = true;
                    break;
                }
            }
            CDBJDBCDataTypeUtilities.appendSubValue(stringBuilder, t);
            if (bl) {
                stringBuilder.append("'");
            }
            stringBuilder.append(":");
            CDBJDBCDataTypeUtilities.appendSubValue(stringBuilder, t2);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static String TupleToString(TupleValue tupleValue) {
        TupleType tupleType = tupleValue.getType();
        List<DataType> list = tupleType.getComponentTypes();
        int n = 0;
        Object object = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (DataType dataType : list) {
            if (1 != stringBuilder.length()) {
                stringBuilder.append(", ");
            }
            object = tupleValue.getObject(n);
            CDBJDBCDataTypeUtilities.appendSubValue(stringBuilder, object, dataType);
            ++n;
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String UDTToString(UDTValue uDTValue) {
        UserType userType = uDTValue.getType();
        Iterator<UserType.Field> iterator = userType.iterator();
        UserType.Field field = null;
        String string = null;
        DataType dataType = null;
        Object object = null;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        while (iterator.hasNext()) {
            field = iterator.next();
            string = field.getName();
            dataType = field.getType();
            object = uDTValue.getObject(string);
            if (1 != stringBuilder.length()) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string);
            stringBuilder.append(": ");
            CDBJDBCDataTypeUtilities.appendSubValue(stringBuilder, object, dataType);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static String mapToString(Map<?, ?> map) {
        Set<?> set = map.keySet();
        Iterator<?> iterator = set.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            Object obj2 = map.get(obj);
            if (1 != stringBuilder.length()) {
                stringBuilder.append(", ");
            }
            CDBJDBCDataTypeUtilities.appendSubValue(stringBuilder, obj, null);
            stringBuilder.append(" : ");
            CDBJDBCDataTypeUtilities.appendSubValue(stringBuilder, obj2, null);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static String listToString(List<?> list) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = list.iterator();
        stringBuilder.append("[");
        while (iterator.hasNext()) {
            if (1 != stringBuilder.length()) {
                stringBuilder.append(", ");
            }
            CDBJDBCDataTypeUtilities.appendSubValue(stringBuilder, iterator.next(), null);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String setToString(Set<?> set) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = set.iterator();
        stringBuilder.append("{");
        while (iterator.hasNext()) {
            if (1 != stringBuilder.length()) {
                stringBuilder.append(", ");
            }
            CDBJDBCDataTypeUtilities.appendSubValue(stringBuilder, iterator.next(), null);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static String setToString(Row row, int n) {
        List<DataType> list = row.getColumnDefinitions().getType(n).getTypeArguments();
        TypeCodec typeCodec = new CodecRegistry().codecFor(list.get(0));
        Class clazz = typeCodec.getJavaType().getRawType();
        Set set = row.getSet(n, clazz);
        Iterator iterator = set.iterator();
        return CDBJDBCDataTypeUtilities.listSetToString(iterator, '{', '}');
    }

    public static int toSQLType(DataType.Name name) {
        int n = 12;
        if (s_cqlToSql.containsKey((Object)name)) {
            n = s_cqlToSql.get((Object)name);
        }
        return n;
    }

    public static void updateMetadata(ColumnMetadata columnMetadata, CDBJDBCConnectionSettings cDBJDBCConnectionSettings, boolean bl) throws ErrorException {
        try {
            TypeMetadata typeMetadata = columnMetadata.getTypeMetadata();
            short s = typeMetadata.getType();
            if (TypeUtilities.isNumberType(s)) {
                typeMetadata.setSigned(true);
                if (3 == s) {
                    typeMetadata.setPrecision(cDBJDBCConnectionSettings.m_decimalColumnPrecision);
                    typeMetadata.setScale(cDBJDBCConnectionSettings.m_decimalColumnScale);
                } else if (2 == s) {
                    typeMetadata.setPrecision(cDBJDBCConnectionSettings.m_varintColumnPrecision);
                }
            }
            if (TypeUtilities.isBinaryType(s)) {
                columnMetadata.setColumnLength(cDBJDBCConnectionSettings.m_binaryColumnLength);
            }
            if (TypeUtilities.isCharacterType(s) || TypeUtilities.isIntervalType(s)) {
                int n = cDBJDBCConnectionSettings.m_stringColumnLength;
                typeMetadata.setIntervalPrecision(n);
                if (TypeUtilities.isCharacterType(s)) {
                    columnMetadata.setColumnLength(n);
                }
            }
            if (s == 92) {
                typeMetadata.setPrecision((short)3);
                typeMetadata.setScale((short)12);
            }
            if (bl) {
                columnMetadata.setNullable(Nullable.NO_NULLS);
            } else {
                columnMetadata.setNullable(Nullable.NULLABLE);
            }
        }
        catch (Exception exception) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.METADATA_INITIALIZATION_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendSubValue(StringBuilder stringBuilder, Object object) {
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
            byteBuffer.get(byArray);
            stringBuilder.append(CDBJDBCDataTypeUtilities.byteArrayToCassString(byArray));
        } else if (object instanceof InetAddress) {
            stringBuilder.append(((InetAddress)object).getHostAddress());
        } else if (object instanceof Date) {
            Object object2 = object;
            synchronized (object2) {
                stringBuilder.append(DATE_FORMAT.format((Date)object));
            }
        } else {
            stringBuilder.append(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendSubValue(StringBuilder stringBuilder, Object object, DataType dataType) {
        if (null != dataType && DataType.Name.TIME == dataType.getName()) {
            long l = (Long)object;
            long l2 = TimeUnit.MILLISECONDS.convert(l, TimeUnit.NANOSECONDS);
            LocalTime localTime = LocalTime.fromMillisOfDay(l2);
            int n = localTime.getHourOfDay();
            int n2 = localTime.getMinuteOfHour();
            int n3 = localTime.getSecondOfMinute();
            int n4 = (int)TimeUnit.NANOSECONDS.convert(localTime.getMillisOfSecond(), TimeUnit.MILLISECONDS);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1970, 0, 1, n, n2, n3);
            calendar.set(14, n4 / 1000000);
            stringBuilder.append(new Time(calendar.getTimeInMillis()));
            return;
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] byArray = new byte[byteBuffer.limit() - byteBuffer.position()];
            byteBuffer.get(byArray);
            stringBuilder.append(CDBJDBCDataTypeUtilities.byteArrayToCassString(byArray));
        } else if (object instanceof InetAddress) {
            stringBuilder.append(((InetAddress)object).getHostAddress());
        } else if (object instanceof Date) {
            Object object2 = object;
            synchronized (object2) {
                stringBuilder.append(DATE_FORMAT.format((Date)object));
            }
        } else if (object instanceof String) {
            stringBuilder.append("'");
            stringBuilder.append(object);
            stringBuilder.append("'");
        } else {
            stringBuilder.append(object);
        }
    }

    private static Map<DataType.Name, Integer> initializeTypeMapping() {
        HashMap<DataType.Name, Integer> hashMap = new HashMap<DataType.Name, Integer>(22);
        hashMap.put(DataType.Name.ASCII, 12);
        hashMap.put(DataType.Name.BIGINT, -5);
        hashMap.put(DataType.Name.BLOB, -4);
        hashMap.put(DataType.Name.BOOLEAN, 16);
        hashMap.put(DataType.Name.COUNTER, -5);
        hashMap.put(DataType.Name.DECIMAL, 3);
        hashMap.put(DataType.Name.DOUBLE, 8);
        hashMap.put(DataType.Name.DATE, 91);
        hashMap.put(DataType.Name.FLOAT, 7);
        hashMap.put(DataType.Name.INET, 12);
        hashMap.put(DataType.Name.INT, 4);
        hashMap.put(DataType.Name.SMALLINT, 5);
        hashMap.put(DataType.Name.TINYINT, -6);
        hashMap.put(DataType.Name.TEXT, 12);
        hashMap.put(DataType.Name.TIME, 92);
        hashMap.put(DataType.Name.TIMESTAMP, 93);
        hashMap.put(DataType.Name.UUID, 12);
        hashMap.put(DataType.Name.VARCHAR, 12);
        hashMap.put(DataType.Name.VARINT, 2);
        hashMap.put(DataType.Name.TIMEUUID, 12);
        hashMap.put(DataType.Name.LIST, 12);
        hashMap.put(DataType.Name.SET, 12);
        hashMap.put(DataType.Name.MAP, 12);
        hashMap.put(DataType.Name.UDT, 12);
        hashMap.put(DataType.Name.TUPLE, 12);
        hashMap.put(DataType.Name.CUSTOM, 12);
        return hashMap;
    }

    private static String listSetToString(Iterator<?> iterator, char c, char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            if (0 == stringBuilder.length()) {
                stringBuilder.append(c);
            } else {
                stringBuilder.append(",");
            }
            CDBJDBCDataTypeUtilities.appendSubValue(stringBuilder, iterator.next());
        }
        stringBuilder.append(c2);
        return stringBuilder.toString();
    }

    private static Date sqlTimestampToDate(TimestampTz timestampTz) {
        Calendar calendar = timestampTz.getTimezoneCalendar();
        calendar.setTimeInMillis(timestampTz.getAdjustedTimestamp().getTime());
        return calendar.getTime();
    }

    private static InetAddress stringToInet(String string) throws UnknownHostException {
        return InetAddress.getByName(string);
    }

    private static TupleValue stringToTuple(String string, TupleType tupleType) throws Exception {
        if ((string = string.trim()).equalsIgnoreCase("null")) {
            return null;
        }
        if (string.startsWith("(") && string.endsWith(")")) {
            string = string.substring(1, string.length() - 1);
            string = string.trim();
            String[] stringArray = string.split(",(?=(?:[^']*'[^']*')*[^']*$)");
            TupleValue tupleValue = tupleType.newValue();
            List<DataType> list = tupleType.getComponentTypes();
            int n = 0;
            for (DataType dataType : list) {
                DataType.Name name = dataType.getName();
                if (n >= stringArray.length) break;
                String string2 = stringArray[n].trim();
                try {
                    CDBJDBCDataTypeUtilities.bindStringToCassValue(tupleValue, n, name, string2);
                }
                catch (Exception exception) {
                    throw new Exception("Failed to bind value at index " + n + " in tuple " + tupleType.toString() + ". Cause: " + exception.getMessage());
                }
                ++n;
            }
            return tupleValue;
        }
        throw new Exception("Tuple must be surrounded in ( )");
    }

    private static UDTValue stringToUDT(String string, UserType userType) throws Exception {
        if ((string = string.trim()).equalsIgnoreCase("null")) {
            return null;
        }
        if (string.startsWith("{") && string.endsWith("}")) {
            Object object;
            Object object2;
            String[] stringArray;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            string = string.substring(1, string.length() - 1);
            string = string.trim();
            for (String string2 : stringArray = string.split(",(?=(?:[^']*'[^']*')*[^']*$)")) {
                int n;
                String string3 = string2.trim();
                object2 = string3.split(":", n = 2);
                if (((String[])object2).length != 2) {
                    throw new Exception("UDT must contain both field name and value");
                }
                object = object2[0].trim();
                String string4 = object2[1].trim();
                hashMap.put((String)object, string4);
            }
            UDTValue uDTValue = userType.newValue();
            Collection<String> collection = userType.getFieldNames();
            for (Map.Entry entry : hashMap.entrySet()) {
                String string5 = (String)entry.getKey();
                if (userType.contains(string5)) {
                    object2 = (String)entry.getValue();
                    object = userType.getFieldType(string5).getName();
                    int n = 0;
                    for (String string6 : collection) {
                        if (string5.equalsIgnoreCase(string6)) break;
                        ++n;
                    }
                    try {
                        CDBJDBCDataTypeUtilities.bindStringToCassValue(uDTValue, n, (DataType.Name)((Object)object), (String)object2);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new Exception("Failed to bind \"" + string5 + "\" in user defined type " + userType.toString() + ". Cause: " + exception.getMessage());
                    }
                }
                throw new Exception("\"" + string5 + "\" is not present in user defined type " + userType.toString());
            }
            return uDTValue;
        }
        throw new Exception("UDT must be surrounded with { }");
    }
}

