/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.dsi.core.utilities;

import com.simba.cassandra.dsi.core.utilities.Variant;
import com.simba.cassandra.dsi.exceptions.IncorrectTypeException;
import com.simba.cassandra.dsi.exceptions.NumericOverflowException;
import java.math.BigInteger;

public class Variants {
    private Variants() {
    }

    public static Variant makeInt16(short s) {
        return Variants.makeVariant(5, s);
    }

    public static Variant makeInt32(int n) {
        return Variants.makeVariant(6, n);
    }

    public static Variant makeInt64(long l) {
        return Variants.makeVariant(7, l);
    }

    public static Variant makeUInt16(char c) {
        return Variants.makeVariant(2, Character.valueOf(c));
    }

    public static Variant makeUInt32(long l) throws NumericOverflowException {
        return Variants.makeVariantCheckOverflow(3, l);
    }

    public static Variant makeUInt64(long l) throws NumericOverflowException {
        return Variants.makeVariantCheckOverflow(4, l);
    }

    public static Variant makeUInt64(BigInteger bigInteger) throws NumericOverflowException {
        return Variants.makeVariantCheckOverflow(4, bigInteger);
    }

    public static Variant makeNull() {
        return Variants.makeVariant(8, null);
    }

    public static Variant makeWString(String string) {
        return Variants.makeVariant(0, string);
    }

    private static Variant makeVariantCheckOverflow(int n, Object object) throws NumericOverflowException {
        try {
            return new Variant(n, object);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new AssertionError((Object)incorrectTypeException);
        }
    }

    private static Variant makeVariant(int n, Object object) {
        try {
            return new Variant(n, object);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw new AssertionError((Object)incorrectTypeException);
        }
        catch (NumericOverflowException numericOverflowException) {
            throw new AssertionError((Object)numericOverflowException);
        }
    }
}

