/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.codahale.metrics;

import com.simba.cassandra.shaded.codahale.metrics.LongAdder;
import com.simba.cassandra.shaded.codahale.metrics.LongAdderAdapter;

class LongAdderProxy {
    private static final Provider INSTANCE = LongAdderProxy.getLongAdderProvider();

    LongAdderProxy() {
    }

    private static Provider getLongAdderProvider() {
        try {
            JdkProvider jdkProvider = new JdkProvider();
            jdkProvider.get();
            return jdkProvider;
        }
        catch (NoClassDefFoundError e) {
            return new InternalLongAdderProvider();
        }
    }

    public static LongAdderAdapter create() {
        return INSTANCE.get();
    }

    private static class InternalLongAdderProvider
    implements Provider {
        private InternalLongAdderProvider() {
        }

        @Override
        public LongAdderAdapter get() {
            return new LongAdderAdapter(){
                private final LongAdder longAdder = new LongAdder();

                @Override
                public void add(long x) {
                    this.longAdder.add(x);
                }

                @Override
                public long sum() {
                    return this.longAdder.sum();
                }

                @Override
                public void increment() {
                    this.longAdder.increment();
                }

                @Override
                public void decrement() {
                    this.longAdder.decrement();
                }

                @Override
                public long sumThenReset() {
                    return this.longAdder.sumThenReset();
                }
            };
        }
    }

    private static class JdkProvider
    implements Provider {
        private JdkProvider() {
        }

        @Override
        public LongAdderAdapter get() {
            return new LongAdderAdapter(){
                private final java.util.concurrent.atomic.LongAdder longAdder = new java.util.concurrent.atomic.LongAdder();

                @Override
                public void add(long x) {
                    this.longAdder.add(x);
                }

                @Override
                public long sum() {
                    return this.longAdder.sum();
                }

                @Override
                public void increment() {
                    this.longAdder.increment();
                }

                @Override
                public void decrement() {
                    this.longAdder.decrement();
                }

                @Override
                public long sumThenReset() {
                    return this.longAdder.sumThenReset();
                }
            };
        }
    }

    private static interface Provider {
        public LongAdderAdapter get();
    }
}

