/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.AuthProvider;
import com.simba.cassandra.shaded.datastax.driver.core.Authenticator;
import com.simba.cassandra.shaded.datastax.driver.core.EndPoint;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.AuthenticationException;
import java.net.InetSocketAddress;

public interface ExtendedAuthProvider
extends AuthProvider {
    public Authenticator newAuthenticator(EndPoint var1, String var2) throws AuthenticationException;

    @Override
    @Deprecated
    public Authenticator newAuthenticator(InetSocketAddress var1, String var2) throws AuthenticationException;

    public static class NoAuthProvider
    implements ExtendedAuthProvider {
        private static final String DSE_AUTHENTICATOR = "com.simba.cassandra.shaded.datastax.bdp.cassandra.auth.DseAuthenticator";
        static final String NO_AUTHENTICATOR_MESSAGE = "Host %s requires authentication, but no authenticator found in Cluster configuration";

        @Override
        public Authenticator newAuthenticator(EndPoint endPoint, String authenticator) {
            if (authenticator.equals(DSE_AUTHENTICATOR)) {
                return new AuthProvider.TransitionalModePlainTextAuthenticator();
            }
            throw new AuthenticationException(endPoint, String.format(NO_AUTHENTICATOR_MESSAGE, endPoint));
        }

        @Override
        public Authenticator newAuthenticator(InetSocketAddress host, String authenticator) throws AuthenticationException {
            throw new AssertionError((Object)("The driver should never call this method on an object that implements " + this.getClass().getSimpleName()));
        }
    }
}

