/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.Cluster;
import com.simba.cassandra.shaded.datastax.driver.core.CodecRegistry;
import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.DataTypeClassNameParser;
import com.simba.cassandra.shaded.datastax.driver.core.DataTypeCqlNameParser;
import com.simba.cassandra.shaded.datastax.driver.core.KeyspaceMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.Metadata;
import com.simba.cassandra.shaded.datastax.driver.core.ProtocolVersion;
import com.simba.cassandra.shaded.datastax.driver.core.Row;
import com.simba.cassandra.shaded.datastax.driver.core.TableMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.VersionNumber;
import com.simba.cassandra.shaded.datastax.driver.core.utils.MoreObjects;
import com.simba.cassandra.shaded.google.common.collect.ImmutableMap;
import com.simba.cassandra.shaded.slf4j.Logger;
import com.simba.cassandra.shaded.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FunctionMetadata {
    private static final Logger logger = LoggerFactory.getLogger(FunctionMetadata.class);
    private final KeyspaceMetadata keyspace;
    private final String simpleName;
    private final Map<String, DataType> arguments;
    private final String body;
    private final boolean calledOnNullInput;
    private final String language;
    private final DataType returnType;

    private FunctionMetadata(KeyspaceMetadata keyspace, String simpleName, Map<String, DataType> arguments, String body, boolean calledOnNullInput, String language, DataType returnType) {
        this.keyspace = keyspace;
        this.simpleName = simpleName;
        this.arguments = arguments;
        this.body = body;
        this.calledOnNullInput = calledOnNullInput;
        this.language = language;
        this.returnType = returnType;
    }

    static FunctionMetadata build(KeyspaceMetadata ksm, Row row, VersionNumber version, Cluster cluster) {
        CodecRegistry codecRegistry = cluster.getConfiguration().getCodecRegistry();
        ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        String simpleName = row.getString("function_name");
        List<String> argumentNames = row.getList("argument_names", String.class);
        List<String> argumentTypes = row.getList("argument_types", String.class);
        Map<String, DataType> arguments = FunctionMetadata.buildArguments(ksm, argumentNames, argumentTypes, version, cluster);
        if (argumentNames.size() != argumentTypes.size()) {
            String fullName = Metadata.fullFunctionName(simpleName, arguments.values());
            logger.error(String.format("Error parsing definition of function %1$s.%2$s: the number of argument names and types don't match.Cluster.getMetadata().getKeyspace(\"%1$s\").getFunction(\"%2$s\") will be missing.", ksm.getName(), fullName));
            return null;
        }
        String body = row.getString("body");
        boolean calledOnNullInput = row.getBool("called_on_null_input");
        String language = row.getString("language");
        DataType returnType = (double)version.getMajor() >= 3.0 ? DataTypeCqlNameParser.parse(row.getString("return_type"), cluster, ksm.getName(), ksm.userTypes, null, false, false) : DataTypeClassNameParser.parseOne(row.getString("return_type"), protocolVersion, codecRegistry);
        return new FunctionMetadata(ksm, simpleName, arguments, body, calledOnNullInput, language, returnType);
    }

    private static Map<String, DataType> buildArguments(KeyspaceMetadata ksm, List<String> names, List<String> types, VersionNumber version, Cluster cluster) {
        if (names.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder<String, DataType> builder = ImmutableMap.builder();
        CodecRegistry codecRegistry = cluster.getConfiguration().getCodecRegistry();
        ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        Iterator<String> iterTypes = types.iterator();
        for (String name : names) {
            DataType type = version.getMajor() >= 3 ? DataTypeCqlNameParser.parse(iterTypes.next(), cluster, ksm.getName(), ksm.userTypes, null, false, false) : DataTypeClassNameParser.parseOne(iterTypes.next(), protocolVersion, codecRegistry);
            builder.put(name, type);
        }
        return builder.build();
    }

    public String exportAsString() {
        return this.asCQLQuery(true);
    }

    public String asCQLQuery() {
        return this.asCQLQuery(false);
    }

    public String toString() {
        return this.asCQLQuery(false);
    }

    private String asCQLQuery(boolean formatted) {
        StringBuilder sb = new StringBuilder("CREATE FUNCTION ");
        sb.append(Metadata.quoteIfNecessary(this.keyspace.getName())).append('.').append(Metadata.quoteIfNecessary(this.simpleName)).append('(');
        boolean first = true;
        for (Map.Entry<String, DataType> entry : this.arguments.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            String name = entry.getKey();
            DataType type = entry.getValue();
            sb.append(Metadata.quoteIfNecessary(name)).append(' ').append(type.asFunctionParameterString());
        }
        sb.append(')');
        TableMetadata.spaceOrNewLine(sb, formatted).append(this.calledOnNullInput ? "CALLED ON NULL INPUT" : "RETURNS NULL ON NULL INPUT");
        TableMetadata.spaceOrNewLine(sb, formatted).append("RETURNS ").append(this.returnType.asFunctionParameterString());
        TableMetadata.spaceOrNewLine(sb, formatted).append("LANGUAGE ").append(this.language);
        TableMetadata.spaceOrNewLine(sb, formatted).append("AS '").append(this.body).append("';");
        return sb.toString();
    }

    public KeyspaceMetadata getKeyspace() {
        return this.keyspace;
    }

    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(Metadata.quoteIfNecessary(this.simpleName)).append('(');
        boolean first = true;
        for (DataType type : this.arguments.values()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(type.asFunctionParameterString());
        }
        sb.append(')');
        return sb.toString();
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public Map<String, DataType> getArguments() {
        return this.arguments;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isCalledOnNullInput() {
        return this.calledOnNullInput;
    }

    public String getLanguage() {
        return this.language;
    }

    public DataType getReturnType() {
        return this.returnType;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof FunctionMetadata) {
            FunctionMetadata that = (FunctionMetadata)other;
            return this.keyspace.getName().equals(that.keyspace.getName()) && this.arguments.equals(that.arguments) && this.body.equals(that.body) && this.calledOnNullInput == that.calledOnNullInput && this.language.equals(that.language) && this.returnType.equals(that.returnType);
        }
        return false;
    }

    public int hashCode() {
        return MoreObjects.hashCode(this.keyspace.getName(), this.arguments, this.body, this.calledOnNullInput, this.language, this.returnType);
    }
}

