/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.NettyUtil;
import com.simba.cassandra.shaded.io.netty.bootstrap.Bootstrap;
import com.simba.cassandra.shaded.io.netty.buffer.PooledByteBufAllocator;
import com.simba.cassandra.shaded.io.netty.channel.ChannelOption;
import com.simba.cassandra.shaded.io.netty.channel.EventLoopGroup;
import com.simba.cassandra.shaded.io.netty.channel.socket.SocketChannel;
import com.simba.cassandra.shaded.io.netty.util.HashedWheelTimer;
import com.simba.cassandra.shaded.io.netty.util.Timer;
import java.util.concurrent.ThreadFactory;

public class NettyOptions {
    public static final NettyOptions DEFAULT_INSTANCE = new NettyOptions();

    public EventLoopGroup eventLoopGroup(ThreadFactory threadFactory) {
        return NettyUtil.newEventLoopGroupInstance(threadFactory);
    }

    public Class<? extends SocketChannel> channelClass() {
        return NettyUtil.channelClass();
    }

    public void afterBootstrapInitialized(Bootstrap bootstrap) {
        bootstrap.option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
    }

    public void afterChannelInitialized(SocketChannel channel) throws Exception {
    }

    public void onClusterClose(EventLoopGroup eventLoopGroup) {
        eventLoopGroup.shutdownGracefully().syncUninterruptibly();
    }

    public Timer timer(ThreadFactory threadFactory) {
        return new HashedWheelTimer(threadFactory);
    }

    public void onClusterClose(Timer timer) {
        timer.stop();
    }
}

