/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public abstract class ParseUtils {
    private static final String[] iso8601Patterns = new String[]{"yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mmZ", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd", "yyyy-MM-ddZ"};

    public static int skipSpaces(String toParse, int idx) {
        while (ParseUtils.isBlank(toParse.charAt(idx)) && idx < toParse.length()) {
            ++idx;
        }
        return idx;
    }

    public static int skipCQLValue(String toParse, int idx) {
        if (idx >= toParse.length()) {
            throw new IllegalArgumentException();
        }
        if (ParseUtils.isBlank(toParse.charAt(idx))) {
            throw new IllegalArgumentException();
        }
        int cbrackets = 0;
        int sbrackets = 0;
        int parens = 0;
        boolean inString = false;
        do {
            char c = toParse.charAt(idx);
            if (inString) {
                if (c != '\'') continue;
                if (idx + 1 < toParse.length() && toParse.charAt(idx + 1) == '\'') {
                    ++idx;
                    continue;
                }
                inString = false;
                if (cbrackets != 0 || sbrackets != 0 || parens != 0) continue;
                return idx + 1;
            }
            if (c == '\'') {
                inString = true;
                continue;
            }
            if (c == '{') {
                ++cbrackets;
                continue;
            }
            if (c == '[') {
                ++sbrackets;
                continue;
            }
            if (c == '(') {
                ++parens;
                continue;
            }
            if (c == '}') {
                if (cbrackets == 0) {
                    return idx;
                }
                if (--cbrackets != 0 || sbrackets != 0 || parens != 0) continue;
                return idx + 1;
            }
            if (c == ']') {
                if (sbrackets == 0) {
                    return idx;
                }
                if (cbrackets != 0 || --sbrackets != 0 || parens != 0) continue;
                return idx + 1;
            }
            if (c == ')') {
                if (parens == 0) {
                    return idx;
                }
                if (cbrackets != 0 || sbrackets != 0 || --parens != 0) continue;
                return idx + 1;
            }
            if (!ParseUtils.isBlank(c) && ParseUtils.isIdentifierChar(c) || cbrackets != 0 || sbrackets != 0 || parens != 0) continue;
            return idx;
        } while (++idx < toParse.length());
        if (inString || cbrackets != 0 || sbrackets != 0 || parens != 0) {
            throw new IllegalArgumentException();
        }
        return idx;
    }

    public static int skipCQLId(String toParse, int idx) {
        if (idx >= toParse.length()) {
            throw new IllegalArgumentException();
        }
        char c = toParse.charAt(idx);
        if (ParseUtils.isIdentifierChar(c)) {
            while (idx < toParse.length() && ParseUtils.isIdentifierChar(toParse.charAt(idx))) {
                ++idx;
            }
            return idx;
        }
        if (c != '\"') {
            throw new IllegalArgumentException();
        }
        while (++idx < toParse.length()) {
            c = toParse.charAt(idx);
            if (c != '\"') continue;
            if (idx + 1 < toParse.length() && toParse.charAt(idx + 1) == '\"') {
                ++idx;
                continue;
            }
            return idx + 1;
        }
        throw new IllegalArgumentException();
    }

    public static boolean isIdentifierChar(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 45 || c == 43 || c == 46 || c == 95 || c == 38;
    }

    public static boolean isBlank(int c) {
        return c == 32 || c == 9 || c == 10;
    }

    public static boolean isLongLiteral(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if ((c >= '0' || i == 0 && c == '-') && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isQuoted(String value) {
        return ParseUtils.isQuoted(value, '\'');
    }

    public static String quote(String value) {
        return ParseUtils.quote(value, '\'');
    }

    public static String unquote(String value) {
        return ParseUtils.unquote(value, '\'');
    }

    public static boolean isDoubleQuoted(String value) {
        return ParseUtils.isQuoted(value, '\"');
    }

    public static String doubleQuote(String value) {
        return ParseUtils.quote(value, '\"');
    }

    public static String unDoubleQuote(String value) {
        return ParseUtils.unquote(value, '\"');
    }

    public static Date parseDate(String str) throws ParseException {
        SimpleDateFormat parser = new SimpleDateFormat();
        parser.setLenient(false);
        parser.setTimeZone(TimeZone.getTimeZone("UTC"));
        str = str.replaceAll("(\\+|\\-)(\\d\\d):(\\d\\d)$", "$1$2$3");
        str = str.replaceAll("Z$", "+0000");
        ParsePosition pos = new ParsePosition(0);
        for (String parsePattern : iso8601Patterns) {
            parser.applyPattern(parsePattern);
            pos.setIndex(0);
            Date date = parser.parse(str, pos);
            if (date == null || pos.getIndex() != str.length()) continue;
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static Date parseDate(String str, String pattern) throws ParseException {
        SimpleDateFormat parser = new SimpleDateFormat();
        parser.setLenient(false);
        parser.setTimeZone(TimeZone.getTimeZone("UTC"));
        str = str.replaceAll("(\\+|\\-)(\\d\\d):(\\d\\d)$", "$1$2$3");
        str = str.replaceAll("Z$", "+0000");
        ParsePosition pos = new ParsePosition(0);
        parser.applyPattern(pattern);
        pos.setIndex(0);
        Date date = parser.parse(str, pos);
        if (date != null && pos.getIndex() == str.length()) {
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static long parseTime(String str) throws ParseException {
        long second;
        long minute;
        long hour;
        long a_nanos = 0L;
        String formatError = "Timestamp format must be hh:mm:ss[.fffffffff]";
        String zeros = "000000000";
        if (str == null) {
            throw new IllegalArgumentException(formatError);
        }
        str = str.trim();
        int firstColon = str.indexOf(58);
        int secondColon = str.indexOf(58, firstColon + 1);
        if (firstColon > 0 && secondColon > 0 && secondColon < str.length() - 1) {
            int period = str.indexOf(46, secondColon + 1);
            hour = Integer.parseInt(str.substring(0, firstColon));
            if (hour < 0L || hour >= 24L) {
                throw new IllegalArgumentException("Hour out of bounds.");
            }
            minute = Integer.parseInt(str.substring(firstColon + 1, secondColon));
            if (minute < 0L || minute >= 60L) {
                throw new IllegalArgumentException("Minute out of bounds.");
            }
            if (period > 0 && period < str.length() - 1) {
                second = Integer.parseInt(str.substring(secondColon + 1, period));
                if (second < 0L || second >= 60L) {
                    throw new IllegalArgumentException("Second out of bounds.");
                }
                String nanos_s = str.substring(period + 1);
                if (nanos_s.length() > 9) {
                    throw new IllegalArgumentException(formatError);
                }
                if (!Character.isDigit(nanos_s.charAt(0))) {
                    throw new IllegalArgumentException(formatError);
                }
                nanos_s = nanos_s + zeros.substring(0, 9 - nanos_s.length());
                a_nanos = Integer.parseInt(nanos_s);
            } else {
                if (period > 0) {
                    throw new ParseException(formatError, -1);
                }
                second = Integer.parseInt(str.substring(secondColon + 1));
                if (second < 0L || second >= 60L) {
                    throw new ParseException("Second out of bounds.", -1);
                }
            }
        } else {
            throw new ParseException(formatError, -1);
        }
        long rawTime = 0L;
        rawTime += TimeUnit.HOURS.toNanos(hour);
        rawTime += TimeUnit.MINUTES.toNanos(minute);
        rawTime += TimeUnit.SECONDS.toNanos(second);
        return rawTime += a_nanos;
    }

    public static String formatTime(long value) {
        int nano = (int)(value % 1000000000L);
        value -= (long)nano;
        int seconds = (int)((value /= 1000000000L) % 60L);
        value -= (long)seconds;
        int minutes = (int)((value /= 60L) % 60L);
        value -= (long)minutes;
        int hours = (int)((value /= 60L) % 24L);
        value -= (long)hours;
        assert ((value /= 24L) == 0L);
        StringBuilder sb = new StringBuilder();
        ParseUtils.leftPadZeros(hours, 2, sb);
        sb.append(":");
        ParseUtils.leftPadZeros(minutes, 2, sb);
        sb.append(":");
        ParseUtils.leftPadZeros(seconds, 2, sb);
        sb.append(".");
        ParseUtils.leftPadZeros(nano, 9, sb);
        return sb.toString();
    }

    private static boolean isQuoted(String value, char quoteChar) {
        return value != null && value.length() > 1 && value.charAt(0) == quoteChar && value.charAt(value.length() - 1) == quoteChar;
    }

    private static String emptyQuoted(char quoteChar) {
        assert (quoteChar == '\"' || quoteChar == '\'');
        if (quoteChar == '\"') {
            return "\"\"";
        }
        return "''";
    }

    private static String quote(String text, char quoteChar) {
        if (text == null || text.isEmpty()) {
            return ParseUtils.emptyQuoted(quoteChar);
        }
        int nbMatch = 0;
        int start = -1;
        do {
            if ((start = text.indexOf(quoteChar, start + 1)) == -1) continue;
            ++nbMatch;
        } while (start != -1);
        if (nbMatch == 0) {
            return quoteChar + text + quoteChar;
        }
        int newLength = 2 + text.length() + nbMatch;
        char[] result = new char[newLength];
        result[0] = quoteChar;
        result[newLength - 1] = quoteChar;
        int newIdx = 1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == quoteChar) {
                result[newIdx++] = c;
                result[newIdx++] = c;
                continue;
            }
            result[newIdx++] = c;
        }
        return new String(result);
    }

    private static String unquote(String text, char quoteChar) {
        if (!ParseUtils.isQuoted(text, quoteChar)) {
            return text;
        }
        if (text.length() == 2) {
            return "";
        }
        String search = ParseUtils.emptyQuoted(quoteChar);
        int nbMatch = 0;
        int start = -1;
        do {
            if ((start = text.indexOf(search, start + 2)) == -1 || start == text.length() - 2) continue;
            ++nbMatch;
        } while (start != -1);
        if (nbMatch == 0) {
            return text.substring(1, text.length() - 1);
        }
        int newLength = text.length() - nbMatch - 2;
        char[] result = new char[newLength];
        int newIdx = 0;
        boolean firstFound = false;
        for (int i = 1; i < text.length() - 1; ++i) {
            char c = text.charAt(i);
            if (c == quoteChar) {
                if (firstFound) {
                    firstFound = false;
                    continue;
                }
                firstFound = true;
                result[newIdx++] = c;
                continue;
            }
            result[newIdx++] = c;
            firstFound = false;
        }
        return new String(result);
    }

    private static void leftPadZeros(int value, int digits, StringBuilder sb) {
        sb.append(String.format("%0" + digits + "d", value));
    }

    private ParseUtils() {
    }
}

