/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.Frame;
import com.simba.cassandra.shaded.datastax.driver.core.FrameCompressor;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.DriverInternalError;
import com.simba.cassandra.shaded.io.netty.buffer.ByteBuf;
import com.simba.cassandra.shaded.slf4j.Logger;
import com.simba.cassandra.shaded.slf4j.LoggerFactory;
import com.simba.cassandra.shaded.xerial.snappy.Snappy;
import java.io.IOException;
import java.nio.ByteBuffer;

class SnappyCompressor
extends FrameCompressor {
    private static final Logger logger;
    static final SnappyCompressor instance;

    private SnappyCompressor() {
        Snappy.getNativeLibraryVersion();
    }

    @Override
    Frame compress(Frame frame) throws IOException {
        ByteBuf input = frame.body;
        ByteBuf frameBody = input.isDirect() ? this.compressDirect(input) : this.compressHeap(input);
        return frame.with(frameBody);
    }

    private ByteBuf compressDirect(ByteBuf input) throws IOException {
        int maxCompressedLength = Snappy.maxCompressedLength(input.readableBytes());
        ByteBuf output = input.alloc().directBuffer(maxCompressedLength);
        try {
            ByteBuffer in = SnappyCompressor.inputNioBuffer(input);
            input.readerIndex(input.writerIndex());
            ByteBuffer out = SnappyCompressor.outputNioBuffer(output);
            int written = Snappy.compress(in, out);
            output.writerIndex(output.writerIndex() + written);
        }
        catch (IOException e) {
            output.release();
            throw e;
        }
        return output;
    }

    private ByteBuf compressHeap(ByteBuf input) throws IOException {
        int maxCompressedLength = Snappy.maxCompressedLength(input.readableBytes());
        int inOffset = input.arrayOffset() + input.readerIndex();
        byte[] in = input.array();
        int len = input.readableBytes();
        input.readerIndex(input.writerIndex());
        ByteBuf output = input.alloc().heapBuffer(maxCompressedLength);
        try {
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int written = Snappy.compress(in, inOffset, len, out, offset);
            output.writerIndex(output.writerIndex() + written);
        }
        catch (IOException e) {
            output.release();
            throw e;
        }
        return output;
    }

    @Override
    Frame decompress(Frame frame) throws IOException {
        ByteBuf input = frame.body;
        ByteBuf frameBody = input.isDirect() ? this.decompressDirect(input) : this.decompressHeap(input);
        return frame.with(frameBody);
    }

    private ByteBuf decompressDirect(ByteBuf input) throws IOException {
        ByteBuffer in = SnappyCompressor.inputNioBuffer(input);
        input.readerIndex(input.writerIndex());
        if (!Snappy.isValidCompressedBuffer(in)) {
            throw new DriverInternalError("Provided frame does not appear to be Snappy compressed");
        }
        ByteBuf output = input.alloc().directBuffer(Snappy.uncompressedLength(in));
        try {
            ByteBuffer out = SnappyCompressor.outputNioBuffer(output);
            int size = Snappy.uncompress(in, out);
            output.writerIndex(output.writerIndex() + size);
        }
        catch (IOException e) {
            output.release();
            throw e;
        }
        return output;
    }

    private ByteBuf decompressHeap(ByteBuf input) throws IOException {
        int inOffset = input.arrayOffset() + input.readerIndex();
        byte[] in = input.array();
        int len = input.readableBytes();
        input.readerIndex(input.writerIndex());
        if (!Snappy.isValidCompressedBuffer(in, inOffset, len)) {
            throw new DriverInternalError("Provided frame does not appear to be Snappy compressed");
        }
        ByteBuf output = input.alloc().heapBuffer(Snappy.uncompressedLength(in, inOffset, len));
        try {
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int written = Snappy.uncompress(in, inOffset, len, out, offset);
            output.writerIndex(output.writerIndex() + written);
        }
        catch (IOException e) {
            output.release();
            throw e;
        }
        return output;
    }

    static {
        SnappyCompressor i;
        logger = LoggerFactory.getLogger(SnappyCompressor.class);
        try {
            i = new SnappyCompressor();
        }
        catch (NoClassDefFoundError e) {
            i = null;
            logger.warn("Cannot find Snappy class, you should make sure the Snappy library is in the classpath if you intend to use it. Snappy compression will not be available for the protocol.");
        }
        catch (Throwable e) {
            i = null;
            logger.warn("Error loading Snappy library ({}). Snappy compression will not be available for the protocol.", (Object)e.toString());
        }
        instance = i;
    }
}

