/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core.policies;

import com.simba.cassandra.shaded.datastax.driver.core.Host;
import com.simba.cassandra.shaded.datastax.driver.core.policies.HostFilterPolicy;
import com.simba.cassandra.shaded.datastax.driver.core.policies.LoadBalancingPolicy;
import com.simba.cassandra.shaded.google.common.base.Predicate;
import com.simba.cassandra.shaded.google.common.collect.ImmutableCollection;
import com.simba.cassandra.shaded.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;

public class WhiteListPolicy
extends HostFilterPolicy {
    public WhiteListPolicy(LoadBalancingPolicy childPolicy, Collection<InetSocketAddress> whiteList) {
        super(childPolicy, WhiteListPolicy.buildPredicate(whiteList));
    }

    private WhiteListPolicy(LoadBalancingPolicy childPolicy, Predicate<Host> predicate) {
        super(childPolicy, predicate);
    }

    private static Predicate<Host> buildPredicate(Collection<InetSocketAddress> whiteList) {
        final ImmutableSet<InetSocketAddress> hosts = ImmutableSet.copyOf(whiteList);
        return new Predicate<Host>(){

            @Override
            public boolean apply(Host host) {
                InetSocketAddress socketAddress = host.getEndPoint().resolve();
                return hosts.contains(socketAddress);
            }
        };
    }

    public static WhiteListPolicy ofHosts(LoadBalancingPolicy childPolicy, String ... hostnames) {
        return WhiteListPolicy.ofHosts(childPolicy, Arrays.asList(hostnames));
    }

    public static WhiteListPolicy ofHosts(LoadBalancingPolicy childPolicy, Iterable<String> hostnames) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String hostname : hostnames) {
            try {
                if (hostname == null) {
                    throw new NullPointerException();
                }
                builder.add(InetAddress.getAllByName(hostname));
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Failed to resolve: " + hostname, e);
            }
        }
        ImmutableCollection addresses = builder.build();
        return new WhiteListPolicy(childPolicy, new Predicate<Host>((ImmutableSet)addresses){
            final /* synthetic */ ImmutableSet val$addresses;
            {
                this.val$addresses = immutableSet;
            }

            @Override
            public boolean apply(Host host) {
                InetSocketAddress socketAddress = host.getEndPoint().resolve();
                return this.val$addresses.contains(socketAddress.getAddress());
            }
        });
    }
}

