/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.jnr.ffi.provider.jffi;

import com.simba.cassandra.shaded.jnr.ffi.NativeLong;
import com.simba.cassandra.shaded.jnr.ffi.Pointer;
import com.simba.cassandra.shaded.jnr.ffi.Struct;
import com.simba.cassandra.shaded.jnr.ffi.annotations.Delegate;
import com.simba.cassandra.shaded.jnr.ffi.byref.ByReference;
import com.simba.cassandra.shaded.jnr.ffi.mapper.AbstractSignatureTypeMapper;
import com.simba.cassandra.shaded.jnr.ffi.mapper.FromNativeContext;
import com.simba.cassandra.shaded.jnr.ffi.mapper.FromNativeConverter;
import com.simba.cassandra.shaded.jnr.ffi.mapper.FromNativeType;
import com.simba.cassandra.shaded.jnr.ffi.mapper.FromNativeTypes;
import com.simba.cassandra.shaded.jnr.ffi.mapper.SignatureType;
import com.simba.cassandra.shaded.jnr.ffi.mapper.SignatureTypeMapper;
import com.simba.cassandra.shaded.jnr.ffi.mapper.ToNativeContext;
import com.simba.cassandra.shaded.jnr.ffi.mapper.ToNativeConverter;
import com.simba.cassandra.shaded.jnr.ffi.mapper.ToNativeType;
import com.simba.cassandra.shaded.jnr.ffi.mapper.ToNativeTypes;
import com.simba.cassandra.shaded.jnr.ffi.provider.ParameterFlags;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.BoxedBooleanArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.BoxedByteArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.BoxedDoubleArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.BoxedFloatArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.BoxedIntegerArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.BoxedLong32ArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.BoxedLong64ArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.BoxedShortArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.ByReferenceParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.CharSequenceArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.CharSequenceParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.EnumConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.EnumSetConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.Long32ArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.NativeLong32ArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.NativeLong64ArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.NativeLongConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.Pointer32ArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.Pointer64ArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.StringBufferParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.StringBuilderParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.StringResultConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.StructArrayParameterConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.converters.StructByReferenceToNativeConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.jffi.AsmClassLoader;
import com.simba.cassandra.shaded.jnr.ffi.provider.jffi.ClosureFromNativeConverter;
import com.simba.cassandra.shaded.jnr.ffi.provider.jffi.NativeClosureManager;
import com.simba.cassandra.shaded.jnr.ffi.provider.jffi.StructByReferenceResultConverterFactory;
import com.simba.cassandra.shaded.jnr.ffi.provider.jffi.Types;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.Set;

final class InvokerTypeMapper
extends AbstractSignatureTypeMapper
implements SignatureTypeMapper {
    private final NativeClosureManager closureManager;
    private final AsmClassLoader classLoader;
    private final StructByReferenceResultConverterFactory structResultConverterFactory;

    public InvokerTypeMapper(NativeClosureManager closureManager, AsmClassLoader classLoader, boolean asmEnabled) {
        this.closureManager = closureManager;
        this.classLoader = classLoader;
        this.structResultConverterFactory = new StructByReferenceResultConverterFactory(classLoader, asmEnabled);
    }

    public FromNativeConverter getFromNativeConverter(SignatureType signatureType, FromNativeContext fromNativeContext) {
        FromNativeConverter<Set<? extends Enum>, Integer> converter;
        if (Enum.class.isAssignableFrom(signatureType.getDeclaredType())) {
            return EnumConverter.getInstance(signatureType.getDeclaredType().asSubclass(Enum.class));
        }
        if (Struct.class.isAssignableFrom(signatureType.getDeclaredType())) {
            return this.structResultConverterFactory.get(signatureType.getDeclaredType().asSubclass(Struct.class), fromNativeContext);
        }
        if (this.closureManager != null && InvokerTypeMapper.isDelegate(signatureType.getDeclaredType())) {
            return ClosureFromNativeConverter.getInstance(fromNativeContext.getRuntime(), signatureType, this.classLoader, this);
        }
        if (NativeLong.class == signatureType.getDeclaredType()) {
            return NativeLongConverter.getInstance();
        }
        if (String.class == signatureType.getDeclaredType() || CharSequence.class == signatureType.getDeclaredType()) {
            return StringResultConverter.getInstance(fromNativeContext);
        }
        if ((Set.class == signatureType.getDeclaredType() || EnumSet.class == signatureType.getDeclaredType()) && (converter = EnumSetConverter.getFromNativeConverter(signatureType, fromNativeContext)) != null) {
            return converter;
        }
        return null;
    }

    public ToNativeConverter getToNativeConverter(SignatureType signatureType, ToNativeContext context) {
        ToNativeConverter<Set<? extends Enum>, Integer> converter;
        Class javaType = signatureType.getDeclaredType();
        if (Enum.class.isAssignableFrom(javaType)) {
            return EnumConverter.getInstance(javaType.asSubclass(Enum.class));
        }
        if (Set.class.isAssignableFrom(javaType) && (converter = EnumSetConverter.getToNativeConverter(signatureType, context)) != null) {
            return converter;
        }
        if (InvokerTypeMapper.isDelegate(javaType)) {
            return this.closureManager.newClosureSite(javaType);
        }
        if (ByReference.class.isAssignableFrom(javaType)) {
            return ByReferenceParameterConverter.getInstance(context);
        }
        if (Struct.class.isAssignableFrom(javaType)) {
            return StructByReferenceToNativeConverter.getInstance(context);
        }
        if (NativeLong.class.isAssignableFrom(javaType)) {
            return NativeLongConverter.getInstance();
        }
        if (StringBuilder.class.isAssignableFrom(javaType)) {
            return StringBuilderParameterConverter.getInstance(ParameterFlags.parse(context.getAnnotations()), context);
        }
        if (StringBuffer.class.isAssignableFrom(javaType)) {
            return StringBufferParameterConverter.getInstance(ParameterFlags.parse(context.getAnnotations()), context);
        }
        if (CharSequence.class.isAssignableFrom(javaType)) {
            return CharSequenceParameterConverter.getInstance(context);
        }
        if (Byte[].class.isAssignableFrom(javaType)) {
            return BoxedByteArrayParameterConverter.getInstance(context);
        }
        if (Short[].class.isAssignableFrom(javaType)) {
            return BoxedShortArrayParameterConverter.getInstance(context);
        }
        if (Integer[].class.isAssignableFrom(javaType)) {
            return BoxedIntegerArrayParameterConverter.getInstance(context);
        }
        if (Long[].class.isAssignableFrom(javaType)) {
            return Types.getType(context.getRuntime(), javaType.getComponentType(), context.getAnnotations()).size() == 4 ? BoxedLong32ArrayParameterConverter.getInstance(context) : BoxedLong64ArrayParameterConverter.getInstance(context);
        }
        if (NativeLong[].class.isAssignableFrom(javaType)) {
            return Types.getType(context.getRuntime(), javaType.getComponentType(), context.getAnnotations()).size() == 4 ? NativeLong32ArrayParameterConverter.getInstance(context) : NativeLong64ArrayParameterConverter.getInstance(context);
        }
        if (Float[].class.isAssignableFrom(javaType)) {
            return BoxedFloatArrayParameterConverter.getInstance(context);
        }
        if (Double[].class.isAssignableFrom(javaType)) {
            return BoxedDoubleArrayParameterConverter.getInstance(context);
        }
        if (Boolean[].class.isAssignableFrom(javaType)) {
            return BoxedBooleanArrayParameterConverter.getInstance(context);
        }
        if (javaType.isArray() && Pointer.class.isAssignableFrom(javaType.getComponentType())) {
            return context.getRuntime().addressSize() == 4 ? Pointer32ArrayParameterConverter.getInstance(context) : Pointer64ArrayParameterConverter.getInstance(context);
        }
        if (long[].class.isAssignableFrom(javaType) && Types.getType(context.getRuntime(), javaType.getComponentType(), context.getAnnotations()).size() == 4) {
            return Long32ArrayParameterConverter.getInstance(context);
        }
        if (javaType.isArray() && Struct.class.isAssignableFrom(javaType.getComponentType())) {
            return StructArrayParameterConverter.getInstance(context, javaType.getComponentType());
        }
        if (javaType.isArray() && CharSequence.class.isAssignableFrom(javaType.getComponentType())) {
            return CharSequenceArrayParameterConverter.getInstance(context);
        }
        return null;
    }

    @Override
    public FromNativeType getFromNativeType(SignatureType type, FromNativeContext context) {
        return FromNativeTypes.create(this.getFromNativeConverter(type, context));
    }

    @Override
    public ToNativeType getToNativeType(SignatureType type, ToNativeContext context) {
        return ToNativeTypes.create(this.getToNativeConverter(type, context));
    }

    private static boolean isDelegate(Class klass) {
        for (Method m : klass.getMethods()) {
            if (!m.isAnnotationPresent(Delegate.class)) continue;
            return true;
        }
        return false;
    }
}

