/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.jnr.ffi.provider.jffi;

import com.simba.cassandra.shaded.jnr.ffi.CallingConvention;
import com.simba.cassandra.shaded.jnr.ffi.LibraryOption;
import com.simba.cassandra.shaded.jnr.ffi.NativeType;
import com.simba.cassandra.shaded.jnr.ffi.Runtime;
import com.simba.cassandra.shaded.jnr.ffi.Type;
import com.simba.cassandra.shaded.jnr.ffi.annotations.StdCall;
import com.simba.cassandra.shaded.jnr.ffi.mapper.DefaultSignatureType;
import com.simba.cassandra.shaded.jnr.ffi.mapper.FromNativeContext;
import com.simba.cassandra.shaded.jnr.ffi.mapper.FromNativeConverter;
import com.simba.cassandra.shaded.jnr.ffi.mapper.FromNativeType;
import com.simba.cassandra.shaded.jnr.ffi.mapper.MethodParameterContext;
import com.simba.cassandra.shaded.jnr.ffi.mapper.SignatureTypeMapper;
import com.simba.cassandra.shaded.jnr.ffi.mapper.ToNativeContext;
import com.simba.cassandra.shaded.jnr.ffi.mapper.ToNativeConverter;
import com.simba.cassandra.shaded.jnr.ffi.mapper.ToNativeType;
import com.simba.cassandra.shaded.jnr.ffi.provider.ParameterType;
import com.simba.cassandra.shaded.jnr.ffi.provider.ResultType;
import com.simba.cassandra.shaded.jnr.ffi.provider.SigType;
import com.simba.cassandra.shaded.jnr.ffi.provider.jffi.ConverterMetaData;
import com.simba.cassandra.shaded.jnr.ffi.provider.jffi.Types;
import com.simba.cassandra.shaded.jnr.ffi.util.Annotations;
import com.simba.cassandra.shaded.kenai.jffi.CallContext;
import com.simba.cassandra.shaded.kenai.jffi.CallContextCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

final class InvokerUtil {
    static final Map<NativeType, com.simba.cassandra.shaded.kenai.jffi.Type> jffiTypes;

    InvokerUtil() {
    }

    public static CallingConvention getCallingConvention(Map<LibraryOption, ?> libraryOptions) {
        Object convention = libraryOptions.get((Object)LibraryOption.CallingConvention);
        if (convention instanceof com.simba.cassandra.shaded.kenai.jffi.CallingConvention) {
            return com.simba.cassandra.shaded.kenai.jffi.CallingConvention.DEFAULT.equals(convention) ? CallingConvention.DEFAULT : CallingConvention.STDCALL;
        }
        if (convention instanceof CallingConvention) {
            switch ((CallingConvention)((Object)convention)) {
                case DEFAULT: {
                    return CallingConvention.DEFAULT;
                }
                case STDCALL: {
                    return CallingConvention.STDCALL;
                }
            }
        } else if (convention != null) {
            throw new IllegalArgumentException("unknown calling convention: " + convention);
        }
        return CallingConvention.DEFAULT;
    }

    public static CallingConvention getCallingConvention(Class interfaceClass, Map<LibraryOption, ?> options) {
        if (interfaceClass.isAnnotationPresent(StdCall.class)) {
            return CallingConvention.STDCALL;
        }
        return InvokerUtil.getCallingConvention(options);
    }

    public static boolean hasAnnotation(Collection<Annotation> annotations, Class<? extends Annotation> annotationClass) {
        for (Annotation a : annotations) {
            if (!annotationClass.isInstance(a)) continue;
            return true;
        }
        return false;
    }

    static com.simba.cassandra.shaded.kenai.jffi.Type jffiType(NativeType jnrType) {
        com.simba.cassandra.shaded.kenai.jffi.Type jffiType = jffiTypes.get((Object)jnrType);
        if (jffiType != null) {
            return jffiType;
        }
        throw new IllegalArgumentException("unsupported parameter type: " + (Object)((Object)jnrType));
    }

    static NativeType nativeType(Type jnrType) {
        return jnrType.getNativeType();
    }

    static Collection<Annotation> getAnnotations(FromNativeType fromNativeType) {
        return fromNativeType != null ? ConverterMetaData.getAnnotations(fromNativeType.getFromNativeConverter()) : Annotations.EMPTY_ANNOTATIONS;
    }

    static Collection<Annotation> getAnnotations(ToNativeType toNativeType) {
        return toNativeType != null ? ConverterMetaData.getAnnotations(toNativeType.getToNativeConverter()) : Annotations.EMPTY_ANNOTATIONS;
    }

    static ResultType getResultType(Runtime runtime, Class type, Collection<Annotation> annotations, FromNativeConverter fromNativeConverter, FromNativeContext fromNativeContext) {
        Collection<Annotation> converterAnnotations = ConverterMetaData.getAnnotations(fromNativeConverter);
        Collection<Annotation> allAnnotations = Annotations.mergeAnnotations(annotations, converterAnnotations);
        NativeType nativeType = InvokerUtil.getMethodResultNativeType(runtime, fromNativeConverter != null ? fromNativeConverter.nativeType() : type, allAnnotations);
        boolean useContext = fromNativeConverter != null && !InvokerUtil.hasAnnotation(converterAnnotations, FromNativeConverter.NoContext.class);
        return new ResultType(type, nativeType, allAnnotations, fromNativeConverter, useContext ? fromNativeContext : null);
    }

    static ResultType getResultType(Runtime runtime, Class type, Collection<Annotation> annotations, FromNativeType fromNativeType, FromNativeContext fromNativeContext) {
        Collection<Annotation> converterAnnotations = InvokerUtil.getAnnotations(fromNativeType);
        Collection<Annotation> allAnnotations = Annotations.mergeAnnotations(annotations, converterAnnotations);
        FromNativeConverter fromNativeConverter = fromNativeType != null ? fromNativeType.getFromNativeConverter() : null;
        NativeType nativeType = InvokerUtil.getMethodResultNativeType(runtime, fromNativeConverter != null ? fromNativeConverter.nativeType() : type, allAnnotations);
        boolean useContext = fromNativeConverter != null && !InvokerUtil.hasAnnotation(converterAnnotations, FromNativeConverter.NoContext.class);
        return new ResultType(type, nativeType, allAnnotations, fromNativeConverter, useContext ? fromNativeContext : null);
    }

    private static ParameterType getParameterType(Runtime runtime, Class type, Collection<Annotation> annotations, ToNativeConverter toNativeConverter, ToNativeContext toNativeContext) {
        NativeType nativeType = InvokerUtil.getMethodParameterNativeType(runtime, toNativeConverter != null ? toNativeConverter.nativeType() : type, annotations);
        return new ParameterType(type, nativeType, annotations, toNativeConverter, toNativeContext);
    }

    private static ParameterType getParameterType(Runtime runtime, Class type, Collection<Annotation> annotations, ToNativeType toNativeType, ToNativeContext toNativeContext) {
        ToNativeConverter toNativeConverter = toNativeType != null ? toNativeType.getToNativeConverter() : null;
        NativeType nativeType = InvokerUtil.getMethodParameterNativeType(runtime, toNativeConverter != null ? toNativeConverter.nativeType() : type, annotations);
        return new ParameterType(type, nativeType, annotations, toNativeConverter, toNativeContext);
    }

    static ParameterType[] getParameterTypes(Runtime runtime, SignatureTypeMapper typeMapper, Method m) {
        Class<?>[] javaParameterTypes = m.getParameterTypes();
        Annotation[][] parameterAnnotations = m.getParameterAnnotations();
        ParameterType[] parameterTypes = new ParameterType[javaParameterTypes.length];
        for (int pidx = 0; pidx < javaParameterTypes.length; ++pidx) {
            Collection<Annotation> annotations = Annotations.sortedAnnotationCollection(parameterAnnotations[pidx]);
            MethodParameterContext toNativeContext = new MethodParameterContext(runtime, m, pidx, annotations);
            DefaultSignatureType signatureType = DefaultSignatureType.create(javaParameterTypes[pidx], toNativeContext);
            ToNativeType toNativeType = typeMapper.getToNativeType(signatureType, toNativeContext);
            ToNativeConverter toNativeConverter = toNativeType != null ? toNativeType.getToNativeConverter() : null;
            Collection<Annotation> converterAnnotations = ConverterMetaData.getAnnotations(toNativeConverter);
            Collection<Annotation> allAnnotations = Annotations.mergeAnnotations(annotations, converterAnnotations);
            boolean contextRequired = toNativeConverter != null && !InvokerUtil.hasAnnotation(converterAnnotations, ToNativeConverter.NoContext.class);
            parameterTypes[pidx] = InvokerUtil.getParameterType(runtime, javaParameterTypes[pidx], allAnnotations, toNativeConverter, (ToNativeContext)(contextRequired ? toNativeContext : null));
        }
        return parameterTypes;
    }

    static CallContext getCallContext(SigType resultType, SigType[] parameterTypes, CallingConvention convention, boolean requiresErrno) {
        return InvokerUtil.getCallContext(resultType, parameterTypes, parameterTypes.length, convention, requiresErrno);
    }

    static CallContext getCallContext(SigType resultType, SigType[] parameterTypes, int paramTypesLength, CallingConvention convention, boolean requiresErrno) {
        com.simba.cassandra.shaded.kenai.jffi.Type[] nativeParamTypes = new com.simba.cassandra.shaded.kenai.jffi.Type[paramTypesLength];
        for (int i = 0; i < nativeParamTypes.length; ++i) {
            nativeParamTypes[i] = InvokerUtil.jffiType(parameterTypes[i].getNativeType());
        }
        return CallContextCache.getInstance().getCallContext(InvokerUtil.jffiType(resultType.getNativeType()), nativeParamTypes, InvokerUtil.jffiConvention(convention), requiresErrno);
    }

    public static CallingConvention getNativeCallingConvention(Method m) {
        if (m.isAnnotationPresent(StdCall.class) || m.getDeclaringClass().isAnnotationPresent(StdCall.class)) {
            return CallingConvention.STDCALL;
        }
        return CallingConvention.DEFAULT;
    }

    static NativeType getMethodParameterNativeType(Runtime runtime, Class parameterClass, Collection<Annotation> annotations) {
        return Types.getType(runtime, parameterClass, annotations).getNativeType();
    }

    static NativeType getMethodResultNativeType(Runtime runtime, Class resultClass, Collection<Annotation> annotations) {
        return Types.getType(runtime, resultClass, annotations).getNativeType();
    }

    public static final com.simba.cassandra.shaded.kenai.jffi.CallingConvention jffiConvention(CallingConvention callingConvention) {
        return callingConvention == CallingConvention.DEFAULT ? com.simba.cassandra.shaded.kenai.jffi.CallingConvention.DEFAULT : com.simba.cassandra.shaded.kenai.jffi.CallingConvention.STDCALL;
    }

    static {
        EnumMap<NativeType, com.simba.cassandra.shaded.kenai.jffi.Type> m = new EnumMap<NativeType, com.simba.cassandra.shaded.kenai.jffi.Type>(NativeType.class);
        m.put(NativeType.VOID, com.simba.cassandra.shaded.kenai.jffi.Type.VOID);
        m.put(NativeType.SCHAR, com.simba.cassandra.shaded.kenai.jffi.Type.SCHAR);
        m.put(NativeType.UCHAR, com.simba.cassandra.shaded.kenai.jffi.Type.UCHAR);
        m.put(NativeType.SSHORT, com.simba.cassandra.shaded.kenai.jffi.Type.SSHORT);
        m.put(NativeType.USHORT, com.simba.cassandra.shaded.kenai.jffi.Type.USHORT);
        m.put(NativeType.SINT, com.simba.cassandra.shaded.kenai.jffi.Type.SINT);
        m.put(NativeType.UINT, com.simba.cassandra.shaded.kenai.jffi.Type.UINT);
        m.put(NativeType.SLONG, com.simba.cassandra.shaded.kenai.jffi.Type.SLONG);
        m.put(NativeType.ULONG, com.simba.cassandra.shaded.kenai.jffi.Type.ULONG);
        m.put(NativeType.SLONGLONG, com.simba.cassandra.shaded.kenai.jffi.Type.SLONG_LONG);
        m.put(NativeType.ULONGLONG, com.simba.cassandra.shaded.kenai.jffi.Type.ULONG_LONG);
        m.put(NativeType.FLOAT, com.simba.cassandra.shaded.kenai.jffi.Type.FLOAT);
        m.put(NativeType.DOUBLE, com.simba.cassandra.shaded.kenai.jffi.Type.DOUBLE);
        m.put(NativeType.ADDRESS, com.simba.cassandra.shaded.kenai.jffi.Type.POINTER);
        jffiTypes = Collections.unmodifiableMap(m);
    }
}

