/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.jnr.posix;

import com.simba.cassandra.shaded.jnr.constants.Constant;
import com.simba.cassandra.shaded.jnr.ffi.Platform;
import com.simba.cassandra.shaded.jnr.ffi.mapper.FromNativeContext;
import com.simba.cassandra.shaded.jnr.ffi.mapper.FromNativeConverter;
import com.simba.cassandra.shaded.jnr.ffi.mapper.ToNativeContext;
import com.simba.cassandra.shaded.jnr.ffi.mapper.ToNativeConverter;
import com.simba.cassandra.shaded.jnr.ffi.mapper.TypeMapper;
import com.simba.cassandra.shaded.jnr.posix.AixPOSIX;
import com.simba.cassandra.shaded.jnr.posix.BaseNativePOSIX;
import com.simba.cassandra.shaded.jnr.posix.FileStat;
import com.simba.cassandra.shaded.jnr.posix.FreeBSDPOSIX;
import com.simba.cassandra.shaded.jnr.posix.Group;
import com.simba.cassandra.shaded.jnr.posix.HANDLE;
import com.simba.cassandra.shaded.jnr.posix.LinuxPOSIX;
import com.simba.cassandra.shaded.jnr.posix.MacOSPOSIX;
import com.simba.cassandra.shaded.jnr.posix.MsgHdr;
import com.simba.cassandra.shaded.jnr.posix.NativeTimes;
import com.simba.cassandra.shaded.jnr.posix.OpenBSDPOSIX;
import com.simba.cassandra.shaded.jnr.posix.Passwd;
import com.simba.cassandra.shaded.jnr.posix.SolarisPOSIX;
import com.simba.cassandra.shaded.jnr.posix.WString;
import com.simba.cassandra.shaded.jnr.posix.WindowsPOSIX;
import com.simba.cassandra.shaded.jnr.posix.util.Platform;

final class POSIXTypeMapper
implements TypeMapper {
    public static final TypeMapper INSTANCE = new POSIXTypeMapper();

    private POSIXTypeMapper() {
    }

    @Override
    public FromNativeConverter getFromNativeConverter(Class klazz) {
        if (Passwd.class.isAssignableFrom(klazz)) {
            if (Platform.IS_MAC) {
                return MacOSPOSIX.PASSWD;
            }
            if (Platform.IS_LINUX) {
                return LinuxPOSIX.PASSWD;
            }
            if (Platform.IS_SOLARIS) {
                return SolarisPOSIX.PASSWD;
            }
            if (Platform.IS_FREEBSD) {
                return FreeBSDPOSIX.PASSWD;
            }
            if (Platform.IS_OPENBSD) {
                return OpenBSDPOSIX.PASSWD;
            }
            if (Platform.IS_WINDOWS) {
                return WindowsPOSIX.PASSWD;
            }
            if (com.simba.cassandra.shaded.jnr.ffi.Platform.getNativePlatform().getOS().equals((Object)Platform.OS.AIX)) {
                return AixPOSIX.PASSWD;
            }
            return null;
        }
        if (Group.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.GROUP;
        }
        if (HANDLE.class.isAssignableFrom(klazz)) {
            return HANDLE.Converter;
        }
        return null;
    }

    @Override
    public ToNativeConverter getToNativeConverter(Class klazz) {
        if (FileStat.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.FileStatConverter;
        }
        if (NativeTimes.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.TimesConverter;
        }
        if (Constant.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.ConstantConverter;
        }
        if (WString.class.isAssignableFrom(klazz)) {
            return WString.Converter;
        }
        if (HANDLE.class.isAssignableFrom(klazz)) {
            return HANDLE.Converter;
        }
        if (MsgHdr.class.isAssignableFrom(klazz)) {
            return BaseNativePOSIX.MsgHdrConverter;
        }
        return null;
    }

    public final ToNativeConverter getToNativeConverter(Class klazz, ToNativeContext context) {
        return this.getToNativeConverter(klazz);
    }

    public final FromNativeConverter getFromNativeConverter(Class klazz, FromNativeContext context) {
        return this.getFromNativeConverter(klazz);
    }
}

