/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.aeprocessor.aetree;

import com.simba.cassandra.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENode;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEAggrFn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEProxyColumn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueSubQuery;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.utilities.SQLEngineMessageKey;
import com.simba.cassandra.support.exceptions.ErrorException;

public final class AESemantics {
    private AESemantics() {
        throw new UnsupportedOperationException();
    }

    public static AEQueryScope findUniqueQueryScope(AEValueExpr aEValueExpr, boolean bl) throws ErrorException {
        return AETreeWalker.walk(aEValueExpr, new FindUniqueQueryScopeAction(bl));
    }

    public static void checkAggrFnSemantics(AEValueExpr aEValueExpr, AEQueryScope aEQueryScope) throws ErrorException {
        AEQueryScope.ClauseType clauseType;
        AEQueryScope aEQueryScope2 = AETreeWalker.walk(aEValueExpr, new CheckAggrFnAction());
        AEQueryScope.ClauseType clauseType2 = aEQueryScope.getCurrentClause();
        switch (clauseType2) {
            case FROM: {
                if (aEQueryScope2 != null && aEQueryScope != aEQueryScope2) break;
                throw SQLEngineExceptionFactory.aggrFnSemanticsException(SQLEngineMessageKey.AGGR_FN_IN_ON);
            }
            case WHERE: {
                if (aEQueryScope2 != null && aEQueryScope != aEQueryScope2) break;
                throw SQLEngineExceptionFactory.aggrFnSemanticsException(SQLEngineMessageKey.AGGR_FN_IN_WHERE);
            }
            case GROUP_BY: {
                throw SQLEngineExceptionFactory.aggrFnSemanticsException(SQLEngineMessageKey.AGGR_FN_N_SUBQUERY_IN_GROUPBY);
            }
        }
        if (aEQueryScope2 != null && aEQueryScope != aEQueryScope2 && (clauseType = aEQueryScope2.getCurrentClause()) != AEQueryScope.ClauseType.SELECT_LIST && clauseType != AEQueryScope.ClauseType.HAVING) {
            if (clauseType2 == AEQueryScope.ClauseType.FROM) {
                throw SQLEngineExceptionFactory.aggrFnSemanticsException(SQLEngineMessageKey.AGGR_FN_IN_ON);
            }
            if (clauseType2 == AEQueryScope.ClauseType.WHERE) {
                throw SQLEngineExceptionFactory.aggrFnSemanticsException(SQLEngineMessageKey.AGGR_FN_IN_WHERE);
            }
            throw SQLEngineExceptionFactory.aggrFnSemanticsException(SQLEngineMessageKey.AGGR_FN_NOT_IN_SEL_LIST_OR_HAVING);
        }
    }

    private static class CheckAggrFnAction
    extends FindUniqueQueryScopeAction {
        public CheckAggrFnAction() {
            super(true);
        }

        @Override
        public void act(IAENode iAENode) throws ErrorException {
            if (iAENode instanceof AEAggrFn || iAENode instanceof AEValueSubQuery) {
                throw SQLEngineExceptionFactory.aggrFnSemanticsException(SQLEngineMessageKey.NESTED_AGGR_FN_NOT_ALLOWED);
            }
            super.act(iAENode);
        }
    }

    private static class FindUniqueQueryScopeAction
    extends AETreeWalker.Action<AEQueryScope> {
        private AEQueryScope m_queryScope = null;
        private boolean m_shouldThrow;

        public FindUniqueQueryScopeAction(boolean bl) {
            this.m_shouldThrow = bl;
        }

        @Override
        public AEQueryScope getResult() {
            return this.m_queryScope;
        }

        @Override
        public void act(IAENode iAENode) throws ErrorException {
            AEQueryScope aEQueryScope = null;
            if (iAENode instanceof AEProxyColumn) {
                aEQueryScope = ((AEProxyColumn)iAENode).getResolvedQueryScope();
            } else if (iAENode instanceof AEColumnReference) {
                aEQueryScope = ((AEColumnReference)iAENode).getResolvedQueryScope();
            }
            if (aEQueryScope != null) {
                if (this.m_queryScope == null) {
                    this.m_queryScope = aEQueryScope;
                } else if (this.m_queryScope != aEQueryScope) {
                    if (this.m_shouldThrow) {
                        throw SQLEngineExceptionFactory.aggrFnSemanticsException(SQLEngineMessageKey.MULTI_COL_IN_AGGR_FN);
                    }
                    this.skipAll();
                    this.m_queryScope = null;
                }
            }
        }
    }
}

