/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.aeprocessor.aetree.relation;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.sqlengine.aeprocessor.AEQTableName;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.AESortSpec;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENode;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AETable
extends AENamedRelationalExpr {
    private List<? extends IColumn> m_tableColumns;
    private DSIExtJResultSet m_table;
    private SESortInfo m_passdownSortInfo;

    public AETable(DSIExtJResultSet dSIExtJResultSet) throws ErrorException {
        if (null == dSIExtJResultSet) {
            throw new NullPointerException("table cannot be null.");
        }
        this.m_table = dSIExtJResultSet;
        this.m_tableColumns = new ArrayList<IColumn>(this.m_table.getSelectColumns());
        this.m_passdownSortInfo = null;
    }

    public AETable(DSIExtJResultSet dSIExtJResultSet, SESortInfo sESortInfo) throws ErrorException {
        this(dSIExtJResultSet);
        this.m_passdownSortInfo = sESortInfo;
    }

    private AETable(AETable aETable) {
        super(aETable);
        this.m_table = aETable.m_table;
        this.m_tableColumns = new ArrayList<IColumn>(aETable.m_tableColumns);
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public AETable copy() {
        return new AETable(this);
    }

    public Iterator<IAENode> getChildItr() {
        return Collections.emptyList().iterator();
    }

    @Override
    public String getLogString() {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append("AETable: ");
        stringBuilder.append(new AEQTableName(this.m_table.getCatalogName(), this.m_table.getSchemaName(), this.m_table.getTableName()));
        if (this.hasCorrelationName()) {
            stringBuilder.append(" AS ").append(this.getQTableName());
        }
        return stringBuilder.toString();
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AETable)) {
            return false;
        }
        AETable aETable = (AETable)iAENode;
        return aETable.m_table == this.m_table;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AETable)) {
            return false;
        }
        return this.isEquivalent((AETable)object);
    }

    public int hashCode() {
        return this.m_table.hashCode();
    }

    @Override
    public IColumn getBaseColumn(int n) {
        return this.m_tableColumns.get(n);
    }

    public AEQTableName getBaseQTableName() {
        String string;
        AEQTableName.AEQTableNameBuilder aEQTableNameBuilder = new AEQTableName.AEQTableNameBuilder();
        String string2 = this.m_table.getCatalogName();
        if (null != string2) {
            aEQTableNameBuilder.setCatalogName(string2);
        }
        if (null != (string = this.m_table.getSchemaName())) {
            aEQTableNameBuilder.setSchemaName(string);
        }
        aEQTableNameBuilder.setTableName(this.m_table.getTableName());
        return aEQTableNameBuilder.build();
    }

    public String getBaseTableName() {
        return this.m_table.getTableName();
    }

    @Override
    public String getCatalogName() {
        if (this.hasCorrelationName()) {
            return "";
        }
        return this.m_table.getCatalogName();
    }

    @Override
    public String getSchemaName() {
        if (this.hasCorrelationName()) {
            return "";
        }
        return this.m_table.getSchemaName();
    }

    @Override
    public String getTableName() {
        if (this.hasCorrelationName()) {
            return this.getCorrelationName();
        }
        return this.m_table.getTableName();
    }

    public DSIExtJResultSet getTable() {
        return this.m_table;
    }

    public void setTable(DSIExtJResultSet dSIExtJResultSet) {
        if (dSIExtJResultSet == null) {
            throw new NullPointerException("null set on a AETable.");
        }
        this.m_table = dSIExtJResultSet;
    }

    @Override
    public int getColumnCount() {
        return this.m_tableColumns.size();
    }

    public boolean hasCorrelationName() {
        return this.getCorrelationName().length() > 0;
    }

    @Override
    public int setDataNeeded(AERelationalExpr aERelationalExpr, int n) throws ErrorException {
        if (aERelationalExpr.equals(this)) {
            this.m_table.setDataNeeded(n, true);
            return n;
        }
        return -1;
    }

    @Override
    public void setDataNeededOnChild() throws ErrorException {
    }

    @Override
    public boolean getDataNeeded(int n) {
        return this.m_table.getDataNeeded(n);
    }

    public SESortInfo GetPassdownSortInfo() {
        return this.m_passdownSortInfo;
    }

    public static class SESortInfo {
        private SESortOrder m_sortOrder;
        private List<AESortSpec> m_sortSpecs;

        public SESortInfo(SESortOrder sESortOrder, List<AESortSpec> list) {
            this.m_sortOrder = sESortOrder;
            this.m_sortSpecs = new ArrayList<AESortSpec>(list);
        }

        public SESortOrder getSortOrder() {
            return this.m_sortOrder;
        }

        public List<AESortSpec> getSortSpec() {
            return Collections.unmodifiableList(this.m_sortSpecs);
        }
    }

    public static enum SESortOrder {
        ODBC_ORDER,
        ODBC_ORDER_REVERSED,
        NOT_ODBC_ORDER;

    }
}

