/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.relation;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.CursorType;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.IETNode;
import com.simba.cassandra.sqlengine.executor.etree.IETNodeVisitor;
import com.simba.cassandra.sqlengine.executor.etree.IETUnaryNode;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueExprList;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.List;

public class ETProject
extends ETRelationalExpr
implements IETUnaryNode<ETRelationalExpr> {
    private ETRelationalExpr m_operand;
    private ETValueExprList m_projectList;
    private List<IColumn> m_projectMetadata;

    public ETProject(ETRelationalExpr eTRelationalExpr, ETValueExprList eTValueExprList, List<IColumn> list, boolean[] blArray) {
        super(blArray);
        this.m_operand = eTRelationalExpr;
        this.m_projectList = eTValueExprList;
        this.m_projectMetadata = list;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public void close(boolean bl) {
        this.m_operand.close(bl);
        this.m_projectList.close(bl);
    }

    @Override
    public IColumn getColumn(int n) {
        return this.m_projectMetadata.get(n);
    }

    @Override
    public int getColumnCount() {
        return this.m_projectList.getNumChildren();
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_operand.getRowCount();
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public ETRelationalExpr getOperand() {
        return this.m_operand;
    }

    public ETValueExprList getProjectionList() {
        return this.m_projectList;
    }

    @Override
    public boolean isOpen() {
        return this.m_operand.isOpen();
    }

    @Override
    public void open(CursorType cursorType) throws ErrorException {
        this.m_operand.open(cursorType);
        this.m_projectList.open();
    }

    @Override
    public void reset() throws ErrorException {
        this.m_operand.reset();
        this.m_projectList.reset();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        return this.m_projectList.retrieveData(n, eTDataRequest);
    }

    @Override
    protected IETNode getChild(int n) {
        if (0 == n) {
            return this.getOperand();
        }
        if (1 == n) {
            return this.getProjectionList();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    protected boolean doMove() throws ErrorException {
        return this.m_operand.move();
    }
}

