/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.value;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.CursorType;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.dataengine.utilities.TypeUtilities;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.IETNode;
import com.simba.cassandra.sqlengine.executor.etree.IETNodeVisitor;
import com.simba.cassandra.sqlengine.executor.etree.IETUnaryNode;
import com.simba.cassandra.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.simba.cassandra.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueExpr;
import com.simba.cassandra.support.exceptions.ErrorException;

public class ETValueSubQuery
extends ETValueExpr
implements IETUnaryNode<ETRelationalExpr> {
    private final ETRelationalExpr m_operand;
    private final IColumn m_metadata;
    private final boolean m_isCorrelated;
    private final ETDataRequest m_result;
    private boolean m_resultHasAllData;
    private boolean m_isOpen;

    public ETValueSubQuery(ETRelationalExpr eTRelationalExpr, IColumn iColumn, boolean bl) {
        this.m_operand = eTRelationalExpr;
        this.m_metadata = iColumn;
        this.m_isCorrelated = bl;
        this.m_result = new ETDataRequest(this.m_metadata);
        this.m_resultHasAllData = false;
        this.m_isOpen = false;
        if (this.m_isCorrelated) {
            eTRelationalExpr.setCanReopenAfterClosed();
        }
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        if (this.m_isCorrelated) {
            this.m_operand.close(true);
            this.m_operand.open(CursorType.FORWARD_ONLY);
            if (this.m_operand.move()) {
                boolean bl = this.m_operand.retrieveData(0, eTDataRequest);
                this.validateSQResult();
                return bl;
            }
            eTDataRequest.getData().setNull();
            return false;
        }
        if (!this.m_resultHasAllData) {
            return this.m_operand.retrieveData(0, eTDataRequest);
        }
        ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
        ISqlDataWrapper iSqlDataWrapper2 = this.m_result.getData();
        if (iSqlDataWrapper2.isNull()) {
            iSqlDataWrapper.setNull();
            return false;
        }
        DataWrapper dataWrapper = new DataWrapper();
        int n = iSqlDataWrapper.getType();
        DefaultSqlDataWrapper.setDataWrapperFromDataWrapper(this.m_result.getData(), eTDataRequest.getData());
        if (TypeUtilities.isCharacterType(n)) {
            iSqlDataWrapper.setChar(iSqlDataWrapper2.getChar());
            boolean bl = DataRetrievalUtil.retrieveCharData(eTDataRequest.getData(), eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), this.m_metadata.getColumnLength(), this.getWarningListener());
            return bl;
        }
        if (TypeUtilities.isBinaryType(n)) {
            iSqlDataWrapper.setBinary(iSqlDataWrapper2.getBinary());
            boolean bl = DataRetrievalUtil.retrieveBinaryData(eTDataRequest.getData(), eTDataRequest.getOffset(), eTDataRequest.getMaxSize(), this.m_metadata.getColumnLength(), this.getWarningListener());
            return bl;
        }
        iSqlDataWrapper2.retrieveData(dataWrapper);
        iSqlDataWrapper.setValue(dataWrapper);
        return false;
    }

    @Override
    public void close(boolean bl) {
        this.m_isOpen = false;
        this.m_operand.close(bl);
    }

    @Override
    public boolean isOpen() {
        if (this.m_isCorrelated) {
            return this.m_isOpen;
        }
        return this.m_operand.isOpen();
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public ETRelationalExpr getOperand() {
        return this.m_operand;
    }

    @Override
    public void open() throws ErrorException {
        if (!this.m_isCorrelated) {
            this.m_operand.open(CursorType.FORWARD_ONLY);
            if (this.m_operand.move()) {
                this.m_result.setMaxBytes(-1L);
                boolean bl = this.m_resultHasAllData = !this.m_operand.retrieveData(0, this.m_result);
                if (!this.m_resultHasAllData) {
                    this.m_result.getData().setNull();
                }
                this.validateSQResult();
            } else {
                this.m_result.getData().setNull();
                this.m_resultHasAllData = true;
            }
        } else {
            this.m_isOpen = true;
        }
    }

    @Override
    public void reset() throws ErrorException {
        if (!this.m_isCorrelated) {
            this.m_operand.reset();
        }
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return this.m_operand;
        }
        throw new IndexOutOfBoundsException("index: " + n);
    }

    private void validateSQResult() throws ErrorException {
        if (this.m_operand.move()) {
            throw SQLEngineExceptionFactory.invalidValueSubquery();
        }
    }
}

