/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.value.functor.arithmetic;

import com.simba.cassandra.dsi.dataengine.utilities.TypeMetadata;
import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.simba.cassandra.support.IWarningListener;
import com.simba.cassandra.support.conv.ConversionResult;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.math.BigDecimal;

public abstract class AbstractDecimalBinArithFunctor
implements IBinaryArithmeticFunctor {
    @Override
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        BigDecimal bigDecimal = iSqlDataWrapper.getExactNumber();
        BigDecimal bigDecimal2 = iSqlDataWrapper2.getExactNumber();
        if (bigDecimal == null || bigDecimal2 == null) {
            eTDataRequest.getData().setExactNumber(null);
        } else {
            ConversionResult conversionResult = new ConversionResult();
            TypeMetadata typeMetadata = eTDataRequest.getMetadata();
            BigDecimal bigDecimal3 = this.calculate(bigDecimal, bigDecimal2, typeMetadata.getPrecision(), typeMetadata.getScale(), conversionResult);
            switch (conversionResult.getState()) {
                case NUMERIC_OUT_OF_RANGE_TOO_LARGE: 
                case NUMERIC_OUT_OF_RANGE_TOO_SMALL: {
                    throw SQLEngineExceptionFactory.numArithOverflowException();
                }
                case SUCCESS: {
                    break;
                }
                case FRAC_TRUNCATION_ROUNDED_DOWN: 
                case FRAC_TRUNCATION_ROUNDED_UP: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected conversion result: " + (Object)((Object)conversionResult.getState()));
                }
            }
            eTDataRequest.getData().setExactNumber(bigDecimal3);
        }
        return false;
    }

    protected abstract BigDecimal calculate(BigDecimal var1, BigDecimal var2, short var3, short var4, ConversionResult var5) throws ErrorException;
}

