/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.value.functor.arithmetic;

import com.simba.cassandra.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.value.functor.arithmetic.IBinaryArithmeticFunctor;
import com.simba.cassandra.support.IWarningListener;
import com.simba.cassandra.support.exceptions.ErrorException;

public abstract class AbstractSmallIntBinArithFunctor
implements IBinaryArithmeticFunctor {
    protected boolean m_isSigned;

    protected AbstractSmallIntBinArithFunctor(boolean bl) {
        this.m_isSigned = bl;
    }

    @Override
    public boolean execute(ETDataRequest eTDataRequest, ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2, IWarningListener iWarningListener) throws ErrorException {
        if (iSqlDataWrapper.isNull() || iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        int n = iSqlDataWrapper.getSmallInt();
        assert (this.m_isSigned && n <= Short.MAX_VALUE && n >= Short.MIN_VALUE || !this.m_isSigned && n >= 0 && n <= 65535);
        int n2 = iSqlDataWrapper2.getSmallInt();
        assert (this.m_isSigned && n2 <= Short.MAX_VALUE && n2 >= Short.MIN_VALUE || !this.m_isSigned && n2 >= 0 && n2 <= 65535);
        int n3 = this.calculate(n, n2);
        if (this.m_isSigned && n3 <= Short.MAX_VALUE && n3 >= Short.MIN_VALUE || !this.m_isSigned && n3 >= 0 && n3 <= 65535) {
            eTDataRequest.getData().setSmallInt(n3);
            return false;
        }
        throw SQLEngineExceptionFactory.numArithOverflowException();
    }

    protected abstract int calculate(int var1, int var2) throws ErrorException;
}

