/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.executor.etree.value.scalar;

import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.TypeUtilities;
import com.simba.cassandra.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.simba.cassandra.sqlengine.executor.etree.ETDataRequest;
import com.simba.cassandra.sqlengine.executor.etree.value.ETValueExpr;
import com.simba.cassandra.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.List;

public final class ETSignFn
extends ETScalarFn {
    private final int m_argType;

    public ETSignFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (1 == list.size() && 1 == list2.size());
        this.m_argType = list2.get(0).getTypeMetadata().getType();
        assert (TypeUtilities.isNumberType(this.m_argType));
        assert (TypeUtilities.isIntegerType(iColumn.getTypeMetadata().getType()));
    }

    @Override
    public String getLogString() {
        return "ETSignFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
        } else {
            int n;
            switch (this.m_argType) {
                case 2: 
                case 3: {
                    n = iSqlDataWrapper.getExactNumber().signum();
                    break;
                }
                case -5: {
                    n = iSqlDataWrapper.getBigInt().signum();
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    n = Long.signum(iSqlDataWrapper.getInteger());
                    break;
                }
                default: {
                    n = (int)Math.signum(iSqlDataWrapper.getDouble());
                }
            }
            eTDataRequest.getData().setSmallInt(n);
        }
        return false;
    }
}

