/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.sqlengine.utilities;

import com.simba.cassandra.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.IAENode;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public class AEStringLogger {
    public static void logAETree(IAENode iAENode, String string, String ... stringArray) throws IOException {
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.createNewFile();
            }
            PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(file, true), true);
            for (String string2 : stringArray) {
                printWriter.print(string2);
                printWriter.print("\n");
            }
            AEStringLogger.walkPreorderDepthFirst(iAENode, new AELogVisitor(printWriter));
            printWriter.close();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    public static String logAETreeToString(IAENode iAENode) throws ErrorException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        AEStringLogger.walkPreorderDepthFirst(iAENode, new AELogVisitor(printWriter));
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }

    private static void walkPreorderDepthFirst(IAENode iAENode, AELogVisitor aELogVisitor) throws ErrorException {
        if (null == iAENode) {
            return;
        }
        Stack<IAENode> stack = new Stack<IAENode>();
        stack.push(iAENode);
        while (!stack.empty()) {
            IAENode iAENode2 = (IAENode)stack.pop();
            iAENode2.acceptVisitor(aELogVisitor);
            Iterator<? extends IAENode> iterator = iAENode2.getChildItr();
            ArrayList<IAENode> arrayList = new ArrayList<IAENode>();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                IAENode iAENode3 = (IAENode)arrayList.get(i);
                if (null == iAENode3) {
                    throw new NullPointerException("Tree nodes cannot be null.");
                }
                stack.push(iAENode3);
            }
        }
    }

    private static class AELogVisitor
    extends AEDefaultVisitor<Void> {
        private Stack<Integer> m_indentStack = new Stack();
        private static final String INDENT_STRING = "    ";
        private PrintWriter m_printWriter;
        private Stack<String> m_childTypeStack;

        public AELogVisitor(PrintWriter printWriter) {
            this.m_indentStack.push(0);
            this.m_printWriter = printWriter;
            this.m_childTypeStack = new Stack();
        }

        @Override
        protected Void defaultVisit(IAENode iAENode) throws ErrorException {
            this.writeString(iAENode.getLogString(), iAENode.getNumChildren());
            return null;
        }

        private void writeString(String string, int n) {
            int n2 = this.m_indentStack.pop();
            int n3 = n2 + 1;
            while (n > 0) {
                this.m_indentStack.push(n3);
                --n;
            }
            StringBuilder stringBuilder = new StringBuilder(1000);
            while (n2 > 0) {
                stringBuilder.append(INDENT_STRING);
                --n2;
            }
            if (!this.m_childTypeStack.isEmpty()) {
                stringBuilder.append(this.m_childTypeStack.pop());
                stringBuilder.append(": ");
            }
            stringBuilder.append(string);
            this.m_printWriter.print(stringBuilder.toString());
            this.m_printWriter.print("\n");
            for (int i = n - 1; i >= 0; --i) {
                this.m_childTypeStack.push("" + i);
            }
        }
    }
}

