/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.support.security;

import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.security.ISecurityContext;
import com.simba.cassandra.support.security.SimbaCredentials;
import com.simba.cassandra.support.security.SimbaSecurityContext;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import sun.security.jgss.GSSUtil;

class SimbaLocalCredentials
extends SimbaCredentials {
    private final boolean m_inbound;
    private final GSSManager m_manager;
    private final ILogger m_logger;
    private GSSCredential m_credential;
    private Subject m_subject;

    SimbaLocalCredentials(ILogger iLogger, GSSManager gSSManager, boolean bl) {
        this.m_inbound = bl;
        this.m_manager = gSSManager;
        this.m_logger = iLogger;
        LogUtilities.logFunctionEntrance(this.m_logger, iLogger, gSSManager);
    }

    @Override
    GSSCredential getCredentialHandle() throws GSSException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_credential) {
            this.DelayAcquireCredentials();
        }
        return this.m_credential;
    }

    @Override
    public ISecurityContext getSecurityContext(String string) throws GSSException {
        LogUtilities.logFunctionEntrance(this.m_logger, string);
        return new SimbaSecurityContext(this, this.m_logger, string, this.m_manager);
    }

    @Override
    public String getName() throws GSSException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_credential) {
            this.DelayAcquireCredentials();
        }
        return this.m_credential.getName().toString();
    }

    @Override
    public Object executeAs(PrivilegedAction privilegedAction) throws Exception {
        if (null == this.m_subject) {
            this.m_subject = GSSUtil.getSubject(this.m_credential.getName(), this.m_credential);
        }
        return Subject.doAsPrivileged(this.m_subject, privilegedAction, null);
    }

    private void DelayAcquireCredentials() throws GSSException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.m_credential = this.m_manager.createCredential(this.m_inbound ? 2 : 1);
        }
        catch (GSSException gSSException) {
            LogUtilities.logError(gSSException, this.m_logger);
            throw gSSException;
        }
        catch (RuntimeException runtimeException) {
            LogUtilities.logError(runtimeException, this.m_logger);
            throw runtimeException;
        }
    }
}

