CHARID="bdsq"
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

	Asset("ANIM", "anim/wilson.zip"),
 	Asset("ANIM", "anim/player_lunge.zip"),
	Asset("ANIM", "anim/player_attack_leap.zip"),
	Asset("ANIM", "anim/player_superjump.zip"),
	Asset( "SOUND" , "sound/banhua.fsb" ),
	Asset( "SOUNDPACKAGE" , "sound/banhua.fev" ),
}
local prefabs = {

}

-- Custom starting items
local start_inv = {
	

}

local canequip ={"torch","hammer",

}

local function NoArmor ( inst, data )
    local item = data.item
	inst:DoTaskInTime(0.5,function()
		if item.components.equippable and item.components.equippable.isequipped == true 
		and item.components.equippable.equipslot == EQUIPSLOTS.HANDS 
		and not table.contains( canequip, item.prefab )
		then

      --  inst:DoTaskInTime(0.1, function()
			GetPlayer().components.inventory:DropItem(item)
		--end) 

		end
	end)
end

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wilson"
	inst.AnimState:SetBuild("wilson")
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "wilson.tex" )
	
	-- Stats	
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(300)
	local damage_mult = 1.5
	-- Damage multiplier (optional)
	if IsDLCEnabled(CAPY_DLC) then 
		inst.components.combat:AddDamageModifier(CHARID, damage_mult)
	else
	 inst.components.combat.damagemultiplier = damage_mult
	end
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst.components.sanity.night_drain_mult = 0.5
	inst.components.sanity.neg_aura_mult = 0.5
	-- Movement speed (optional)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
	
	inst:ListenForEvent("onattackother",function(inst,data)
		inst.components.sanity:DoDelta(2)
	end)
	
	TheInput:AddKeyUpHandler(KEY_R, function()
		if inst.components.sanity.current >= 50 
		and not TheInput:IsKeyDown(KEY_T)
		and not TheInput:IsKeyDown(KEY_F)
		and not TheInput:IsKeyDown(KEY_J)		
		then
			inst.components.sanity:DoDelta(-5)
			inst:DoTaskInTime(0.2,function()
				if TheInput:IsKeyDown(KEY_T) then 
					inst.sg:GoToState("combat_lunge_start") 
				end
				if TheInput:IsKeyDown(KEY_F) 
				and not TheInput:IsKeyDown(KEY_H)
				and not TheInput:IsKeyDown(KEY_K)				
					then 
					inst.components.sanity:DoDelta(-5)
					if TheInput:IsKeyDown(KEY_J) then 
						inst.sg:GoToState("blowdart_special")
					else
						inst.sg:GoToState("combat_leap_start")
					end
				end
			end)
		end
	end)
	inst:ListenForEvent( "equip", NoArmor)
end

return MakePlayerCharacter(CHARID, prefabs, assets, fn, start_inv)
