local assets_crackle =
{
    Asset("ANIM", "anim/lavaarena_hammer_attack_fx.zip"),
}

local prefabs_crackle =
{
    "hammer_mjolnir_cracklebase",
}


local function cracklefn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()


    inst.AnimState:SetBank("lavaarena_hammer_attack_fx")
    inst.AnimState:SetBuild("lavaarena_hammer_attack_fx")
    inst.AnimState:PlayAnimation("crackle_hit")
    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    inst.AnimState:SetFinalOffset(1)

    inst:AddTag("FX")
    inst:AddTag("NOCLICK")
	inst.persists = false
	inst:ListenForEvent("animover", inst.Remove)

    return inst
end

local function cracklebasefn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()


    inst.AnimState:SetBank("lavaarena_hammer_attack_fx")
    inst.AnimState:SetBuild("lavaarena_hammer_attack_fx")
    inst.AnimState:PlayAnimation("crackle_projection")
    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
    inst.AnimState:SetLayer(LAYER_BACKGROUND)
    inst.AnimState:SetSortOrder(3)
    inst.AnimState:SetScale(1.5, 1.5)

    inst:AddTag("FX")
    inst:AddTag("NOCLICK")

    inst.persists = false

	inst:ListenForEvent("animover", inst.Remove)
    return inst
end

local function MakeCrackleHit(name, withsound)
    local function fn()
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        if withsound then
            inst.entity:AddSoundEmitter()
        end

        inst.AnimState:SetBank("lavaarena_hammer_attack_fx")
        inst.AnimState:SetBuild("lavaarena_hammer_attack_fx")
        inst.AnimState:PlayAnimation("crackle_loop")
        inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
        inst.AnimState:SetFinalOffset(1)
        inst.AnimState:SetScale(1.5, 1.5)

        inst:AddTag("FX")
        inst:AddTag("NOCLICK")
		inst.persists = false
		inst:ListenForEvent("animover", inst.Remove)

        return inst
    end

    return Prefab(name, fn, assets_crackle)
end

return Prefab("hammer_mjolnir_crackle", cracklefn, assets_crackle, prefabs_crackle),
    Prefab("hammer_mjolnir_cracklebase", cracklebasefn, assets_crackle),
    MakeCrackleHit("hammer_mjolnir_cracklehit", false),
    MakeCrackleHit("cracklehitfx", true)
