/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.client.update;

import chylex.bettersprinting.client.ClientSettings;
import chylex.bettersprinting.client.update.UpdateNotificationManager;
import chylex.bettersprinting.client.update.VersionEntry;
import chylex.bettersprinting.system.Log;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class UpdateThread
extends Thread {
    private static final String url = "https://raw.githubusercontent.com/chylex/Better-Sprinting/master/UpdateNotificationData.txt";
    private final String modVersion;
    private final String mcVersion;

    public UpdateThread(String modVersion) {
        this.modVersion = modVersion;
        this.mcVersion = "1.8";
        this.setPriority(1);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            StringBuilder message;
            String line;
            StringBuilder build = new StringBuilder();
            BufferedReader read = new BufferedReader(new InputStreamReader(new URL(url).openStream()));
            while ((line = read.readLine()) != null) {
                build.append(line).append('\n');
            }
            read.close();
            JsonElement root = new JsonParser().parse(build.toString());
            ArrayList versionList = Lists.newArrayList();
            VersionEntry newestVersion = null;
            VersionEntry newestVersionForCurrentMC = null;
            int counter = -1;
            String buildId = "";
            boolean isInDev = true;
            String downloadURL = "http://tinyurl.com/better-sprinting-mod";
            Log.debug("Detecting Better Sprinting updates...", new Object[0]);
            for (Map.Entry entry : root.getAsJsonObject().entrySet()) {
                if (((String)entry.getKey()).charAt(0) == '~') {
                    if (!((String)entry.getKey()).substring(1).equals("URL")) continue;
                    downloadURL = ((JsonElement)entry.getValue()).getAsString();
                    continue;
                }
                versionList.add(new VersionEntry((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject()));
            }
            Collections.sort(versionList);
            for (VersionEntry version : versionList) {
                Log.debug("Reading update data: $0", version.versionIdentifier);
                if (newestVersion == null) {
                    newestVersion = version;
                }
                if (version.isSupportedByMC(this.mcVersion)) {
                    if (newestVersionForCurrentMC == null) {
                        newestVersionForCurrentMC = version;
                    }
                    ++counter;
                }
                if (!version.modVersion.equals(this.modVersion)) continue;
                isInDev = false;
                buildId = version.buildId;
                UpdateNotificationManager.refreshUpdateData(version);
                break;
            }
            if (isInDev) {
                Log.debug("In-dev version used, notifications disabled.", new Object[0]);
                return;
            }
            Log.debug("Done.", new Object[0]);
            if (!buildId.isEmpty() && !buildId.equals("22-02-2015-0")) {
                message = new StringBuilder().append(EnumChatFormatting.LIGHT_PURPLE).append(" [Hardcore Ender Expansion ").append(this.modVersion).append("]").append(EnumChatFormatting.RESET).append("\n Caution, you are using a broken build that can cause critical crashes! Please, redownload the mod, or update it if there is an update available.").append("\n\n ").append(EnumChatFormatting.GRAY).append(downloadURL);
                for (String s : message.toString().split("\n")) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(s));
                }
            } else if (counter > 0 && ClientSettings.enableUpdateNotifications) {
                message = new StringBuilder().append(EnumChatFormatting.GREEN).append(" [Better Sprinting ").append(this.modVersion).append("]").append(EnumChatFormatting.RESET).append("\n Found a new version ").append(EnumChatFormatting.GREEN).append(newestVersionForCurrentMC.modVersionName).append(EnumChatFormatting.RESET).append(" for Minecraft ").append(this.mcVersion).append(", released ").append(newestVersionForCurrentMC.releaseDate).append(". You are currently ").append(counter).append(" version").append(counter == 1 ? "" : "s").append(" behind.");
                if (newestVersion != newestVersionForCurrentMC) {
                    message.append("\n\n There is also an update ").append(EnumChatFormatting.GREEN).append(newestVersion.modVersion).append(EnumChatFormatting.RESET).append(" for Minecraft ").append(CommandBase.func_71527_a((Object[])newestVersion.mcVersions)).append('.');
                }
                message.append("\n\n ").append(EnumChatFormatting.GRAY).append(downloadURL);
                for (String s : message.toString().split("\n")) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(s));
                }
            } else if (newestVersion != newestVersionForCurrentMC && ClientSettings.enableUpdateNotifications) {
                message = new StringBuilder().append(EnumChatFormatting.GREEN).append(" [Better Sprinting ").append(this.modVersion).append("]").append(EnumChatFormatting.RESET).append("\n Found a new version ").append(EnumChatFormatting.GREEN).append(newestVersion.modVersion).append(EnumChatFormatting.RESET).append(" for Minecraft ").append(CommandBase.func_71527_a((Object[])newestVersion.mcVersions)).append(", released ").append(newestVersion.releaseDate).append(".");
                for (String s : message.toString().split("\n")) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(s));
                }
            }
        }
        catch (UnknownHostException e) {
        }
        catch (Exception e) {
            Log.throwable(e, "Error detecting updates!", new Object[0]);
        }
    }
}

