/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.server;

import chylex.bettersprinting.BetterSprintingMod;
import chylex.bettersprinting.server.ServerNetwork;
import chylex.bettersprinting.server.ServerSettings;
import chylex.bettersprinting.server.compatibility.OldNotificationPacketReceiver;
import chylex.bettersprinting.system.PacketPipeline;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ServerCommandConfig
extends CommandBase {
    public String func_71517_b() {
        return "bettersprinting";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/bettersprinting [...]";
    }

    public int func_82362_a() {
        return 3;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.sendMessage(sender, EnumChatFormatting.GREEN + "[Better Sprinting]");
            this.sendMessage(sender, "/bettersprinting info");
            this.sendMessage(sender, "/bettersprinting disablemod <true|false>");
            this.sendMessage(sender, "/bettersprinting setting <survivalFlyBoost|runInAllDirs> <true|false>");
        } else if (args[0].equalsIgnoreCase("info")) {
            this.sendMessage(sender, "You can use the command to either disable/enable the mod, or change specific settings of the mod. These will persist after restarting the server, and will also immediately affect players that are already on the server.");
        } else if (args[0].equalsIgnoreCase("disablemod")) {
            if (this.isValidBool(args, 1)) {
                ServerSettings.disableClientMod = this.getBool(args, 1);
                ServerSettings.update(BetterSprintingMod.config);
                this.sendMessage(sender, ServerSettings.disableClientMod ? "Better Sprinting will be automatically disabled when a user joins." : "Better Sprinting is now allowed on the server.");
                PacketPipeline.sendToAll(ServerNetwork.writeDisableMod(ServerSettings.disableClientMod));
                if (ServerSettings.disableClientMod) {
                    OldNotificationPacketReceiver.kickOldModUsers();
                }
            } else {
                this.sendMessage(sender, "Invalid syntax, do /bettersprinting for list of commands.");
            }
        } else if (args[0].equalsIgnoreCase("setting")) {
            if (args.length <= 1 || !this.isValidBool(args, 2)) {
                this.sendMessage(sender, "Invalid syntax, do /bettersprinting for list of commands.");
            } else if (args[1].equalsIgnoreCase("survivalFlyBoost")) {
                ServerSettings.enableSurvivalFlyBoost = this.getBool(args, 2);
                ServerSettings.update(BetterSprintingMod.config);
                this.sendMessage(sender, "Fly boost is now " + (ServerSettings.enableSurvivalFlyBoost ? "enabled" : "disabled") + " when the player is in survival mode.");
                PacketPipeline.sendToAll(ServerNetwork.writeSettings(ServerSettings.enableSurvivalFlyBoost, ServerSettings.enableAllDirs));
            } else if (args[1].equalsIgnoreCase("runInAllDirs")) {
                ServerSettings.enableAllDirs = this.getBool(args, 2);
                ServerSettings.update(BetterSprintingMod.config);
                this.sendMessage(sender, "Sprinting in all directions is now " + (ServerSettings.enableAllDirs ? "enabled." : "disabled."));
                PacketPipeline.sendToAll(ServerNetwork.writeSettings(ServerSettings.enableSurvivalFlyBoost, ServerSettings.enableAllDirs));
            }
        } else {
            this.sendMessage(sender, "Invalid syntax, do /bettersprinting for list of commands.");
        }
    }

    private void sendMessage(ICommandSender sender, String text) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(text));
    }

    private boolean isValidBool(String[] args, int index) {
        if (index >= args.length) {
            return false;
        }
        return args[index].equalsIgnoreCase("true") || args[index].equalsIgnoreCase("false");
    }

    private boolean getBool(String[] args, int index) {
        return args[index].equalsIgnoreCase("true");
    }
}

