/*
 * Decompiled with CFR 0.152.
 */
package chylex.bettersprinting.server.compatibility;

import chylex.bettersprinting.server.ServerSettings;
import gnu.trove.map.hash.TObjectIntHashMap;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class OldNotificationPacketReceiver {
    private static OldNotificationPacketReceiver instance;
    private final FMLEventChannel channel;
    private final TObjectIntHashMap<UUID> users = new TObjectIntHashMap();

    public static void register() {
        instance = new OldNotificationPacketReceiver();
        FMLCommonHandler.instance().bus().register((Object)instance);
    }

    public static void kickOldModUsers() {
        ServerConfigurationManager manager = MinecraftServer.func_71276_C().func_71203_ab();
        for (UUID id : OldNotificationPacketReceiver.instance.users.keySet()) {
            EntityPlayerMP player = manager.func_177451_a(id);
            if (player == null) continue;
            player.field_71135_a.func_147360_c("The server does not allow Better Sprinting. Newer versions of the mod can be disabled automatically without kicking.");
        }
        OldNotificationPacketReceiver.instance.users.clear();
    }

    private OldNotificationPacketReceiver() {
        this.channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("BSprint");
        this.channel.register((Object)this);
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent e) {
        ByteBuf data = e.packet.payload();
        if (data.readByte() == 4) {
            NetHandlerPlayServer net = (NetHandlerPlayServer)e.handler;
            this.users.put((Object)net.field_147369_b.func_110124_au(), 100);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END || !ServerSettings.disableClientMod) {
            return;
        }
        HashSet ids = new HashSet(this.users.keySet());
        for (UUID id : ids) {
            int val = this.users.adjustOrPutValue((Object)id, -1, 0);
            EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_177451_a(id);
            if (player == null) {
                this.users.remove((Object)id);
                continue;
            }
            if (val > 10 && val < 80 && player.field_71135_a.field_147371_a.channel().isWritable()) {
                val = 10;
                this.users.put((Object)id, 10);
            }
            if (val > 0) continue;
            this.users.remove((Object)id);
            player.field_71135_a.func_147360_c("The server does not allow Better Sprinting. Newer versions of the mod can be disabled automatically without kicking.");
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent e) {
        this.users.remove((Object)e.player.func_110124_au());
    }
}

