/*
 * Decompiled with CFR 0.152.
 */
package morph.common.core;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import ichun.common.core.EntityHelperBase;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import morph.api.Ability;
import morph.common.Morph;
import morph.common.ability.AbilityFly;
import morph.common.ability.AbilityHandler;
import morph.common.core.MorphSaveData;
import morph.common.morph.MorphInfo;
import morph.common.morph.MorphState;
import morph.common.packet.PacketCompleteDemorph;
import morph.common.packet.PacketSession;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TickHandlerServer {
    public long clock;
    public boolean purgeSession;
    public MorphSaveData saveData = null;
    public HashMap<String, MorphInfo> playerMorphInfo = new HashMap();
    public HashMap<String, ArrayList<MorphState>> playerMorphs = new HashMap();
    public WeakHashMap<EntityPlayer, ArrayList<MorphState>> saveList = new WeakHashMap();

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        WorldServer world;
        if (event.phase == TickEvent.Phase.END && event.side.isServer() && (this.clock != (world = (WorldServer)event.world).func_72820_D() || !world.func_82736_K().func_82766_b("doDaylightCycle"))) {
            this.clock = world.func_72820_D();
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        MorphInfo info;
        if (event.phase == TickEvent.Phase.END && event.side.isServer() && (info = this.getPlayerMorphInfo(player = event.player)) != null) {
            float prog;
            float f = prog = info.morphProgress > 10 ? (float)info.morphProgress / 60.0f : 0.0f;
            if (prog > 1.0f) {
                prog = 1.0f;
            }
            prog = (float)Math.pow(prog, 2.0);
            float prev = info.prevState != null && !(info.prevState.entInstance instanceof EntityPlayer) ? info.prevState.entInstance.func_70047_e() : player.field_70129_M;
            float next = info.nextState != null && !(info.nextState.entInstance instanceof EntityPlayer) ? info.nextState.entInstance.func_70047_e() : player.field_70129_M;
            double ySize = player.field_70129_M - (prev + (next - prev) * prog);
            player.field_70137_T += ySize;
            player.field_70167_r += ySize;
            player.field_70163_u += ySize;
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Map.Entry<String, MorphInfo>> ite = this.playerMorphInfo.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, MorphInfo> e = ite.next();
                MorphInfo info = e.getValue();
                EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab().func_152612_a(info.playerName);
                if (info.getMorphing()) {
                    ++info.morphProgress;
                    if (info.morphProgress > 80) {
                        info.morphProgress = 80;
                        info.setMorphing(false);
                        if (player != null) {
                            player.func_70105_a(info.nextState.entInstance.field_70130_N, info.nextState.entInstance.field_70131_O);
                            player.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                            player.eyeHeight = info.nextState.entInstance instanceof EntityPlayer ? ((EntityPlayer)info.nextState.entInstance).getDefaultEyeHeight() : info.nextState.entInstance.func_70047_e() - player.field_70129_M;
                            double nextMaxHealth = MathHelper.func_151237_a((double)info.nextState.entInstance.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b(), (double)1.0, (double)20.0) + info.healthOffset;
                            if (nextMaxHealth < 1.0) {
                                nextMaxHealth = 1.0;
                            }
                            if (nextMaxHealth != player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b()) {
                                player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(nextMaxHealth);
                            }
                            ArrayList<Ability> newAbilities = AbilityHandler.getEntityAbilities(info.nextState.entInstance.getClass());
                            ArrayList<Ability> oldAbilities = info.morphAbilities;
                            info.morphAbilities = new ArrayList();
                            for (Ability ability : newAbilities) {
                                try {
                                    Ability clone = ability.clone();
                                    clone.setParent((EntityLivingBase)player);
                                    info.morphAbilities.add(clone);
                                }
                                catch (Exception e1) {}
                            }
                            for (Ability ability : oldAbilities) {
                                if (ability.inactive) continue;
                                boolean isRemoved = true;
                                for (Ability newAbility : info.morphAbilities) {
                                    if (!newAbility.getType().equalsIgnoreCase(ability.getType())) continue;
                                    isRemoved = false;
                                    break;
                                }
                                if (!isRemoved || ability.getParent() == null) continue;
                                ability.kill();
                            }
                        }
                        if (info.nextState.playerMorph.equalsIgnoreCase(e.getKey())) {
                            PacketHandler.sendToAll(Morph.channels, (AbstractPacket)new PacketCompleteDemorph(e.getKey()));
                            for (Ability ability : info.morphAbilities) {
                                if (ability.inactive || ability.getParent() == null) continue;
                                ability.kill();
                            }
                            if (player != null) {
                                this.getMorphDataFromPlayer((EntityPlayer)player).func_82580_o("morphData");
                            }
                            ite.remove();
                        }
                    } else if (info.prevState != null && player != null) {
                        player.func_70105_a(info.prevState.entInstance.field_70130_N + (info.nextState.entInstance.field_70130_N - info.prevState.entInstance.field_70130_N) * ((float)info.morphProgress / 80.0f), info.prevState.entInstance.field_70131_O + (info.nextState.entInstance.field_70131_O - info.prevState.entInstance.field_70131_O) * ((float)info.morphProgress / 80.0f));
                        player.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                        float prevEyeHeight = info.prevState.entInstance instanceof EntityPlayer ? ((EntityPlayer)info.prevState.entInstance).getDefaultEyeHeight() : info.prevState.entInstance.func_70047_e() - player.field_70129_M;
                        float nextEyeHeight = info.nextState.entInstance instanceof EntityPlayer ? ((EntityPlayer)info.nextState.entInstance).getDefaultEyeHeight() : info.nextState.entInstance.func_70047_e() - player.field_70129_M;
                        player.eyeHeight = prevEyeHeight + (nextEyeHeight - prevEyeHeight) * ((float)info.morphProgress / 80.0f);
                        double prevMaxHealth = MathHelper.func_151237_a((double)info.prevState.entInstance.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b(), (double)1.0, (double)20.0);
                        double nextMaxHealth = MathHelper.func_151237_a((double)info.nextState.entInstance.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b(), (double)1.0, (double)20.0);
                        if (prevMaxHealth != nextMaxHealth) {
                            double healthScale = info.preMorphHealth / prevMaxHealth;
                            double prevHealth = info.preMorphHealth;
                            double nextHealth = nextMaxHealth * healthScale;
                            if (healthScale <= 1.0) {
                                float targetHealth = (float)(prevHealth + (nextHealth - prevHealth) * (double)((float)info.morphProgress / 80.0f));
                                if (targetHealth < 1.0f) {
                                    targetHealth = 1.0f;
                                }
                                if ((nextMaxHealth > prevMaxHealth && player.func_110143_aJ() + 0.5f < (float)Math.floor(targetHealth) || prevMaxHealth > nextMaxHealth) && player.func_70089_S()) {
                                    player.func_70606_j(targetHealth);
                                }
                            }
                            double curMaxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
                            double morphMaxHealth = (double)Math.round(prevMaxHealth + (nextMaxHealth - prevMaxHealth) * (double)((float)info.morphProgress / 80.0f)) + info.healthOffset;
                            if (morphMaxHealth < 1.0) {
                                morphMaxHealth = 1.0;
                            }
                            if (morphMaxHealth != curMaxHealth) {
                                player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(morphMaxHealth);
                            }
                        }
                    }
                }
                if (player != null) {
                    if (player.func_70608_bn()) {
                        info.sleeping = true;
                    } else if (info.sleeping) {
                        info.sleeping = false;
                        player.func_70105_a(info.nextState.entInstance.field_70130_N, info.nextState.entInstance.field_70131_O);
                        player.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                        float f = player.eyeHeight = info.nextState.entInstance instanceof EntityPlayer ? ((EntityPlayer)info.nextState.entInstance).getDefaultEyeHeight() : info.nextState.entInstance.func_70047_e() - player.field_70129_M;
                    }
                    if (info.prevState != null) {
                        info.prevState.entInstance.func_145769_d(player.func_145782_y());
                    }
                    if (info.nextState != null) {
                        info.nextState.entInstance.func_145769_d(player.func_145782_y());
                    }
                }
                for (Ability ability : info.morphAbilities) {
                    if (player != null && ability.getParent() == player || player == null && ability.getParent() != null) {
                        if (ability.inactive) continue;
                        ability.tick();
                        if (info.firstUpdate || !(ability instanceof AbilityFly) || player == null) continue;
                        info.flying = player.field_71075_bZ.field_75100_b;
                        continue;
                    }
                    ability.setParent((EntityLivingBase)player);
                }
                info.firstUpdate = false;
            }
            Iterator<Map.Entry<EntityPlayer, ArrayList<MorphState>>> ite1 = this.saveList.entrySet().iterator();
            while (ite1.hasNext()) {
                Map.Entry<EntityPlayer, ArrayList<MorphState>> e = ite1.next();
                NBTTagCompound tag = this.getMorphDataFromPlayer(e.getKey());
                tag.func_74768_a("morphStatesCount", e.getValue().size());
                for (int i = 0; i < e.getValue().size(); ++i) {
                    MorphState state = e.getValue().get(i);
                    tag.func_74782_a("morphState" + i, (NBTBase)state.getTag());
                }
                ite1.remove();
            }
            if (this.purgeSession) {
                this.purgeSession = false;
                this.updateSession(null);
            }
        }
    }

    public MorphState getSelfState(World world, EntityPlayer player) {
        ArrayList<MorphState> list = this.getPlayerMorphs(world, player);
        for (MorphState state : list) {
            if (!state.playerName.equalsIgnoreCase(state.playerMorph)) continue;
            return state;
        }
        return new MorphState(world, player.func_70005_c_(), player.func_70005_c_(), null, world.field_72995_K);
    }

    public ArrayList<MorphState> getPlayerMorphs(World world, EntityPlayer player) {
        String name = player.func_70005_c_();
        ArrayList<MorphState> list = this.playerMorphs.get(name);
        if (list == null) {
            list = new ArrayList();
            this.playerMorphs.put(name, list);
            list.add(0, new MorphState(world, name, name, null, world.field_72995_K));
        }
        boolean found = false;
        for (MorphState state : list) {
            if (!state.playerMorph.equals(name)) continue;
            found = true;
            break;
        }
        if (!found) {
            list.add(0, new MorphState(world, name, name, null, world.field_72995_K));
        }
        this.saveList.put(player, list);
        return list;
    }

    public void removeAllPlayerMorphsExcludingCurrentMorph(EntityPlayer player) {
        this.getMorphDataFromPlayer(player).func_82580_o("morphStatesCount");
    }

    public boolean hasMorphState(EntityPlayer player, MorphState state) {
        ArrayList<MorphState> states = this.getPlayerMorphs(player.field_70170_p, player);
        if (!state.playerMorph.equalsIgnoreCase("")) {
            for (MorphState mState : states) {
                if (!mState.playerMorph.equalsIgnoreCase(state.playerMorph)) continue;
                return true;
            }
        } else {
            for (MorphState mState : states) {
                if (!mState.identifier.equalsIgnoreCase(state.identifier)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateSession(EntityPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(Morph.channels, (AbstractPacket)new PacketSession(player), (EntityPlayer)player);
        } else {
            PacketHandler.sendToAll(Morph.channels, (AbstractPacket)new PacketSession(player));
        }
    }

    public NBTTagCompound getMorphDataFromPlayer(EntityPlayer player) {
        NBTTagCompound tag = EntityHelperBase.getPlayerPersistentData((EntityPlayer)player).func_74775_l("MorphSave");
        EntityHelperBase.getPlayerPersistentData((EntityPlayer)player).func_74782_a("MorphSave", (NBTBase)tag);
        return tag;
    }

    public void setPlayerMorphInfo(EntityPlayer player, MorphInfo info) {
        if (info != null) {
            NBTTagCompound tag1 = new NBTTagCompound();
            info.writeNBT(tag1);
            this.getMorphDataFromPlayer(player).func_74782_a("morphData", (NBTBase)tag1);
            this.playerMorphInfo.put(player.func_70005_c_(), info);
        } else {
            this.getMorphDataFromPlayer(player).func_82580_o("morphData");
            this.playerMorphInfo.remove(player.func_70005_c_());
        }
    }

    public MorphInfo getPlayerMorphInfo(EntityPlayer player) {
        return this.playerMorphInfo.get(player.func_70005_c_());
    }

    public MorphInfo getPlayerMorphInfo(String playerName) {
        return this.playerMorphInfo.get(playerName);
    }
}

