/*
 * Decompiled with CFR 0.152.
 */
package morph.common.thread;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import morph.api.Ability;
import morph.common.Morph;
import morph.common.ability.AbilityHandler;
import morph.common.morph.MorphHandler;
import net.minecraft.entity.EntityLivingBase;

public class ThreadGetOnlineResources
extends Thread {
    public String sitePrefix = "https://raw.github.com/iChun/Morph/master/src/main/resources/assets/morph/mod/";

    public ThreadGetOnlineResources(String prefix) {
        if (!prefix.isEmpty()) {
            this.sitePrefix = prefix;
        }
        this.setName("Morph Online Resource Thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        block41: {
            try {
                InputStreamReader fileIn;
                Map json;
                String data;
                Type mapType;
                Gson gson;
                if (Morph.config.getInt("abilities") == 1) {
                    gson = new Gson();
                    mapType = new TypeToken<Map<String, String[]>>(){}.getType();
                    try {
                        if (Morph.config.getInt("useLocalResources") == 1) {
                            FileInputStream con = new FileInputStream(new File(Morph.configFolder, "AbilitySupport.json"));
                            data = new String(ByteStreams.toByteArray((InputStream)con));
                            ((InputStream)con).close();
                            json = (Map)gson.fromJson(data, mapType);
                        } else {
                            InputStreamReader fileIn2 = new InputStreamReader(new URL(this.sitePrefix + "AbilitySupport.json").openStream());
                            json = (Map)gson.fromJson((Reader)fileIn2, mapType);
                            ((Reader)fileIn2).close();
                        }
                    }
                    catch (Exception e) {
                        if (Morph.config.getInt("useLocalResources") == 1) {
                            Morph.console("Failed to retrieve local mod mob ability mappings.", true);
                        } else {
                            Morph.console("Failed to retrieve mod mob ability mappings from " + (Morph.config.getString("customPatchLink").isEmpty() ? "GitHub!" : this.sitePrefix), true);
                        }
                        e.printStackTrace();
                        fileIn = new InputStreamReader(Morph.class.getResourceAsStream("/assets/morph/mod/AbilitySupport.json"));
                        json = (Map)gson.fromJson((Reader)fileIn, mapType);
                        ((Reader)fileIn).close();
                    }
                    if (json != null) {
                        int mcMappings = 0;
                        for (Map.Entry e : json.entrySet()) {
                            try {
                                Class<?> entityClass;
                                Class.forName((String)e.getKey());
                                ArrayList<Ability> abilityObjs = new ArrayList<Ability>();
                                for (String ability : (String[])e.getValue()) {
                                    boolean hasArgs;
                                    block40: {
                                        hasArgs = false;
                                        if (ability == null) continue;
                                        if (ability.contains("|")) {
                                            ArrayList<String> argVars = new ArrayList<String>();
                                            hasArgs = true;
                                            String args = ability.split("\\|")[1];
                                            ability = ability.split("\\|")[0];
                                            if (args.contains(",")) {
                                                for (String arg : args.split(",")) {
                                                    argVars.add(arg.trim());
                                                }
                                            } else {
                                                argVars.add(args.trim());
                                            }
                                            try {
                                                Class<? extends Ability> abilityClass = AbilityHandler.stringToClassMap.get(ability);
                                                if (abilityClass != null) {
                                                    Ability ab = abilityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                                    try {
                                                        ab.parse(argVars.toArray(new String[0]));
                                                    }
                                                    catch (Exception e2) {
                                                        Morph.console("Mappings are erroring! These mappings are probably invalid or outdated: " + abilityClass.getName() + ", " + ability + ", args: " + args, true);
                                                    }
                                                    abilityObjs.add(ab);
                                                    break block40;
                                                }
                                                Morph.console("Ability \"" + ability + "\" does not exist for: " + (String)e.getKey() + ", args: " + args, true);
                                            }
                                            catch (Exception e2) {
                                                e2.printStackTrace();
                                            }
                                        }
                                    }
                                    if (ability.isEmpty() || hasArgs) continue;
                                    Class<? extends Ability> abilityClass = AbilityHandler.stringToClassMap.get(ability);
                                    if (abilityClass != null) {
                                        try {
                                            abilityObjs.add(abilityClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                                        }
                                        catch (Exception e2) {
                                            e2.printStackTrace();
                                        }
                                        continue;
                                    }
                                    Morph.console("Ability \"" + ability + "\" does not exist for: " + (String)e.getKey(), true);
                                }
                                if (abilityObjs.size() <= 0 || (entityClass = Class.forName((String)e.getKey())) == null) continue;
                                if (AbilityHandler.abilityMap.containsKey(entityClass)) {
                                    Morph.console("Ignoring ability mapping for " + (String)e.getKey() + "! Already has abilities mapped!", true);
                                    continue;
                                }
                                if (entityClass.getName().startsWith("net.minecraft")) {
                                    ++mcMappings;
                                } else {
                                    StringBuilder sb = new StringBuilder();
                                    sb.append("Adding ability mappings ");
                                    for (int i = 0; i < abilityObjs.size(); ++i) {
                                        Ability a = (Ability)abilityObjs.get(i);
                                        sb.append(a.getType());
                                        if (i == abilityObjs.size() - 1) continue;
                                        sb.append(", ");
                                    }
                                    sb.append(" to ");
                                    sb.append(entityClass);
                                    Morph.console(sb.toString(), false);
                                }
                                AbilityHandler.mapAbilities(entityClass, abilityObjs.toArray(new Ability[0]));
                            }
                            catch (ClassNotFoundException e1) {}
                        }
                        Morph.console("Found and mapped ability mappings for " + mcMappings + " presumably Minecraft mobs.", false);
                    }
                }
                if (Morph.config.getInt("NBTStripper") != 1) break block41;
                gson = new Gson();
                mapType = new TypeToken<Map<String, String[]>>(){}.getType();
                try {
                    if (Morph.config.getInt("useLocalResources") == 1) {
                        FileInputStream con = new FileInputStream(new File(Morph.configFolder, "NBTStripper.json"));
                        data = new String(ByteStreams.toByteArray((InputStream)con));
                        ((InputStream)con).close();
                        json = (Map)gson.fromJson(data, mapType);
                    } else {
                        InputStreamReader fileIn3 = new InputStreamReader(new URL(this.sitePrefix + "NBTStripper.json").openStream());
                        json = (Map)gson.fromJson((Reader)fileIn3, mapType);
                        ((Reader)fileIn3).close();
                    }
                }
                catch (Exception e) {
                    if (Morph.config.getInt("useLocalResources") == 1) {
                        Morph.console("Failed to retrieve local NBT stripper mappings.", true);
                    } else {
                        Morph.console("Failed to retrieve NBT stripper mappings from " + (Morph.config.getString("customPatchLink").isEmpty() ? "GitHub!" : this.sitePrefix), true);
                    }
                    e.printStackTrace();
                    fileIn = new InputStreamReader(Morph.class.getResourceAsStream("/assets/morph/mod/NBTStripper.json"));
                    json = (Map)gson.fromJson((Reader)fileIn, mapType);
                    ((Reader)fileIn).close();
                }
                if (json != null) {
                    for (Map.Entry e : json.entrySet()) {
                        try {
                            ThreadGetOnlineResources.addStripperMappings(Class.forName((String)e.getKey()), (String[])e.getValue());
                        }
                        catch (Exception e1) {}
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addStripperMappings(Class<? extends EntityLivingBase> clz, String ... tagNames) {
        ArrayList<String> mappings = MorphHandler.getNBTTagsToStrip(clz);
        for (String tagName : tagNames) {
            if (mappings.contains(tagName)) continue;
            mappings.add(tagName);
        }
    }
}

