﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using Harmony12;
using UnityModManagerNet;
using UnityEngine;
using UnityEngine.UI;
using UnityEngine.EventSystems;

namespace LightningRod
{

    public class Settings : UnityModManager.ModSettings
    {
        public bool LightningRod = true;
        public override void Save(UnityModManager.ModEntry modEntry)
        {
            Save(this, modEntry);
        }

    }


    public static class Main
    {
        public static bool enabled;
        public static Settings settings;
        public static UnityModManager.ModEntry.ModLogger Logger;

        public static bool Load(UnityModManager.ModEntry modEntry)
        {
            var harmony = HarmonyInstance.Create(modEntry.Info.Id);
            harmony.PatchAll(Assembly.GetExecutingAssembly());

            settings = Settings.Load<Settings>(modEntry);

            Logger = modEntry.Logger;

            modEntry.OnToggle = OnToggle;
            modEntry.OnGUI = OnGUI;
            modEntry.OnSaveGUI = OnSaveGUI;

            return true;
        }

        public static bool OnToggle(UnityModManager.ModEntry modEntry, bool value)
        {
            if (!value)
                return false;

            enabled = value;

            return true;
        }

        static void OnGUI(UnityModManager.ModEntry modEntry)
        {
            bool flag = DateFile.instance == null || DateFile.instance.actorsDate == null || !DateFile.instance.actorsDate.ContainsKey(DateFile.instance.mianActorId);
            GUILayout.BeginHorizontal();
            Main.settings.LightningRod = GUILayout.Toggle(settings.LightningRod, "安装避雷针", new GUILayoutOption[0]);
            GUILayout.EndHorizontal();
            
        }

        static void OnSaveGUI(UnityModManager.ModEntry modEntry)
        {
            settings.Save(modEntry);
        }

    }


   
    [HarmonyPatch(typeof(PeopleLifeAI), "DoTrunAIChange")]
    public static class PeopleLifeAI_DoTrunAIChange_Patch
    {

        private static void Postfix(ref int __result)
        {
            if (!Main.enabled||!Main.settings.LightningRod)
            {
                return;
            }

            __result = -1;
        }

    }

}