/*
 * Decompiled with CFR 0.152.
 */
package cz.autel.dmi;

import cz.autel.dmi.HIGConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;

public class HIGLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 1L;
    private int[] colWidths;
    private int[] rowHeights;
    private int colCount;
    private int rowCount;
    private ArrayList<Component>[] colComponents;
    private ArrayList<Component>[] rowComponents;
    private int[] widenWeights;
    private int[] heightenWeights;
    private int[] preferredWidths;
    private int[] preferredHeights;
    private int widenWeightsSum = 0;
    private int heightenWeightsSum = 0;
    private static final int invisible = 0;
    private HashMap<Component, HIGConstraints> components = new HashMap();
    private int[] cacheColumnsX;
    private int[] cacheRowsY;
    private Dimension cachePreferredLayoutSize;
    private Dimension cacheMinimumLayoutSize;

    public HIGLayout(int[] widths, int[] heights) {
        this.colCount = widths.length;
        this.rowCount = heights.length;
        this.colWidths = new int[this.colCount + 1];
        System.arraycopy(widths, 0, this.colWidths, 1, this.colCount);
        this.rowHeights = new int[this.rowCount + 1];
        System.arraycopy(heights, 0, this.rowHeights, 1, this.rowCount);
        this.widenWeights = new int[this.colCount + 1];
        this.heightenWeights = new int[this.rowCount + 1];
        this.preferredWidths = new int[this.colCount + 1];
        this.preferredHeights = new int[this.rowCount + 1];
        this.colComponents = new ArrayList[this.colCount + 1];
        this.rowComponents = new ArrayList[this.rowCount + 1];
    }

    private Object reallocArray(Object src, int newSize) {
        Object dest = Array.newInstance(src.getClass().getComponentType(), newSize);
        System.arraycopy(src, 0, dest, 0, Array.getLength(src));
        return dest;
    }

    public void setColumnWidth(int col, int width) {
        if (this.colCount < col) {
            this.colCount = col;
        }
        if (this.colWidths.length <= col) {
            this.colWidths = (int[])this.reallocArray(this.colWidths, this.colCount + 3);
            this.widenWeights = (int[])this.reallocArray(this.widenWeights, this.colCount + 3);
            this.colComponents = (ArrayList[])this.reallocArray(this.colComponents, this.colCount + 3);
            this.preferredWidths = (int[])this.reallocArray(this.preferredWidths, this.colCount + 3);
        }
        this.colWidths[col] = width;
    }

    public void setRowHeight(int row, int height) {
        if (this.rowCount < row) {
            this.rowCount = row;
        }
        if (this.rowHeights.length <= row) {
            this.rowHeights = (int[])this.reallocArray(this.rowHeights, this.rowCount + 3);
            this.heightenWeights = (int[])this.reallocArray(this.heightenWeights, this.rowCount + 3);
            this.rowComponents = (ArrayList[])this.reallocArray(this.rowComponents, this.rowCount + 3);
        }
        this.rowHeights[row] = height;
    }

    public void setPreferredColumnWidth(int col, int width) {
        if (col > this.colCount) {
            throw new IllegalArgumentException("Column index cannot be greater then " + this.colCount + ".");
        }
        this.preferredWidths[col] = width;
    }

    public void setPreferredRowHeight(int row, int height) {
        if (row > this.rowCount) {
            throw new IllegalArgumentException("Column index cannot be greater then " + this.rowCount + ".");
        }
        this.preferredHeights[row] = height;
    }

    public void setColumnWeight(int col, int weight) {
        if (col > this.colCount) {
            throw new RuntimeException("Column index cannot be greater then " + this.colCount + ".");
        }
        this.widenWeights[col] = weight;
        this.widenWeightsSum = 0;
        for (int i = 1; i <= this.colCount; ++i) {
            this.widenWeightsSum += this.widenWeights[i];
        }
    }

    public void setRowWeight(int row, int weight) {
        if (row > this.rowCount) {
            throw new RuntimeException("Column index cannot be greater then " + this.rowCount + ".");
        }
        this.heightenWeights[row] = weight;
        this.heightenWeightsSum = 0;
        for (int i = 1; i <= this.rowCount; ++i) {
            this.heightenWeightsSum += this.heightenWeights[i];
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            HIGConstraints c = this.components.remove(comp);
            if (c == null) {
                return;
            }
            if (this.colComponents[c.x] != null) {
                this.colComponents[c.x].remove(comp);
            }
            if (this.rowComponents[c.y] != null) {
                this.rowComponents[c.y].remove(comp);
            }
        }
    }

    private void solveCycles(int[] g, int[] lengths) {
        int[] path = new int[g.length];
        int stackptr = 0;
        byte[] visited = new byte[g.length];
        for (int i = g.length - 1; i > 0; --i) {
            int last;
            if (g[i] >= 0 || visited[i] != 0) continue;
            int current = i;
            stackptr = 0;
            int maxLength = 0;
            do {
                maxLength = lengths[current] > maxLength ? lengths[current] : maxLength;
                path[stackptr++] = current;
                visited[current] = 1;
                last = current;
            } while ((current = -g[current]) > 0 && visited[current] == 0);
            if (current <= 0) {
                maxLength = lengths[last];
            } else if (current == 0) {
                maxLength = lengths[last];
            } else if (visited[current] == 1) {
                int start = current;
                maxLength = 0;
                do {
                    int n = maxLength = lengths[current] > maxLength ? lengths[current] : maxLength;
                } while (start != (current = -g[current]));
            } else if (visited[current] == 2) {
                maxLength = lengths[current];
            } else {
                throw new RuntimeException("This should not happen.");
            }
            while (stackptr > 0) {
                lengths[path[--stackptr]] = maxLength;
                visited[path[stackptr]] = 2;
            }
        }
    }

    private int[] calcMinWidths() {
        int[] widths = new int[this.colCount + 1];
        for (int i = 1; i <= this.colCount; ++i) {
            if (this.colWidths[i] > 0) {
                widths[i] = this.colWidths[i];
                continue;
            }
            ArrayList<Component> iComps = this.colComponents[i];
            int maxWidth = 0;
            if (iComps != null) {
                for (int j = iComps.size() - 1; j > -1; --j) {
                    int width;
                    Component c = iComps.get(j);
                    int n = width = c.isVisible() ? c.getMinimumSize().width : 0;
                    if (width > 0) {
                        HIGConstraints constr = this.components.get(c);
                        width = constr.w < 0 ? -constr.w : (width += constr.wCorrection);
                    }
                    maxWidth = width > maxWidth ? width : maxWidth;
                }
            }
            widths[i] = maxWidth;
        }
        this.solveCycles(this.colWidths, widths);
        return widths;
    }

    private int[] calcMinHeights() {
        int[] heights = new int[this.rowCount + 1];
        for (int i = 1; i <= this.rowCount; ++i) {
            if (this.rowHeights[i] > 0) {
                heights[i] = this.rowHeights[i];
                continue;
            }
            int maxHeight = 0;
            ArrayList<Component> iComps = this.rowComponents[i];
            if (iComps != null) {
                for (int j = iComps.size() - 1; j > -1; --j) {
                    int height;
                    Component c = iComps.get(j);
                    int n = height = c.isVisible() ? c.getMinimumSize().height : 0;
                    if (height > 0) {
                        HIGConstraints constr = this.components.get(c);
                        height = constr.h < 0 ? -constr.h : (height += constr.hCorrection);
                    }
                    maxHeight = height > maxHeight ? height : maxHeight;
                }
            }
            heights[i] = maxHeight;
        }
        this.solveCycles(this.rowHeights, heights);
        return heights;
    }

    private int[] calcPreferredWidths() {
        int[] widths = new int[this.colCount + 1];
        for (int i = 1; i <= this.colCount; ++i) {
            if (this.colWidths[i] > 0) {
                widths[i] = this.colWidths[i];
                continue;
            }
            if (this.preferredWidths[i] > 0) {
                widths[i] = this.preferredWidths[i];
                continue;
            }
            int maxWidth = 0;
            ArrayList<Component> iComps = this.colComponents[i];
            if (iComps != null) {
                for (int j = iComps.size() - 1; j > -1; --j) {
                    int width;
                    Component c = iComps.get(j);
                    int n = width = c.isVisible() ? c.getPreferredSize().width : 0;
                    if (width > 0) {
                        HIGConstraints constr = this.components.get(c);
                        width = constr.w < 0 ? -constr.w : (width += constr.wCorrection);
                    }
                    maxWidth = width > maxWidth ? width : maxWidth;
                }
            }
            widths[i] = maxWidth;
        }
        this.solveCycles(this.colWidths, widths);
        return widths;
    }

    private int[] calcPreferredHeights() {
        int[] heights = new int[this.rowCount + 1];
        for (int i = 1; i <= this.rowCount; ++i) {
            if (this.rowHeights[i] > 0) {
                heights[i] = this.rowHeights[i];
                continue;
            }
            if (this.preferredHeights[i] > 0) {
                heights[i] = this.preferredHeights[i];
                continue;
            }
            ArrayList<Component> iComps = this.rowComponents[i];
            int maxHeight = 0;
            if (iComps != null) {
                for (int j = iComps.size() - 1; j >= 0; --j) {
                    int height;
                    Component c = iComps.get(j);
                    int n = height = c.isVisible() ? c.getPreferredSize().height : 0;
                    if (height > 0) {
                        HIGConstraints constr = this.components.get(c);
                        height = constr.h < 0 ? -constr.h : (height += constr.hCorrection);
                    }
                    maxHeight = height > maxHeight ? height : maxHeight;
                }
            }
            heights[i] = maxHeight;
        }
        this.solveCycles(this.rowHeights, heights);
        return heights;
    }

    private void distributeSizeDifference(int desiredLength, int[] lengths, int[] minLengths, int[] weights, int weightSum) {
        int preferred = 0;
        for (int i = lengths.length - 1; i > 0; --i) {
            preferred += lengths[i];
        }
        double unit = (double)(desiredLength - preferred) / (double)weightSum;
        for (int i = lengths.length - 1; i > 0; --i) {
            int newLength = lengths[i] + (int)(unit * (double)weights[i]);
            lengths[i] = newLength > minLengths[i] ? newLength : minLengths[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int i;
            if (this.cachePreferredLayoutSize != null) {
                return this.cachePreferredLayoutSize;
            }
            int[] prefColWidths = this.calcPreferredWidths();
            int[] prefRowHeights = this.calcPreferredHeights();
            Insets insets = target.getInsets();
            int w = insets.left + insets.right;
            int h = insets.top + insets.bottom;
            for (i = 1; i <= this.colCount; ++i) {
                w += prefColWidths[i];
            }
            for (i = 1; i <= this.rowCount; ++i) {
                h += prefRowHeights[i];
            }
            this.cachePreferredLayoutSize = new Dimension(w, h);
            return this.cachePreferredLayoutSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int i;
            if (this.cacheMinimumLayoutSize != null) {
                return this.cacheMinimumLayoutSize;
            }
            int[] minColWidths = this.calcMinWidths();
            int[] minRowHeights = this.calcMinHeights();
            Insets insets = target.getInsets();
            int w = insets.left + insets.right;
            int h = insets.top + insets.bottom;
            for (i = 1; i <= this.colCount; ++i) {
                w += minColWidths[i];
            }
            for (i = 1; i <= this.rowCount; ++i) {
                h += minRowHeights[i];
            }
            this.cacheMinimumLayoutSize = new Dimension(w, h);
            return this.cacheMinimumLayoutSize;
        }
    }

    int[] getColumnsX(int targetWidth, Insets insets) {
        if (this.cacheColumnsX != null) {
            return this.cacheColumnsX;
        }
        int[] prefColWidths = this.calcPreferredWidths();
        int[] minColWidths = this.calcMinWidths();
        this.distributeSizeDifference(targetWidth, prefColWidths, minColWidths, this.widenWeights, this.widenWeightsSum);
        int[] x = new int[this.colCount + 2];
        x[1] = insets == null ? 0 : insets.left;
        for (int i = 2; i <= this.colCount + 1; ++i) {
            x[i] = x[i - 1] + prefColWidths[i - 1];
        }
        this.cacheColumnsX = x;
        return x;
    }

    int[] getRowsY(int targetHeight, Insets insets) {
        if (this.cacheRowsY != null) {
            return this.cacheRowsY;
        }
        int[] prefRowHeights = this.calcPreferredHeights();
        int[] minRowHeights = this.calcMinHeights();
        this.distributeSizeDifference(targetHeight, prefRowHeights, minRowHeights, this.heightenWeights, this.heightenWeightsSum);
        int[] y = new int[this.rowCount + 2];
        y[1] = insets == null ? 0 : insets.top;
        for (int i = 2; i <= this.rowCount + 1; ++i) {
            y[i] = y[i - 1] + prefRowHeights[i - 1];
        }
        this.cacheRowsY = y;
        return y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dimSize = target.getSize();
            int sizeWidth = dimSize.width;
            int sizeHeight = dimSize.height;
            Insets insets = target.getInsets();
            int[] x = this.getColumnsX(sizeWidth -= insets.left + insets.right, insets);
            int[] y = this.getRowsY(sizeHeight -= insets.top + insets.bottom, insets);
            Component[] comps = target.getComponents();
            for (int i = comps.length - 1; i >= 0; --i) {
                int cellh;
                int cellw;
                Component comp = comps[i];
                HIGConstraints c = this.components.get(comp);
                if (c == null) continue;
                Dimension dimPref = comp.getPreferredSize();
                int width = dimPref.width;
                int height = dimPref.height;
                if (c.w < 0) {
                    width = -c.w;
                    cellw = x[c.x + 1] - x[c.x];
                } else {
                    width += c.wCorrection;
                    cellw = x[c.x + c.w] - x[c.x];
                }
                if (c.h < 0) {
                    height = -c.h;
                    cellh = y[c.y + 1] - y[c.y];
                } else {
                    height += c.hCorrection;
                    cellh = y[c.y + c.h] - y[c.y];
                }
                boolean allowXSize = true;
                boolean allowYSize = true;
                float dw = (float)(cellw - width) / 2.0f;
                float dh = (float)(cellh - height) / 2.0f;
                float compx = (float)x[c.x] + dw;
                float compy = (float)y[c.y] + dh;
                String anchor = c.anchor;
                boolean xSize = false;
                boolean ySize = false;
                for (int j = anchor.length() - 1; j >= 0; --j) {
                    if (anchor.charAt(j) == 'l') {
                        compx = x[c.x];
                        if (xSize && allowXSize) {
                            width = cellw;
                        }
                        xSize = true;
                        continue;
                    }
                    if (anchor.charAt(j) == 'r') {
                        if (xSize && allowXSize) {
                            width = cellw;
                        } else {
                            compx += dw;
                        }
                        xSize = true;
                        continue;
                    }
                    if (anchor.charAt(j) == 't') {
                        compy = y[c.y];
                        if (ySize && allowYSize) {
                            height = cellh;
                        }
                        ySize = true;
                        continue;
                    }
                    if (anchor.charAt(j) == 'b') {
                        if (ySize && allowYSize) {
                            height = cellh;
                        } else {
                            compy += dh;
                        }
                        ySize = true;
                        continue;
                    }
                    throw new RuntimeException("Wrong character in anchor.");
                }
                comp.setBounds((int)compx + c.xCorrection, (int)compy + c.yCorrection, width, height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            HIGConstraints constr = (HIGConstraints)constraints;
            if (constr.x > this.colCount) {
                throw new RuntimeException("Column index in constraint object cannot be greater then " + this.colCount + ".");
            }
            if (constr.x + constr.w - 1 > this.colCount) {
                throw new RuntimeException("Width in constraint object cannot be greater then " + (this.colCount - constr.x + 1) + ".");
            }
            if (constr.y > this.rowCount) {
                throw new RuntimeException("Row index in constraint object cannot be greater then " + this.rowCount + ".");
            }
            if (constr.y + constr.h - 1 > this.rowCount) {
                throw new RuntimeException("Height in constraint object cannot be greater then " + (this.rowCount - constr.y + 1) + ".");
            }
            if (constr.w == 1) {
                if (this.colComponents[constr.x] == null) {
                    this.colComponents[constr.x] = new ArrayList(3);
                }
                this.colComponents[constr.x].add(comp);
            }
            if (constr.h == 1) {
                if (this.rowComponents[constr.y] == null) {
                    this.rowComponents[constr.y] = new ArrayList(3);
                }
                this.rowComponents[constr.y].add(comp);
            }
            this.components.put(comp, new HIGConstraints(constr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.cacheColumnsX = null;
        this.cacheRowsY = null;
        this.cachePreferredLayoutSize = null;
        this.cacheMinimumLayoutSize = null;
    }
}

