/*
 * Decompiled with CFR 0.152.
 */
package rasterviewer;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;
import rasterviewer.ImageRendererPanel;
import rasterviewer.ImageSizeInfo;
import rasterviewer.event.HotspotEvent;
import rasterviewer.event.HotspotListener;
import rasterviewer.hotspot.IHotspotManager;

public class ImageViewerComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int QUALITY_FASTEST = 1;
    public static final int QUALITY_GOOD = 2;
    public static final int QUALITY_BEST = 3;
    boolean showHotspotRollover = false;
    Image zoomInImage = new ImageIcon(this.getClass().getResource("zoominmouse.gif")).getImage();
    Image zoomOutImage = new ImageIcon(this.getClass().getResource("zoomout.gif")).getImage();
    private boolean hackIsResizing = false;
    private ImageRendererPanel paintPanel;
    private Image image;
    private JToolBar toolbar;
    public JScrollBar sbRight;
    public JScrollBar sbDown;
    private int mouseStartX;
    private int mouseStartY;
    private int mouseEndX;
    private int mouseEndY;
    private int mode;
    private int scrollDownOldValue;
    private int scrollRightOldValue;
    private int oldSizeX;
    private int oldSizeY;
    private int scrollbarHeight;
    public static final int MOVE_MODE = 1;
    public static final int ZOOM_MODE = 2;
    public static final int ZOOM_IN = 3;
    public static final int QUITE_MODE = 4;
    private boolean isCurrentlyDragging = false;
    private boolean mWantscrollbar;
    private boolean mToolbarDown;
    private boolean mNoToolbar;
    IHotspotManager hotspotMgr;

    public ImageViewerComponent(IHotspotManager hotspotMgr, JFrame containingFrame) {
        this.hotspotMgr = hotspotMgr;
        this.mWantscrollbar = true;
        this.mToolbarDown = false;
        this.init();
        this.paintPanel.setHotspotManager(hotspotMgr);
    }

    public ImageViewerComponent(IHotspotManager hotspotMgr, JToolBar toolbar, JFrame containingFrame) {
        this.hotspotMgr = hotspotMgr;
        this.mWantscrollbar = true;
        this.mToolbarDown = false;
        this.mNoToolbar = false;
        this.init();
        this.setToolbar(toolbar);
        this.paintPanel.setHotspotManager(hotspotMgr);
    }

    public ImageViewerComponent(IHotspotManager hotspotMgr, JFrame containingFrame, boolean wantscrolbar) {
        this.hotspotMgr = hotspotMgr;
        this.mWantscrollbar = wantscrolbar;
        this.mToolbarDown = false;
        this.mNoToolbar = true;
        this.init();
        this.paintPanel.setHotspotManager(hotspotMgr);
    }

    public ImageViewerComponent(IHotspotManager hotspotMgr, JFrame containingFrame, boolean wantscrolbar, boolean toolbarDown) {
        this.hotspotMgr = hotspotMgr;
        this.mWantscrollbar = wantscrolbar;
        this.mNoToolbar = false;
        this.mToolbarDown = toolbarDown;
        this.init();
        this.paintPanel.setHotspotManager(hotspotMgr);
    }

    private void init() {
        int[] w = new int[]{0, 0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout layout = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        if (!this.mToolbarDown) {
            layout.setColumnWeight(1, 1);
            layout.setRowWeight(2, 1);
            this.setLayout(layout);
            this.paintPanel = new ImageRendererPanel(this);
            this.add((Component)this.paintPanel, c.rc(2, 1, "lrtb"));
        } else {
            layout.setColumnWeight(1, 1);
            layout.setRowWeight(1, 1);
            this.setLayout(layout);
            this.paintPanel = new ImageRendererPanel(this);
            this.add((Component)this.paintPanel, c.rc(1, 1, "lrtb"));
        }
        this.paintPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                boolean mustIssueRepaint = false;
                if (ImageViewerComponent.this.isCurrentlyDragging) {
                    mustIssueRepaint = true;
                }
                ImageViewerComponent.this.isCurrentlyDragging = false;
                if (ImageViewerComponent.this.mode == 2) {
                    ImageViewerComponent.this.mouseEndX = e.getX();
                    ImageViewerComponent.this.mouseEndY = e.getY();
                    ImageViewerComponent.this.paintPanel.drawRubberBand(ImageViewerComponent.this.mouseStartX, ImageViewerComponent.this.mouseStartY, ImageViewerComponent.this.mouseEndX, ImageViewerComponent.this.mouseEndY, true);
                    ImageViewerComponent.this.paintPanel.zoomIn(ImageViewerComponent.this.mouseStartX, ImageViewerComponent.this.mouseStartY, ImageViewerComponent.this.mouseEndX, ImageViewerComponent.this.mouseEndY);
                    mustIssueRepaint = false;
                }
                if (mustIssueRepaint) {
                    ImageViewerComponent.this.paintPanel.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (ImageViewerComponent.this.mode == 2) {
                    ImageViewerComponent.this.mouseStartX = e.getX();
                    ImageViewerComponent.this.mouseStartY = e.getY();
                    ImageViewerComponent.this.paintPanel.initRubberband();
                } else if (ImageViewerComponent.this.mode == 1) {
                    ImageViewerComponent.this.mouseStartX = e.getX();
                    ImageViewerComponent.this.mouseStartY = e.getY();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ImageViewerComponent.this.mode == 3) {
                    ImageViewerComponent.this.zoomIn(e);
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }
        });
        this.paintPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                ImageViewerComponent.this.isCurrentlyDragging = true;
                ImageViewerComponent.this.mouseEndX = e.getX();
                ImageViewerComponent.this.mouseEndY = e.getY();
                if (ImageViewerComponent.this.mode == 2) {
                    ImageViewerComponent.this.paintPanel.drawRubberBand(ImageViewerComponent.this.mouseStartX, ImageViewerComponent.this.mouseStartY, ImageViewerComponent.this.mouseEndX, ImageViewerComponent.this.mouseEndY, false);
                } else if (ImageViewerComponent.this.mode == 1) {
                    ImageViewerComponent.this.paintPanel.moveImage(ImageViewerComponent.this.mouseEndX - ImageViewerComponent.this.mouseStartX, ImageViewerComponent.this.mouseEndY - ImageViewerComponent.this.mouseStartY);
                    ImageViewerComponent.this.mouseStartX = ImageViewerComponent.this.mouseEndX;
                    ImageViewerComponent.this.mouseStartY = ImageViewerComponent.this.mouseEndY;
                }
            }
        });
        this.sbRight = new JScrollBar(1);
        this.sbDown = new JScrollBar(0);
        this.sbDown.setVisible(false);
        this.sbRight.setVisible(false);
        if (this.mWantscrollbar) {
            this.add((Component)this.sbRight, c.rc(2, 2, "lrtb"));
            this.add((Component)this.sbDown, c.rc(3, 1, "lrtb"));
        }
        this.scrollbarHeight = this.sbDown.getPreferredSize().height;
        this.sbRight.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ImageViewerComponent.this.onScrollRight(e);
            }
        });
        this.sbDown.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ImageViewerComponent.this.onScrollDown(e);
            }
        });
        this.hotspotMgr.addHotspotListener(new HotspotListener(){

            @Override
            public void mouseClicked(HotspotEvent e) {
                if (e.getHotspot() == null) {
                    // empty if block
                }
            }

            @Override
            public void mouseEntered(HotspotEvent e) {
                if (e.getHotspot() == null || !ImageViewerComponent.this.showHotspotRollover) {
                    return;
                }
                ImageViewerComponent.this.paintPanel.showHotspot(ImageViewerComponent.this.paintPanel.getGraphics(), e.getHotspot());
            }

            @Override
            public void mouseExited(HotspotEvent e) {
                if (ImageViewerComponent.this.showHotspotRollover) {
                    ImageViewerComponent.this.paintPanel.repaint();
                }
            }

            @Override
            public void mousePressed(HotspotEvent e) {
            }

            @Override
            public void mouseReleased(HotspotEvent e) {
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                ImageViewerComponent.this.paintPanel.onResize(ImageViewerComponent.this.getWidth(), ImageViewerComponent.this.getHeight(), ImageViewerComponent.this.oldSizeX, ImageViewerComponent.this.oldSizeY);
                ImageViewerComponent.this.oldSizeX = ImageViewerComponent.this.getWidth();
                ImageViewerComponent.this.oldSizeY = ImageViewerComponent.this.getHeight();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    protected void onScrollRight(AdjustmentEvent e) {
        if (this.hackIsResizing) {
            return;
        }
        int t = e.getValue();
        int val = t - this.scrollRightOldValue;
        if (val == 0) {
            return;
        }
        this.paintPanel.moveImage(0, -val);
        this.scrollRightOldValue = t;
    }

    protected void onScrollDown(AdjustmentEvent e) {
        if (this.hackIsResizing) {
            return;
        }
        int t = e.getValue();
        int val = t - this.scrollDownOldValue;
        if (val == 0) {
            return;
        }
        this.paintPanel.moveImage(-val, 0);
        this.scrollDownOldValue = t;
    }

    public void setToolbar(JToolBar tb) {
        HIGConstraints c = new HIGConstraints();
        this.toolbar = tb;
        if (!this.mToolbarDown) {
            this.add((Component)tb, c.rcwh(1, 1, 2, 1, "tlbr"));
        } else {
            this.add((Component)tb, c.rcwh(2, 1, 2, 1, "tlbr"));
        }
    }

    protected void imageSizeChanged(ImageSizeInfo evt) {
        this.hackIsResizing = true;
        this.scrollDownOldValue = evt.getXValue();
        this.scrollRightOldValue = evt.getYValue();
        this.sbRight.setValues(evt.getYValue(), evt.getYExtent(), evt.getYMin(), evt.getYMax());
        this.sbDown.setValues(evt.getXValue(), evt.getXExtent(), evt.getXMin(), evt.getXMax());
        this.sbRight.setBlockIncrement((evt.getYMax() - evt.getYMin()) / 6);
        this.sbDown.setBlockIncrement((evt.getXMax() - evt.getXMin()) / 6);
        this.sbRight.setUnitIncrement((evt.getYMax() - evt.getYMin()) / 10);
        this.sbDown.setUnitIncrement((evt.getXMax() - evt.getXMin()) / 10);
        this.hackIsResizing = false;
    }

    public void zoomIn(MouseEvent e) {
        int w = this.getWidth();
        int h = this.getHeight();
        int x = e.getX();
        int y = e.getY();
        this.paintPanel.zoomIn(x - w / 4, y - h / 4, x + w / 4, y + h / 4);
    }

    public void zoomIn() {
        this.mode = 3;
        Cursor c = Toolkit.getDefaultToolkit().createCustomCursor(this.zoomInImage, new Point(3, 3), "zoomIn");
        this.paintPanel.setCursor(c);
    }

    public void zoomFit() {
        this.sbRight.setVisible(false);
        this.sbDown.setVisible(false);
        this.validate();
        this.paintPanel.zoomFit();
    }

    public void zoom100percent() {
        if (this.image != null) {
            if (this.getWidth() < this.image.getWidth(null) || this.getHeight() - this.toolbar.getPreferredSize().height < this.image.getHeight(null)) {
                this.sbRight.setVisible(true);
                this.sbDown.setVisible(true);
            } else {
                this.sbRight.setVisible(false);
                this.sbDown.setVisible(false);
            }
            this.validate();
        }
        this.paintPanel.zoom100percent();
    }

    public void quiteMode() {
        this.mode = 4;
        this.paintPanel.setCursor(Cursor.getDefaultCursor());
    }

    public void moveMode() {
        this.mode = 1;
        this.paintPanel.setCursor(Cursor.getPredefinedCursor(13));
    }

    public void zoomMode() {
        this.mode = 2;
        this.paintPanel.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void setImage(Image img) {
        this.image = img;
        this.paintPanel.setImage(img);
        this.zoomFit();
    }

    public void moveImgSpace(float imgLx, float imgLy) {
        this.paintPanel.moveImgSpace(imgLx, imgLy);
    }

    public void zoomFillscreen() {
        this.sbRight.setVisible(false);
        this.sbDown.setVisible(false);
        this.validate();
        this.paintPanel.zoomFillscreen();
    }

    public Point2D.Float getImageSpaceCoordinates(Point2D screenCoord) {
        return this.paintPanel.getImageSpaceCoordinates(screenCoord);
    }

    public void showHotspots(boolean doShow) {
        this.paintPanel.showHotspots(doShow);
        this.paintPanel.repaint();
    }

    public ImageRendererPanel getRenderer() {
        return this.paintPanel;
    }

    public void showHotspotRollover(boolean doShow) {
        this.showHotspotRollover = doShow;
    }

    public boolean doCreateHotspotEvents() {
        return this.mode != 3;
    }

    public int getRenderQuality() {
        return this.paintPanel.getRenderQuality();
    }

    public void setRenderQuality(int renderQuality) {
        this.paintPanel.setRenderQuality(renderQuality);
    }

    public void refresh() {
        this.repaint();
    }

    public void setScrollbarsVisible(boolean visible) {
        if (this.isCurrentlyDragging && !visible) {
            return;
        }
        if (this.mWantscrollbar) {
            this.sbDown.setVisible(visible);
            this.sbRight.setVisible(visible);
            this.validate();
        }
    }

    public boolean isScrollbarsVisible() {
        return this.sbDown.isVisible();
    }

    public int getRendererWidthNoScrollbars() {
        return this.getWidth();
    }

    public int getRendererHeightNoScrollbars() {
        if (this.mNoToolbar) {
            return this.getHeight();
        }
        return this.getHeight() - this.toolbar.getPreferredSize().height;
    }

    public int getRendererWidthWithScrollbars() {
        return this.getWidth() - this.scrollbarHeight;
    }

    public int getRendererHeightWithScrollbars() {
        if (this.mNoToolbar) {
            return this.getHeight() - this.scrollbarHeight;
        }
        return this.getHeight() - this.toolbar.getPreferredSize().height - this.scrollbarHeight;
    }

    public int getRendererWidthCurrent() {
        if (this.sbDown.isVisible() || this.sbRight.isVisible()) {
            return this.getRendererWidthWithScrollbars();
        }
        return this.getRendererWidthNoScrollbars();
    }

    public int getRendererHeightCurrent() {
        if (this.sbDown.isVisible() || this.sbRight.isVisible()) {
            return this.getRendererHeightWithScrollbars();
        }
        return this.getRendererHeightNoScrollbars();
    }

    public void setHotspotFillColor(Color fillColor) {
        this.paintPanel.setHotspotFillColor(fillColor);
    }

    public void setHotspotFrameColor(Color frameColor) {
        this.paintPanel.setHotspotFrameColor(frameColor);
    }

    public Color getImagePanelBackgroundColor() {
        return this.paintPanel.getBackgroundColor();
    }

    public void setImagePanelBackgroundColor(Color backgroundColor) {
        this.paintPanel.setBackgroundColor(backgroundColor);
    }

    public void setIsCurrentlyResizingHint(boolean isResizing) {
        this.paintPanel.setIsCurrentlyResizingHint(isResizing);
    }

    public ImageRendererPanel getPaintPanel() {
        return this.paintPanel;
    }
}

