/*
 * Decompiled with CFR 0.152.
 */
package rasterviewer.hotspot;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import rasterviewer.ImageViewerComponent;
import rasterviewer.event.HotspotEvent;
import rasterviewer.event.HotspotEventMulticaster;
import rasterviewer.event.HotspotListener;
import rasterviewer.hotspot.Hotspot;
import rasterviewer.hotspot.IHotspot;
import rasterviewer.hotspot.IHotspotManager;

public class HotspotManager
implements IHotspotManager {
    ArrayList<IHotspot> hotspots = new ArrayList();
    HotspotListener listener;
    ImageViewerComponent imageViewer;

    public void setImageViewer(ImageViewerComponent pImageViewer) {
        this.imageViewer = pImageViewer;
        this.imageViewer.getRenderer().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (HotspotManager.this.listener == null) {
                    return;
                }
                if (!HotspotManager.this.imageViewer.doCreateHotspotEvents()) {
                    return;
                }
                IHotspot hotspot = HotspotManager.this.getHotspotUnderMouse(e.getX(), e.getY());
                if (hotspot == null) {
                    return;
                }
                HotspotEvent he = new HotspotEvent(this, hotspot, e);
                HotspotManager.this.listener.mouseClicked(he);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (HotspotManager.this.listener == null) {
                    return;
                }
                if (!HotspotManager.this.imageViewer.doCreateHotspotEvents()) {
                    return;
                }
                IHotspot hotspot = HotspotManager.this.getHotspotUnderMouse(e.getX(), e.getY());
                if (hotspot == null) {
                    return;
                }
                HotspotEvent he = new HotspotEvent(this, hotspot, e);
                HotspotManager.this.listener.mousePressed(he);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (HotspotManager.this.listener == null) {
                    return;
                }
                if (!HotspotManager.this.imageViewer.doCreateHotspotEvents()) {
                    return;
                }
                IHotspot hotspot = HotspotManager.this.getHotspotUnderMouse(e.getX(), e.getY());
                if (hotspot == null) {
                    return;
                }
                HotspotEvent he = new HotspotEvent(this, hotspot, e);
                HotspotManager.this.listener.mouseReleased(he);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.imageViewer.getRenderer().addMouseMotionListener(new MouseMotionListener(){
            IHotspot lastOver;

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                HotspotEvent he;
                if (HotspotManager.this.listener == null) {
                    return;
                }
                if (!HotspotManager.this.imageViewer.doCreateHotspotEvents()) {
                    return;
                }
                IHotspot hotspot = HotspotManager.this.getHotspotUnderMouse(e.getX(), e.getY());
                IHotspot merkLastOver = this.lastOver;
                if (this.lastOver != null && this.lastOver != hotspot) {
                    he = new HotspotEvent(this, this.lastOver, e);
                    HotspotManager.this.listener.mouseExited(he);
                    this.lastOver = null;
                }
                if (hotspot != null && merkLastOver != hotspot) {
                    he = new HotspotEvent(this, hotspot, e);
                    HotspotManager.this.listener.mouseEntered(he);
                    this.lastOver = hotspot;
                }
            }
        });
    }

    public synchronized void removeAllHotspots() {
        this.hotspots.clear();
    }

    @Override
    public IHotspot getHotspotUnderMouse(int mouseX, int mouseY) {
        Point2D.Float p = this.imageViewer.getImageSpaceCoordinates(new Point(mouseX, mouseY));
        Iterator<IHotspot> it = this.getHotspotIterator();
        while (it.hasNext()) {
            IHotspot hs = it.next();
            if (!hs.getShape().contains(p)) continue;
            return hs;
        }
        return null;
    }

    @Override
    public synchronized void addHotspotListener(HotspotListener l) {
        this.listener = HotspotEventMulticaster.add(this.listener, l);
    }

    @Override
    public synchronized void removeHotspotListener(HotspotListener l) {
        this.listener = HotspotEventMulticaster.remove(this.listener, l);
    }

    public synchronized void removeAllHotspotListener() {
        this.listener = null;
    }

    public synchronized void addHotspot(String id, int left, int top, int right, int bottom) {
        Hotspot hs = new Hotspot(id, left, top, right, bottom);
        this.hotspots.add(hs);
    }

    @Override
    public Iterator<IHotspot> getHotspotIterator() {
        return this.hotspots.iterator();
    }
}

